/****************************************************************************
 * trans64.c          version 1.5                                           *
 *                                                                          *
 * Lowlevelroutines for transfer 1541-PC                                    *
 *                                                                          *
 * Copyright (C) 1994  Bernhard Schwall                                     *
 *                                                                          *
 * This file is distributed WITHOUT ANY WARRANTY; without even the implied  *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         *
 ****************************************************************************/

#include <dos.h>
#ifdef __GNUC__
#include <pc.h>
#define near
#endif
#include "trans64.h"

typedef unsigned char byte;

static int PortAdr;                        /* address of selected port     */
static int WC;                             /* Clock                        */
static int WD;                             /* Data                         */
static int WA;                             /* ATN                          */

static int Fehler;
static int Verz=60;                        /* new 21.07.1994, before 32    */
static int PortCount=1;                    /* number of portaccesses per   */
                                           /* required access              */

static byte Byte94, Byte95, ByteA3;        /* flags for transfer (see C64) */
static byte Prt;                           /* contents of the port         */
static byte AnzOpen;                       /* number of open channels      */
static byte Tabelle[11][3];                /* for open                     */

static void near Eins(byte Value);
static void near All1(void);
static void near SEI(byte Value);

static int TimeOut=1500;

void WaitHI(byte len){                     /* delay (256*len)/1.193 ms     */
  byte kt, j1;
  outportb(0x43,0xa2);
  outportb(0x42,len);                      /* (256*len)/1.193 ms delay     */
  kt = inportb(0x61);
  outportb(0x61,kt | 1);                   /* start with bit 0 port 61 = 1 */
  outportb(0x61,kt);
  do {
    j1 = inportb(0x42);                    /* 255 when ready               */
  } while (j1 < 245);
}

void WaitLO(int len){                      /* delay len/1.193 ms           */
  int count;
  byte kt, j1;

  for (count=0; count<= (len >> 7); count++){
    outportb(0x43,0x92);
    outportb(0x42,len & 127);
    kt = inportb(0x61);
    outportb(0x61,kt | 1);                 /* start                        */
    outportb(0x61,kt);                     /* reset timer                  */
    do{
      j1 = inportb(0x42);                  /* 255 when ready               */
    } while (j1 < 250);
  }
}

void near SEI(byte Value){
  byte ka;
  do{                                      /* in C64 SEI !!                */
    ka = inportb(0x40);                    /* mode timer = LB/HB           */
    ka = inportb(0x40);                    /* query 2.byte = HB            */
  } while (ka < Value);
}

void Keyboard(byte on){                    /* turn keyboard on and off     */
  if (on == 0){
    outportb(0x64, 0xad);
  }
  else{
    outportb(0x64, 0xae);
  }
}

void port_out(int PortNr, unsigned char Value){
/* new 28.11.1994 */
  int i;
  for (i=0; i<PortCount; i++)
    outportb(PortNr, Value);
}

int port_in(int PortNr){
/* new 28.11.1994 */
  int i, Value;
  for (i=0; i<PortCount; i++)
    Value = inportb(PortNr);
  return Value;
}

void IECopen(byte Kanal, byte Geraet, byte *SekAdr, char *Text){
  Fehler = 0;
  if (*SekAdr > 127){
    Fehler = 4;
    return;
  }
  if (*Text == 0){
    return;
  }
  Listen(Geraet);
  if (Fehler != 0){
    if (Fehler == 10){
      Fehler = 0;
      Listen(Geraet);
      if (Fehler != 0){
        if (Fehler == 10)
          Fehler = 1;                    /* timeout => wrong device number */
        CLRCH();
        return;
      }
    }
    else{
      CLRCH();
      return;
    }
  }
  *SekAdr |= 0xf0;
  Seklist(*SekAdr);
  if (Fehler != 0){
    CLRCH();
    return;
  }
  while (*Text != 0){
    IECout(*Text++);
    if (Fehler != 0) break;
  }
  if (Fehler != 0){
    CLRCH();
    return;
  }
  Unlisten();
  WaitHI(0x10);                            /* 3,4 ms delay                 */
}

void CLRCH(){
  int xx = Fehler;
  Fehler = 0;
  Unlisten();
  Untalk();
  Fehler = xx;
}

void Talk(byte Value){
  Fehler = 0;
  Eins(Value | 0x40);
}

void Listen(byte Value){
  Fehler = 0;
  Eins(Value | 0x20);
}

void near Eins(byte Value){
  if (Byte94 > 0){
    ByteA3 = 1;
    ByteOut(Byte95);
    Byte94 = 0;
    ByteA3 = 0;
  }
  if (Fehler != 0) return;                 /* error in ByteOut             */
  Byte95 = Value;
  Data(1);
  ATN(0);
  Clock(0);
  Data(1);
  WaitHI(4);                               /* 0,86ms delay                 */
  ByteOut(Value);
}

void SekTalk(byte Value){                  /* Secondarry address to TALK   */
  int t;
  Fehler = 0;
  Byte95 = Value;
  SEI(25);                                 /* 50 (old value)               */
  Clock(0);
  Data(1);
  WaitHI(0x04);                            /* 0,86ms delay                 */
  ByteOut(Value);
  if (Fehler != 0) return;
  Data(0);
  ATN(1);
  Clock(1);
  t = 0;
  do{                                      /* wait until Clock = 0         */
    t++;
  }while (((port_in(PortAdr) & WC) == 0) && (t < TimeOut));
  /* neu 13.10.1994 */
  if (t > (TimeOut-1)){
    Fehler = 10;
    All1();
  }
}

void Seklist(byte Value){                  /* Secondarry address to LISTEN */
  Fehler = 0;
  Byte95 = Value;
  Clock(0);
  Data(1);
  WaitHI(0x04);                            /* 0,86ms delay                 */
  ByteOut(Value);
  WaitHI(4);
  ATN(1);
}

void Unlisten(){
  Fehler = 0;
  Eins(0x3f);
  All1();
}

void near All1(){
  ATN(1);
  WaitLO(2*Verz);                          /* delay (should be 40 s)      */
  Clock(1);
  Data(1);
}

void Untalk(){
  Fehler = 0;
  Clock(0);
  ATN(0);
  Eins(0x5f);
  All1();
}

void Data(byte Value){
  if (Value == 0) Prt |= WD;
  else           Prt &= ~WD;
  port_out(PortAdr,Prt);
}

void Clock(byte Value){
  if (Value == 0) Prt |= WC;
  else           Prt &= ~WC;
  port_out(PortAdr,Prt);
}

void ATN(byte Value){
  if (Value == 0) Prt |= WA;
  else           Prt &= ~WA;
  port_out(PortAdr,Prt);
}

byte Entpr(){
  byte ka, kb;
  do{                                      /* swapped 18.07.1994           */
    WaitLO(Verz/2);                        /* ^^^^^^^^^^                   */
    ka = port_in(PortAdr) & 0x0b;          /* Bits 0,1,3                   */
    WaitLO(Verz/2);                        /* delay                        */
    kb = port_in(PortAdr) & 0x0b;
  } while (ka != kb);
  WaitLO(Verz);                       /* 16.06.1994, before WitLO(Verz/2); */
  return kb;
}

void IECout(byte Value){
  if (Byte94 > 0){
    ByteOut(Byte95);
  }
  else
    Byte94 = 1;
  Byte95 = Value;
}

void ByteOut(byte Value){
  byte ka, kb, kt, j1, Bit;
  int t;
  /*SEI(35);*/                             /* 16.06.1994 del. 17.11.1994   */
  Fehler = 0;
  Data(1);
  WaitLO(Verz/2);                          /* new 17.11.1994               */
  WaitLO(Verz*2);                          /* new 17.11.1994               */
  ka = port_in(PortAdr) & 0x0b;            /* Bits 0,1,3                   */
  if ((ka & WD) == 0){
    Fehler = 5;
    All1();
    return;
  }
  Clock(1);
  if (ByteA3 > 0){
    WaitLO(Verz/2);                        /* new 17.11.1994               */
    t = 0;
    do{
      t++;
      ka = port_in(PortAdr) & WD;          /* wait until Data=1            */
    } while ((ka > 0) && (t < TimeOut));
    if (t > (TimeOut-1)){                  /* new 13.10.1994               */
      Fehler = 10;
      All1();
      return;
    }
    t = 0;
    do{
      t++;
      ka = port_in(PortAdr) & WD;          /* wait until Data=0            */
    } while ((ka == 0) && (t < TimeOut));
    if (t > (TimeOut-1)){
      Fehler = 10;
      All1();
      return;
    }
  }
  outportb(0x43,0xa2);
  outportb(0x42,250);
  kt = inportb(0x61);
  outportb(0x61,kt | 1);
  outportb(0x61,kt);
  t = 0;
  do{
    if (inportb(0x42) == 255){
      t++;
      outport(0x42, 250);
    }
    ka = port_in(PortAdr) & WD;            /* wait until Data=1            */
  } while ((ka > 0) && (t < TimeOut));
  if (t > (TimeOut-1)){
    Fehler = 9;
    All1();
    return;
  }
  Clock(0);
  for (Bit=0; Bit<8; Bit++){
    WaitLO(Verz/2);                        /* new 17.11.1994               */
    WaitLO(Verz);                          /* new 17.11.1994               */
    if ((port_in(PortAdr) & WD) > 0){      /* Data=0                       */
      Fehler = 3;
      break;
    }
    WaitLO(Verz);
    Data(Value & 1);                       /* Data = 1 when Arg not 0      */
    Value >>= 1;
    Clock(1);
    WaitLO(Verz/2);
    Prt = (Prt & ~WD) | WC;                /* Data=1 and Clock=0           */
    port_out(PortAdr,Prt);
  }
  if (Fehler != 0){
    All1();
    return;
  }

  WaitLO(Verz*2);
  /*WaitLO(Verz*2);*/                      /* only for 1541 (del. 17.11.94)*/

  outportb(0x43,0xa2);
  outportb(0x42,5);
  kt = inportb(0x61);
  outportb(0x61,kt | 1);
  outportb(0x61,kt);
  do{
    ka = port_in(PortAdr) & 0x0b;
    kb = port_in(PortAdr) & 0x0b;
    j1 = inportb(0x42);
    if ((ka == kb) && ((ka & WD) != 0)) break;
    if (j1 > 199) break;
  } while (1 == 1);
  if (j1 > 199){
    Fehler = 10;
    All1();
  }
  /*WaitLO(Verz/2);*/                      /* new 18.07.1994, del.17.11.94 */
}

byte IECin(){
  byte ka, kt, A4=0, WCoD = WC | WD;
  int i=0, t;
  Fehler = 0;
  WaitLO(Verz);  /* neu 16.06.1994 */
  Clock(1);
  do{
    ka = port_in(PortAdr) & WC;
  } while (ka > 0);                         /* wait until Clock(in)=1      */
  kt = inportb(0x61);
  WaitLO(Verz);
  SEI(35);                                 /* 16.06.1994  before 25        */
  outportb(0x43,0xa2);                     /* HB read/write, MF 2          */
  outportb(0x42,0x02);                     /* HB = 10, = 2,1 ms            */
  outportb(0x61, kt | 1);                  /* start MF 2 Bit 0 Port 61=1   */
  outportb(0x61, kt);                      /* write back original value    */
  do{
    Clock(1);
    Data(1);
    do{
      ka = port_in(PortAdr) & WC;
    } while ((ka == 0) && (inportb(0x42) < 200));    /* until Clock = 0    */
    ka = port_in(PortAdr) & WC;                      /* new 13.10.1994     */
    if (ka > 0){
      for (i=0; i<8; i++){
        t = 0;
        do{
          t++;
          ka = port_in(PortAdr) & (WCoD);
        } while (((ka & WC) != 0) && (t < TimeOut));  /* until Clock = 1   */
        ka = port_in(PortAdr) & (WCoD);               /* new 13.10.1994    */
        if (t > (TimeOut-1)){
          Fehler = 11;
          All1();
          return 0;
        }
        A4 >>= 1;
        if (ka == 0) A4 |= 128;
        t = 0;
        do{
          t++;
        }while (((port_in(PortAdr) & WC) == 0) && (t < TimeOut));
                                           /* until Clock = 0              */
        if (t > (TimeOut-1)){
          Fehler = 11;
          All1();
          return 0;
        }
      }
      Data(0);
      if (Fehler == 64){                   /* EOF                          */
        WaitLO(Verz*2);                    /* 215 s delay                 */
        Clock(1);
        Data(1);
      }
      else if (Fehler > 0){
        WaitLO(Verz*2);
        All1();
      }
      return A4;
    }
    else{
      if (i > 0){
        Fehler = 11;                       /* time out, e.g. not found     */
        break;
      }
      Fehler = 64;
      i = 1;
      Data(0);                             /* Data=0; Clock=1              */
      WaitLO(Verz*2);
    }
  } while (1 > 0);
  return A4;
}

void Open64(byte Kanal, byte Geraet, byte *SekAdr, char *Text){
  byte g,s;
  if (Kanal == 0){                         /* logFileNr missing            */
    Fehler = 6;
    return;
  }
  GetFileTab(Kanal, &g, &s);
  if (Fehler == 0){                        /* still open                   */
    Fehler = 7;
    return;
  }
  Fehler = 0;
  if (AnzOpen >= 10){                      /* too much files open          */
    Fehler = 8;
    return;
  }
  *SekAdr |= 0x60;
  s = *SekAdr;
  IECopen(Kanal, Geraet, SekAdr, Text);
  if (Fehler == 0){
    AnzOpen++;
    Tabelle[AnzOpen][0] = Kanal;
    Tabelle[AnzOpen][1] = s;
    Tabelle[AnzOpen][2] = Geraet;
  }
}

void Close64(byte Kanal){
  byte n, m, Geraet, SekAdr, TabNr;
  TabNr = GetFileTab(Kanal, &Geraet, &SekAdr);
  if (Fehler == 12){                       /* not found = ready             */
    Fehler = 0;
    return;
  }
  if (SekAdr < 128){
    Listen(Geraet);
    Seklist((SekAdr & 0xef) | 0xe0);
    Unlisten();
  }
  AnzOpen--;
  if (AnzOpen == 0){
    Tabelle[1][0] = 0;
    Tabelle[1][1] = 0;
    Tabelle[1][2] = 0;
    return;
  }
  for (n=TabNr; n<=(AnzOpen+1); n++){
    for (m=1; m<2; m++)
      Tabelle[n][m] = Tabelle[n+1][m];
  }
}

byte GetFileTab(byte Kanal,byte *Geraet,byte *SekAdr){
  byte S;
  Fehler = 0;                              /* S=No. or entrys              */
  for (S=1; S<=AnzOpen; S++){
    if (Tabelle[S][0] == Kanal) break;
  }
  if (S > AnzOpen){                        /* not found                    */
    Fehler = 12;
    *Geraet = 0;
    *SekAdr = 0;
  }
  else{
    *SekAdr = Tabelle[S][1];
    *Geraet = Tabelle[S][2];
  }
  return S;
}

byte Get64(byte Kanal){                         /* Get #Byte            */
  byte xx, GetA, Geraet, SekAdr;
  GetFileTab(Kanal, &Geraet, &SekAdr);
  Talk(Geraet);
  SekTalk(SekAdr);
  GetA = IECin();
  WaitLO(Verz);
  xx = Fehler;
  Untalk();
  Fehler = xx;
  return GetA;
}

unsigned int GetBlock64(byte Kanal, byte *text, unsigned int count){
  unsigned int Anzahl;
  byte Geraet, SekAdr;
  GetFileTab(Kanal, &Geraet, &SekAdr);
  Talk(Geraet);
  SekTalk(SekAdr);
  for (Anzahl=0; Anzahl < count; Anzahl++){
    *text++ = IECin();
    if (Fehler > 0) break;
  }
  return (Anzahl+1);
}

void Print64(byte Kanal, byte *text, unsigned int count){ /* jsr FFD2   */
  byte xx, Geraet, SekAdr;
  GetFileTab(Kanal, &Geraet, &SekAdr);
  if (Fehler != 0) return;
  Listen(Geraet);
  if (Fehler == 10){
    Fehler = 0;
    Listen(Geraet);
  }
  if (Fehler != 0) return;
  Seklist(SekAdr);
  if (Fehler != 0) return;
  while (count-- > 0) {
    IECout(*text++);
    if ((Fehler & 15) > 0) break;
  }
  WaitLO(Verz);
  xx = Fehler;
  Unlisten();
  Fehler = xx;
  /*WaitHI(0x23);*/                        /* 7,5 ms delay                 */
  WaitHI(0x04);
}

void Message64(byte Geraet, char *Text){
  byte xx, SekAdr;
  SekAdr = 15 | 0x60;
  Open64(10,Geraet, &SekAdr,"");
  if (Fehler > 0) return;
  Talk(Geraet);
  if (Fehler != 0){
    return;
  }
  SekTalk(SekAdr);
  if (Fehler != 0) return;
  do{
    xx = IECin();
    if (Fehler > 0) break;
    if (xx < 122) *Text++ = xx;
  }while (1 == 1);
  WaitLO(Verz);
  xx = Fehler;
  Untalk();
  Close64(10);
  Fehler = xx;
  *Text = 0;
}

void SendCommand(byte Geraet, char *text){
  byte i, SekAdr;
  SekAdr = 15 | 0x60;
  Open64(10,Geraet, &SekAdr,text);
  if (Fehler>0) return;
  if (*text == 'U'){
    text++;
    if ((*text == 'I') || (*text == '.')){
      /* bei reset mind. 4 Sekunden warten */
      for (i=0; i<118; i++){
        WaitHI(198);                       /* 118*42,5ms nearly 5 sec      */
      }
    }
  }
  Close64(10);
}

byte Error(){
  return Fehler;
}

void SetError(byte Value){
  Fehler = Value;
}

void GetCableValues(byte *aWA, byte *aWC, byte *aWD, unsigned int *aPortAdr){
  *aWA = WA;
  *aWC = WC;
  *aWD = WD;
  *aPortAdr = PortAdr;
}

void SetVerz(int Value){
  Verz = Value;
  if (Verz < 2) Verz = 2;
  if (Verz > 16383) Verz = 16383;          /* changed 14.12.1994           */
  TimeOut = 200*Verz;                      /* new 28.07.1994 changed 14.12.*/
}

void SetPortCount(int Value){
/* new 28.11.1994 */
  if (Value < 1) Value = 1;
  if (Value > 255) Value = 255;
  PortCount = Value;
}

int Init64(int PortNr, byte Cable){
  if (PortNr < 5) {
    PortNr--;                         /* LPT1 = 40:08/09, LPT2 = 40:0A/0B  */
#ifdef __GNUC__
    PortAdr = (*(short *)(0xe0000000+0x408+2*PortNr))+2;
#else
    PortAdr = peek(0x40,0x08+2*PortNr)+2;
#endif
  }
  else PortAdr = PortNr+2;
  if (PortAdr == 2) return 0;         /* 2 wegen peek + 2                  */
  Byte94 = port_in(PortAdr-2);        /* test ob adresse beschaltet        */
  port_out(PortAdr-2, ~Byte94);
  if (Byte94 == port_in(PortAdr-2)) return 0;
  Prt = 0xe4;
  port_out(PortAdr, Prt);             /* ATN, Clock and Data = 1           */
  port_out(PortAdr-2, 0);             /* set dataport to 0 for 1541P-Kabel */
  outportb(0x61, inportb(0x61) & 0xfe);
                                      /* Timer zurcksetzen                */
  AnzOpen = 0;                        /* no file open                      */
  Byte94 = 0;                         /* set all flags 0                   */
  Byte95 = 0;
  ByteA3 = 0;
  if (Cable == 0){                    /* DISK64E kable   PC  1541          */
    WC = 1;                           /* Clock = Bit 0,   1    4           */
    WD = 2;                           /* Data  = Bit 1,  14    5           */
    WA = 8;                           /* ATN   = Bit 3   17    3           */
  }
  else{                               /* X1541 kable     PC  1541          */
    WC = 2;                           /* Clock = Bit 1   14    4           */
    WD = 8;                           /* Data  = Bit 3   17    5           */
    WA = 1;                           /* ATN   = Bit 0    1    3           */
  }
  TimeOut = 200*Verz;                 /* new 28.07.1994 changed 14.12.1994 */
  Fehler = 0;
  return PortAdr;
}

