/****************************************************************************
 * tr_demo.cc         version 1.2                                           *
 *                                                                          *
 * program to demonstrate the usege of trans64.c                            *
 *                                                                          *
 * Copyright (C) 1994  Bernhard Schwall                                     *
 *                                                                          *
 * This file is distributed WITHOUT ANY WARRANTY; without even the implied  *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         *
 ****************************************************************************/

/* Could cause trouble if not using Borland C++ or GNU C++. If so remove    */
/* this line and the lines with 'gotoxy(....)'. This will show the block    */
/* counting line by line and not in the same line.                          */
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "trans64.h"

int  DirCount;                  // number of directoryentries
char DiskName[50];
struct { int  FileSize;
         char FileName[20];
         char FileTyp[20];
} DirEntry[144];

typedef struct { void  *next;
                 short count;
                 byte  Sector[256];
} TSector;
int Devicenumber = 8;

void Directory(){
// read the directory from a open device
  char *tmp;
  byte nx, Quote, Tp, w;
  int  Size;
  for (nx=1; nx <=5; nx++){
    IECin();
    if (Error() > 0) return;
  }
  tmp = DiskName;
  do{
    w = IECin();
    if (w > 31) *tmp++ = w;
    if (w == 0) break;
    if (Error() > 0) return;
  } while (1==1);
  *tmp = 0;
  DirCount = 0;
  do{
    w = IECin();
    if ((Error()>0) || (w == 0)) break;
    IECin();
    if (Error()>0) break;
    Size = IECin();
    if (Error()>0) break;
    Size += 256*IECin();
    if (Error()>0) break;
    DirEntry[DirCount].FileSize = Size;
    Quote = 0;
    Tp = 0;
    tmp = DirEntry[DirCount].FileName;
    *tmp = 0;
    do{
      w = IECin();
      if (Error()>0) break;
      if (Quote > 0) *tmp++ = w;
      if (w == 34){
        Quote = Quote ^ 1;
        if (Quote == 0){
          Tp = 1;
          *--tmp = 0;
          tmp = DirEntry[DirCount].FileTyp;
        }
      }
      if (Tp == 1){
        if (w > 34) *tmp++ = w;
      }
      if (w == 0) break;                       // Nullen am Ende
    } while (1==1);
    *tmp = 0;
    DirCount++;
    if (Error()>0) break;
  } while (1==1);
  strcpy(DirEntry[DirCount-1].FileName,"Blocks Free.");
  *DirEntry[DirCount-1].FileTyp = 0;
}

void ReadDirectory(byte Devicenumber){
// read the dircetory from 'Devicenumber'
  byte xx, SecAdr;
  SetError(0);
  SecAdr = 0;
  IECopen(0, Devicenumber, &SecAdr, "$");
  if (Error() != 0) return;
  Talk(Devicenumber);
  if (Error() != 0) return;
  SekTalk(SecAdr);
  if (Error() == 0){
    IECin();
    if (Error() == 0){
      IECin();
      if (Error() == 0){
        Directory();
      }
    }
  }
  xx = Error();
  SetError(0);
  Untalk();
  Listen(Devicenumber);
  Seklist((SecAdr & 0xef) | 0xe0);
  Unlisten();
  SetError(xx);
}

void itoa(int nr, char *dest)
// convert 'nr' to string '*dest'
{ int length=0;
  char tmp[10];
  char *src;

  src=tmp;
  if (nr == 0) { *dest++ = '0';
		 *dest = 0;
  		 return;
	       }
  while (nr > 0)
  { *src++ = (0x30+ (char)(nr % 10));
    length++;
    nr /= 10;
  }
  while (length>0)
  { *dest++ = *--src;
    length--;
  }
  *dest = 0;
}

TSector *LoadFile(char *FileName, byte Devicenumber){
// Load the file 'FileName' from 'Devicenumber'
  TSector *program, *ActSector;
  byte ActByte, Device, SecAdr;
  int j1, j;
  char str[24];

  strcpy(str,"0:");
  strcat(str,FileName);

  Keyboard(0);
  program = new TSector;
  ActSector = program;
  SecAdr = 2;
  Open64(8,Devicenumber, &SecAdr,str);
  GetFileTab(8, &Device, &SecAdr);
  Talk(Device);
  SekTalk(SecAdr);
  j = 1;
  printf("\n");
  do{
    for (ActByte=0; ActByte<254; ActByte++){
      ActSector->Sector[ActByte] = IECin();
      if (((Error() & 15) > 0) || (Error() == 64)) break;
    }
    if (Error() != 64){
      ActSector->count = 254;
      ActSector->next = new TSector;
      ActSector = (TSector *) ActSector->next;
      ActSector->next = NULL;
    }
    if ((Error() != 64) && (Error() != 0)){
      printf("Error = %i   ActByte = %i\n",Error(), ActByte);
    }
    gotoxy(1,wherey()-1);
    printf("%i\n",j++);
  } while (Error() == 0);
  ActSector->count = ActByte;
  j1 = Error();
  SetError(0);
  Untalk();
  Close64(8);
  Keyboard(1);
  SetError(j1);
  return program;
}

int TrackSekt(int &Track, int &Sector){
// calculate the next valid track and sector
  int OK=1;
  if (Track < 18){
    if (Sector < 20){ Sector++;}
    else{
      Track++;
      Sector = 0;
    }
  }
  else{
    if (Track < 25){
      if (Sector < 18){ Sector++;}
      else{
        Track++;
        Sector = 0;
      }
    }
    else{
      if (Track < 31){
        if (Sector < 17){ Sector++;}
        else{
          Track++;
          Sector = 0;
        }
      }
      else{
        if (Sector < 16){ Sector++;}
        else{
          Track++;
          Sector = 0;
          if (Track > 35){ OK = 0;}
        }
      }
    }
  }
  return OK;
}

void FullSector(byte Channel, TSector *ActSector){
// transfer one sector from the buffer opened for 'Channel' to 'ActSector'
  int gi;
  byte xx, Device, SecAdr;

  GetFileTab(Channel, &Device, &SecAdr);
  Talk(Device);
  SekTalk(SecAdr);
  for (gi=0; gi<256; gi++){
    ActSector->Sector[gi] = IECin();
    if ((Error() & 15) > 0) break;
  }
  xx = Error();
  Untalk();
  SetError(xx);
}

TSector *TransferDisk(byte Devicenumber){
// read the whole disk from the device 'Devicenumber'
  TSector *Disk, *ActSector;
  char num1[6], num2[6], Bef[30];
  byte xx, SecAdr;
  int Track=1, Sector=-1;

  SendCommand(Devicenumber, "I");
  if ((Error() & 15)>0) return NULL;
  SecAdr = 15;
  Open64(15,Devicenumber, &SecAdr,"");       // open 15,8,15
  if ((Error() & 15) > 0){
    xx = Error();
    // Close64(5);
    Close64(15);
    SetError(xx);
    return NULL;
  }
  SecAdr = 5;
  Open64(5,Devicenumber, &SecAdr,"#");        // open 5,8,5,"#" ; buffer
  if ((Error() & 15) > 0){
    xx = Error();
    Close64(5);
    Close64(15);
    SetError(xx);
    return NULL;
  }
  Disk = new TSector;
  ActSector = Disk;
  do{
    if (TrackSekt(Track, Sector) == 0) break; // next track/Sector-number
    gotoxy(1, wherey());
    printf("T = %X  S = %X   ",Track,Sector);
    strcpy(Bef,"U1 5 0 ");
    itoa(Track,num1);
    itoa(Sector,num2);
    strcat(Bef,num1);
    strcat(Bef," ");
    strcat(Bef,num2);
    Print64(15,Bef,strlen(Bef));
    if ((Error() & 15) > 0) break;
    FullSector(5, ActSector);
    ActSector->count = 256;
    if (!((Track == 35) && (Sector == 16))){
      ActSector->next = new TSector;
      ActSector = (TSector *)ActSector->next;
      ActSector->next = NULL;
    }
    if ((Error() & 15) > 0) break;
  } while (1 == 1);
  xx = Error();
  Close64(5);
  Close64(15);
  SetError(xx);
  return Disk;
}

void SaveDisk(TSector *Disk, char *Name){
// save 'Disk' as 'Name'
  TSector *ActSector;
  FILE *dest;
  int i;
  dest = fopen(Name,"wb");
  for(i=0; i<683; i++){
    fwrite(Disk->Sector,Disk->count,1,dest);
    ActSector = Disk;
    Disk = (TSector *) Disk->next;
    if (Disk == NULL) break;
  }
  fclose(dest);
}

void DelDisk(TSector *Disk){
// delete the internal file 'Disk'
  TSector *ActSector;
  while (Disk != NULL){
    ActSector = Disk;
    Disk = (TSector *) Disk->next;
    delete ActSector;
  }
}

int main(int argc, char *argv[]){
  int PortNr, j1;
  TSector *Disk;
  char Text[80];
  int  Pin;
  int  Delay=80;
  int  DelVLB=1;
  char ch;

  // set here the standard port (1-3 = BIOS LPT 1-3, for more see trans64.c)
  if (argc == 1){
    printf("TR_DEMO port [delay, [VLBdelay]]\n");
    printf("       port     : 1, 2 or 3   LPT where the cable is connected to\n");
    printf("       delay    : 5..120      delay for the transfer\n");
    printf("       VLBdelay : 1..250      delay if the LPT is on a VLB slot\n");
    return 0;
  }
  else{
    PortNr = (*argv[1])-0x30;
    if (argc > 2){
      Delay = atoi(argv[2]);
      if (argc > 3) DelVLB = atoi(argv[3]);
    }
  }
  // set here the cable used for the connection
  Pin = Init64(PortNr, CableX1541);
  SetVerz(Delay);                    /* between 2 and 120, usefull 35-120  */
  SetPortCount(DelVLB);              /* 1 for ISA bus, 4-255 of VLB or PCI */

  clrscr();
  do{
    printf("\n");
    printf("1541 at LPT%i ($%x)  delay = %i  VLBdelay = %i\n",
           PortNr, Pin, Delay, DelVLB);
    printf("(1) dircetory\n");
    printf("(2) read first file of the disk\n");
    printf("(3) read whole disk\n");
    printf("(4) message\n");
    printf("(5) quit\n");
    ch = getch();
    printf("\n");
    if (ch == '1'){
      ReadDirectory(Devicenumber);
      printf("directory of:\n");
      printf("%s\n",DiskName);
      for (j1=0; j1<DirCount; j1++){
        printf("%-4i  %-16s  %s\n",DirEntry[j1].FileSize,
                                   DirEntry[j1].FileName,
                                   DirEntry[j1].FileTyp);
      }
    }
    if (ch == '2'){
      ReadDirectory(Devicenumber);
      printf("loading %s (%i blocks)\n",DirEntry[0].FileName,
                                     DirEntry[0].FileSize);
      Disk = LoadFile(DirEntry[0].FileName, Devicenumber);
      DelDisk(Disk);
    }
    if (ch == '3') { Disk = TransferDisk(Devicenumber);
                     SaveDisk(Disk,"testdisk.d64");
                     DelDisk(Disk);
                   }
    if (ch == '4') { Message64(Devicenumber, Text);
                     printf("%s\n",Text);
                   }
    if ((Error() & 15) != 0) printf("\nerror = %i\n\n",Error());
  } while (ch != '5');
  return 0;
}
