/*
 *  Copyright (c) 2008 Atheros Communications Inc.  All rights reserved.
 */

/*
 * Public Interface for slow antenna diversity control module
 */

#ifndef _DEV_ATH_ANTDIV_H
#define _DEV_ATH_ANTDIV_H

#define ATH_ANT_DIV_MAX_CFG   2
#define ATH_ANT_DIV_MAX_CHAIN 3

typedef enum {
    ATH_ANT_DIV_IDLE,
    ATH_ANT_DIV_SCAN,     /* evaluating antenna */
} ATH_ANT_DIV_STATE;

struct ath_antdiv {
    struct ath_softc        *antdiv_sc;
    u_int8_t                antdiv_start;
    ATH_ANT_DIV_STATE       antdiv_state;
    u_int8_t                antdiv_num_antcfg;
    u_int8_t                antdiv_curcfg;
    u_int8_t                antdiv_bestcfg;
    int8_t                  antdiv_rssitrig;
    u_int32_t               antdiv_min_dwell_time;
    u_int32_t               antdiv_settle_time;
    int8_t                  antdiv_lastbrssictl[ATH_ANT_DIV_MAX_CHAIN][ATH_ANT_DIV_MAX_CFG];
/* not yet
    int8_t                  antdiv_lastbrssi[ATH_ANT_DIV_MAX_CFG];
    int8_t                  antdiv_lastbrssiext[ATH_ANT_DIV_MAX_CHAIN][ATH_ANT_DIV_MAX_CFG];
 */
    u_int64_t               antdiv_lastbtsf[ATH_ANT_DIV_MAX_CFG];
    u_int64_t               antdiv_laststatetsf;   
    u_int8_t                antdiv_bssid[IEEE80211_ADDR_LEN];
};

void ath_slow_ant_div_init(struct ath_antdiv *antdiv, struct ath_softc *sc, int32_t rssitrig,
                           u_int32_t min_dwell_time, u_int32_t settle_time);
void ath_slow_ant_div_start(struct ath_antdiv *antdiv, u_int8_t num_antcfg, const u_int8_t *bssid);
void ath_slow_ant_div_stop(struct ath_antdiv *antdiv);
void ath_slow_ant_div(struct ath_antdiv *antdiv, struct ieee80211_frame *wh, struct ath_rx_status *rx_stats);

#endif