#include <osdep.h>

/* return bus cachesize in 4B word units */
void
bus_read_cachesize(osdev_t osdev, int *csz)
{
    u_int8_t  u8tmp;

    pci_read_config_byte((struct pci_dev *)osdev->bdev, PCI_CACHE_LINE_SIZE, (u_int8_t *)&u8tmp);
    *csz = (int) u8tmp;
    /*
    ** This check was put in to avoid "unplesant" consequences if the bootrom
    ** has not fully initialized all PCI devices.  Sometimes the cache line size
    ** register is not set
    */
    
    if(*csz == 0){
        *csz = DEFAULT_CACHELINE >> 2;   // Use the default size
    }
}

