/*-
 * Copyright (c) 2006 Atheros Communications, Inc.
 * All rights reserved.
 */
#if 0

#ifndef EXPORT_SYMTAB
#define EXPORT_SYMTAB
#endif

#include <osdep.h>

#include <sys/cdefs.h>

/*
 * Packet Logging for Atheros driver
 */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/sysctl.h>
#include <sys/kpi_mbuf.h>
#include <sys/malloc.h>
#include <sys/lock.h>
#include <sys/kernel.h>
#include <sys/socket.h>
#include <sys/sockio.h>
#include <sys/errno.h>

#include <net/if.h>
#include <net/if_dl.h>
#include <net/if_media.h>
#include <net/if_types.h>
#include <net/if_arp.h>
#include <net/ethernet.h>
#include <net/if_llc.h>
#include <net/bpf.h>

#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

//#include "ieee80211_var.h"

#ifdef TIMER_TEST			/* GLC */
static void timer_test(void *);
#endif

#define	AR_DEBUG
#include "if_athrate.h"
#include "if_athvar.h"
#include "ah_desc.h"
#include "ah_devid.h"		/* XXX for softled */
#include "pktlog.h"
#include "pktlog_fmt.h"
#include "pktlog_rc.h"
#include "if_athioctl.h"


#endif // 0


#include <netinet/ip.h>
#include <netinet/tcp.h>

#include "ath_internal.h"
#include "pktlog_fmt.h"
#include "pktlog_i.h"

#define ATH_HAL_PS_WAKEUP(_scn)         ATH_PS_WAKEUP(ATH_DEV_TO_SC(_scn->sc_dev))
#define ATH_HAL_PS_SLEEP(_scn)          ATH_PS_SLEEP(ATH_DEV_TO_SC(_scn->sc_dev))

static int pktlog_attach(struct ath_softc *sc);
static void pktlog_detach(struct ath_softc *sc);

/* function protos */
extern void AirPort_AthrFusion__getPktlogClientAddr(void *__this, struct ath_pktlog_info *plinfo);
extern void AirPort_AthrFusion__freePktLog(void *__this);
extern int AirPort_AthrFusion__allocatePktLog(void *__this);

#define SC_TO_IC(_sc)         ((struct ieee80211com *)(_sc->sc_ieee))
#define IC_TO_SC(_ic)         ((struct ath_softc *)((struct ath_softc_net80211 *)(_ic))->sc_dev)

struct ath_pktlog_funcs g_exported_pktlog_funcs = {
    .pktlog_attach = pktlog_attach,
    .pktlog_detach = pktlog_detach,
    .pktlog_txctl = pktlog_txctl,
    .pktlog_txstatus = pktlog_txstatus,
    .pktlog_rx = pktlog_rx,
    .pktlog_text = pktlog_text
};

struct ath_pktlog_halfuncs g_exported_pktlog_halfuncs = {
    .pktlog_ani = pktlog_ani
};

struct ath_pktlog_rcfuncs g_exported_pktlog_rcfuncs = {
    .pktlog_rcupdate = pktlog_rcupdate,
    .pktlog_rcfind = pktlog_rcfind
};

extern struct ath_pktlog_info *g_pktlog_info;
extern int g_pktlog_mode;

/*
 * Initialize logging for system or adapter
 */

int pktlog_attach(struct ath_softc *sc)
{
    struct ath_softc_net80211 *scn = (struct ath_softc_net80211 *)sc->sc_ieee;

	PKTLOG_CHATTY_DEBUG(PKTLOG_TAG "%s, sc (%p)\n", __func__, sc);

	sc->pl_info = &scn->pl_info;
	pktlog_init(sc->pl_info);
    sc->pl_info->pl_sc = sc;
	g_pktlog_mode = PKTLOG_MODE_ADAPTER;
    
	return 0;
}

static
void pktlog_detach(struct ath_softc *sc)
{
	struct ath_pktlog_info *pl_info = sc->pl_info;

	PKTLOG_CHATTY_DEBUG(PKTLOG_TAG " %s\n", __func__);
	AirPort_AthrFusion__freePktLog(SC_TO_IC(sc)->ic_io80211);
	memset(pl_info, 0, sizeof(struct ath_pktlog_info));
}

static
int pktlog_reset(struct ath_softc *sc)
{
	struct ath_pktlog_info *pl_info = sc->pl_info;

	PKTLOG_CHATTY_DEBUG(PKTLOG_TAG "%s\n", __func__);
	pl_info->log_state = 0;
	if (pl_info->buf != NULL)
		pktlog_release_buf(pl_info);
	return 0;
}

/*
 * Disable a specific adapter logging.
 */
void
pktlog_disable_adapter_logging(void)
{
	printk("%s[%d] disabling the adapter not allowed\n", __func__, __LINE__);
}

/*
 * Helper functions.
 */
int
pktlog_alloc_buf(struct ath_softc *sc, struct ath_pktlog_info *pl_info)
{
	PKTLOG_CHATTY_DEBUG(PKTLOG_TAG "%s, sc (%p)\n", __func__, sc);
    
	printk("%s[%d] log state %x enabled buffer size %d\n", __func__, __LINE__,
                                pl_info->log_state,
                        	    pl_info->buf_size);
	if (AirPort_AthrFusion__allocatePktLog(SC_TO_IC(sc)->ic_io80211)) {
		return -ENOMEM;
	}

	return 0;
}

void pktlog_release_buf(struct ath_pktlog_info *pl_info)
{
    struct ath_softc *sc = pl_info->pl_sc;

	PKTLOG_CHATTY_DEBUG(PKTLOG_TAG " %s\n", __func__);

	if (sc->pl_info->buf) {
		AirPort_AthrFusion__freePktLog(SC_TO_IC(sc)->ic_io80211);
	}
}

/*
 * Reading the pktlog first disables the pktlogging facility
 * It is assumed the user program will parse the buffer properly
 * We simply return the current log buffer mapped to user space
 * We do not re-enable pktlogging automatically (different from linux
 * version)
 */

static
int pktlog_read(struct ath_softc *sc, struct ath_pktlog_info *destplinfo)
{
	struct ath_pktlog_info *pl_info = sc->pl_info;
	struct ath_pktlog_buf *log_buf = pl_info->buf;

	PKTLOG_CHATTY_DEBUG(PKTLOG_TAG " %s\n", __func__);

	if (log_buf == NULL)
		return 0;

	*destplinfo = *pl_info;
	if (pl_info->log_state) {
		pl_info->saved_state = pl_info->log_state;
		pl_info->log_state = 0;
	}
	AirPort_AthrFusion__getPktlogClientAddr(SC_TO_IC(sc)->ic_io80211, destplinfo);
	return 1;
}

int
pktlog_tcpip(struct ath_softc *sc, struct llc *llc, u_int32_t *proto_log, int *proto_len)
{
    struct ip *ip;
    struct tcphdr *tcp;
    u_int32_t *proto_hdr;
    int i;

    ip = (struct ip *)((u_int8_t *)llc + LLC_SNAPFRAMELEN);

    switch (ip->ip_p) {
    case IPPROTO_TCP:
        /* 
         * tcp + ip hdr len are in units of 32-bit words
         */ 
        tcp = (struct tcphdr *)((u_int32_t *)ip + ip->ip_hl);
        proto_hdr = (u_int32_t *)tcp;

        for (i = 0; i < tcp->th_off; i++) {
            *proto_log = ntohl(*proto_hdr);
            proto_log++, proto_hdr++;
        }
        *proto_len = tcp->th_off * sizeof(u_int32_t);
        return PKTLOG_PROTO_TCP;

    case IPPROTO_UDP:
    case IPPROTO_ICMP:
    default:
        *proto_len = 0;
        return PKTLOG_PROTO_NONE;
    }
}

int
ath_ioctl_pktlog(struct ieee80211com *ic, u_long cmd, caddr_t data)
{
	struct ath_softc *sc = IC_TO_SC(ic);
	int error = 0;
	struct ath_pktlog_ioctl *atpkt = (struct ath_pktlog_ioctl *) data;
	struct ath_pktlog_info destplinfo;

	if (cmd != SIOCGATHPKT) {
		return -ENXIO;
	}
	ATH_LOCK(sc->sc_osdev);
	ATH_PS_WAKEUP(sc);
	switch (atpkt->ap_cmd) {
	case ATH_PKT_ENABLE:
		error = pktlog_enable(sc, atpkt->ap_val);
		if(!error)
		{
			if(sc->pl_info->log_state & (ATH_PKTLOG_TX|ATH_PKTLOG_TX)) {
				sc->pl_info->options = ATH_PKTLOG_PROTO;
			}
			else
		    {
		    	sc->pl_info->options = 0;
			}
		}
        printk("%s[%d] enable cmd %d val %d error %d \n", __func__, __LINE__,
                                    atpkt->ap_cmd,
                                    atpkt->ap_val, error);
		break;
	case ATH_PKT_SETSIZE:
        printk("%s[%d] setsize cmd %d val %d\n", __func__, __LINE__,
                                    atpkt->ap_cmd,
                                    atpkt->ap_val);
		error = pktlog_setsize(sc, atpkt->ap_val);
		break;
	case ATH_PKT_RESET:
        printk("%s[%d] reset cmd %d val %d\n", __func__, __LINE__,
                                    atpkt->ap_cmd,
                                    atpkt->ap_val);
		error = pktlog_reset(sc);
		break;
	case ATH_PKT_READ:
		if ((atpkt->ap_data_size < sizeof(struct ath_pktlog_info)) ||
		    (atpkt->ap_data == NULL)) {
			error =  -ENOMEM;
			break;
		}
		if (!pktlog_read(sc, &destplinfo)) {
			error = -EINVAL;
			break;
		} else {
			error = copyout(&destplinfo, CAST_USER_ADDR_T(atpkt->ap_data),
					sizeof(struct ath_pktlog_info));
		}
		break;
	}
	ATH_PS_SLEEP(sc); // hw - XXX */
	ATH_UNLOCK(sc->sc_osdev);
	return error;
}


