/*
 * Copyright (c) 2002-2005 Sam Leffler, Errno Consulting
 * Copyright (c) 2002-2005 Atheros Communications, Inc.
 * All rights reserved.
 *
 */
#include "opt_ah.h"

#ifdef AH_SUPPORT_AR5212

#include "ah.h"
#include "ah_internal.h"
#include "ah_devid.h"
#ifdef AH_DEBUG
#include "ah_desc.h"			/* NB: for HAL_PHYERR* */
#endif
#include "ah_eeprom.h"

#include "ar5212/ar5212.h"
#include "ar5212/ar5212reg.h"
#include "ar5212/ar5212phy.h"
#ifdef AH_SUPPORT_AR5311
#include "ar5212/ar5311reg.h"
#endif

/*
 * Read 16 bits of data from offset into *data
 */
HAL_BOOL
ar5212EepromRead(struct ath_hal *ah, u_int off, u_int16_t *data)
{
	OS_REG_WRITE(ah, AR_EEPROM_ADDR, off);
	OS_REG_WRITE(ah, AR_EEPROM_CMD, AR_EEPROM_CMD_READ);

	if (!ath_hal_wait(ah, AR_EEPROM_STS,
	    AR_EEPROM_STS_READ_COMPLETE | AR_EEPROM_STS_READ_ERROR,
	    AR_EEPROM_STS_READ_COMPLETE, AH_WAIT_TIMEOUT)) {
		HDPRINTF(ah, HAL_DBG_EEPROM, "%s: read failed for entry 0x%x\n", __func__, off);
		return AH_FALSE;
	}
	*data = OS_REG_READ(ah, AR_EEPROM_DATA) & 0xffff;
	return AH_TRUE;
}

#ifdef AH_SUPPORT_WRITE_EEPROM
/*
 * Write 16 bits of data from data to the specified EEPROM offset.
 */
HAL_BOOL
ar5212EepromWrite(struct ath_hal *ah, u_int off, u_int16_t data)
{
    u_int32_t status;
    int to = 15000;     /* 15ms timeout */
    /* Add Nala's Mac Version (2006/10/30) */
    u_int32_t reg = 0;

    if (AH_PRIVATE(ah)->ah_isPciExpress) {
        /* Set GPIO 3 to output and then to 0 (ACTIVE_LOW) */
        if(IS_2425(ah)) {
            reg = OS_REG_READ(ah, AR_GPIOCR);
            OS_REG_WRITE(ah, AR_GPIOCR, 0xFFFF);
        } else {
            ar5212GpioCfgOutput(ah, 3, HAL_GPIO_OUTPUT_MUX_AS_OUTPUT);
            ar5212GpioSet(ah, 3, 0);
        }
        
    } else if (IS_2413(ah) || IS_5413(ah)) {
        /* Set GPIO 4 to output and then to 0 (ACTIVE_LOW) */
        ar5212GpioCfgOutput(ah, 4, HAL_GPIO_OUTPUT_MUX_AS_OUTPUT);
        ar5212GpioSet(ah, 4, 0);
    } else if (IS_2417(ah)){
        /* Add for Nala but not sure (2006/10/30) */
        reg = OS_REG_READ(ah, AR_GPIOCR);
        OS_REG_WRITE(ah, AR_GPIOCR, 0xFFFF);    
    }

    /* Send write data */
    OS_REG_WRITE(ah, AR_EEPROM_ADDR, off);
    OS_REG_WRITE(ah, AR_EEPROM_DATA, data);
    OS_REG_WRITE(ah, AR_EEPROM_CMD, AR_EEPROM_CMD_WRITE);

    while (to > 0) {
        OS_DELAY(1);
        status = OS_REG_READ(ah, AR_EEPROM_STS);
        if (status & AR_EEPROM_STS_WRITE_COMPLETE) {
            if (AH_PRIVATE(ah)->ah_isPciExpress) {
                if(IS_2425(ah)) {
                    OS_REG_WRITE(ah, AR_GPIOCR, reg);
                } else {
                    ar5212GpioSet(ah, 3, 1);
                }
            } else if (IS_2413(ah) || IS_5413(ah)) {
                ar5212GpioSet(ah, 4, 1);
            } else if (IS_2417(ah)){
                /* Add for Nala but not sure (2006/10/30) */
                OS_REG_WRITE(ah, AR_GPIOCR, reg);
            }
            return AH_TRUE;
        }

        if (status & AR_EEPROM_STS_WRITE_ERROR)    {
		    HDPRINTF(ah, HAL_DBG_EEPROM, "%s: write failed for entry 0x%x, data 0x%x\n",
			    __func__, off, data);
            return AH_FALSE;;
        }
        to--;
    }

	HDPRINTF(ah, HAL_DBG_EEPROM, "%s: write timeout for entry 0x%x, data 0x%x\n",
		__func__, off, data);

    if (AH_PRIVATE(ah)->ah_isPciExpress) {
        if(IS_2425(ah)) {
            OS_REG_WRITE(ah, AR_GPIOCR, reg);
        } else {
            ar5212GpioSet(ah, 3, 1);
        }
    } else if (IS_2413(ah) || IS_5413(ah)) {
        ar5212GpioSet(ah, 4, 1);
    } else if (IS_2417(ah)){
        /* Add for Nala but not sure (2006/10/30) */
        OS_REG_WRITE(ah, AR_GPIOCR, reg);
    }

    return AH_FALSE;
}
#endif /* AH_SUPPORT_WRITE_EEPROM */

#endif /* AH_SUPPORT_AR5212 */
