/*
 * Copyright (c) 2002-2005 Sam Leffler, Errno Consulting
 * Copyright (c) 2002-2005 Atheros Communications, Inc.
 * All rights reserved.
 */
#include "opt_ah.h"

#ifdef AH_SUPPORT_AR5416

#include "ah.h"
#include "ah_internal.h"

#include "ar5416/ar5416.h"
#include "ar5416/ar5416reg.h"
#include "ar5416/ar5416desc.h"

void
ar5416TimerStart(struct ath_hal *ah,
    u_int32_t timer_next, u_int32_t timer_period)
{
    struct ath_hal_5416 *ahp = AH5416(ah);
    u_int32_t tsf=0;;

        
    tsf = ar5416GetTsf32(ah);
    timer_next+=tsf;    
    HDPRINTF(ah, HAL_DBG_TIMER,
        "Starting timer: tsf: %u %u %u\n", tsf, timer_next, timer_period);
    OS_REG_WRITE(ah, AR_NEXT_NDP_TIMER, timer_next);
    OS_REG_WRITE(ah, AR_NDP_PERIOD, timer_period);

    /* enable timers */

    /* Secondary mask register*/

    OS_REG_WRITE(ah, AR_IMR_S5,
        OS_REG_READ(ah, AR_IMR_S5) | AR_IMR_S5_GENTIMER7);
    OS_REG_SET_BIT(ah, AR_TIMER_MODE,
        OS_REG_READ(ah, AR_TIMER_MODE) | AR_NDP_TIMER_EN);

    ahp->ah_maskReg |= AR_IMR_GENTMR;
    OS_REG_WRITE(ah, AR_IMR, ahp->ah_maskReg);
}

void
ar5416TimerStop(struct ath_hal *ah)
{
    /* enable timers */

    u_int32_t tmpReg = OS_REG_READ(ah, AR_TIMER_MODE) & (~AR_NDP_TIMER_EN);
    OS_REG_SET_BIT(ah, AR_TIMER_MODE, tmpReg);
}

#endif /* AH_SUPPORT_AR5416 */
