#
# Copyright (c) 2002-2005 Sam Leffler, Errno Consulting
# Copyright (c) 2002-2005 Atheros Communications, Inc.
# All rights reserved.
#
# $Id: //depot/sw/branches/fusion/common/lmac/hal/linux/Makefile.inc#11 $
#
HAL=	..
PUBLIC=	public
#
# Makefile for building the Atheros/MADWIFI HAL from source code on Linux.
#
# This file is intended to be called by the Makefile in the hal
# directory with TARGET set to the desired target platform.
#
# There is support for 4 "generations" of Atheros hardware devices:
#
# AH_SUPPORT_AR5210	802.11a only MAC
# AH_SUPPORT_AR5211	802.11a+802.11b MAC (also pure g, but not yet supported)
# AH_SUPPORT_AR5212	802.11a+802.11b+802.11g MAC
# AH_SUPPORT_AR5312     5212 MAC WiSoC (requires AH_SUPPORT_AR5212)
# AH_SUPPORT_AR5416	802.11a+802.11b+802.11g+802.11n-ready MAC
#
# AH_SUPPORT_5111	5111 RF support for 5212 et. al.
# AH_SUPPORT_5112	5112 RF support for 5212 et. al.
# AH_SUPPORT_2413	2413 RF support for 5212 et. al.
# AH_SUPPORT_5413	5413 RF support for 5212 et. al.
# AH_SUPPORT_2316	2416 RF (Cobra) support for 5212 et. al.
# AH_SUPPORT_2317	2417 RF (Cobra) support for 5212 et. al.
# AH_SUPPORT_2425       2425 RF (Swan/Nala) support for 5212 et. al.
# AH_SUPPORT_2133	2133 RF support for 5416 et. al.
#
# and numerous optional debugging facilities (typically named AH_DEBUG_*):
#
# AH_DEBUG		enables debugging stuff that's controlled by the sysctl:
# 			hw.ath.hal.debug
# AH_ASSERT 		enables assertions that panic or trap into the debugger.
# AH_DEBUG_ALQ 		enables support for tracing register reads+writes
#			via alq
# AH_DEBUG_COUNTRY	accept the CTR_DEBUG country code (for debugging
#			the regulatory domain support)
# AH_REGOPS_FUNC	arrange for OS_REG_READ and OS_REG_WRITE to be function
#			calls and not inline expanded to memory references
# AH_ENABLE_AP_SUPPORT	enables AP-specific support not publicly available
#			(e.g. don't cap turbo power limits)
# AH_DISABLE_WME	disable HAL_TXQ_USE_LOCKOUT_BKOFF_DIS support
#
# AH_PRIVATE_DIAG	enable private diagnostic support
# AH_WRITE_EEPROM	permit EEPROM writes (use with AH_PRIVATE_DIAG)
# AH_WRITE_REGDOMAIN	permit EEPROM writes of the regulatory domain through
#			ah_setRegulatoryDomain (implies AH_WRITE_EEPROM)
#

#
# Default settings...
#
AH_SUPPORT_AR5210?=0		# 5210 support
AH_SUPPORT_AR5211?=0		# 5211 support
AH_SUPPORT_AR5212?=1		# 5212 support
AH_SUPPORT_AR5312?=0		# 5312 support
AH_SUPPORT_AR5416?=1		# 5416 support
AH_SUPPORT_5111?=1		# 5111 RF support
AH_SUPPORT_5112?=1		# 5112 RF support
AH_SUPPORT_2413?=1		# 2413 RF support
AH_SUPPORT_5413?=1		# 5413 RF support
AH_SUPPORT_2316?=1		# 2316 RF support
AH_SUPPORT_2317?=1		# 2317 RF support
AH_SUPPORT_2425?=1		# 2425 RF support
AH_SUPPORT_2133?=1              # 2133 RF Support    

AH_DEBUG?=0			# debugging (e.g. hw.ath.hal.debug)
AH_ASSERT?=0			# assertions (pretty lame)
AH_DEBUG_ALQ?=0			# ALQ register tracing support
AH_REGOPS_FUNC?=0		# use inline memory references
AH_WRITE_REGDOMAIN?=0		# support EEPROM writes of the regulatory domain
AH_DEBUG_COUNTRY?=0		# accept CTR_DEBUG country code
AH_DISABLE_WME?=0		# disable HAL_TXQ_USE_LOCKOUT_BKOFF_DIS
AH_ENABLE_AP_SUPPORT?=0		# enable AP-specific support
AH_WRITE_EEPROM?=1		# support EEPROM writes
AH_CAL_IN_FLASH?=0			# Calibration data in flash
AH_SUPPORT_11D?=1		# support 802.11D
AH_PRIVATE_DIAG?=0		# non-public diagnostic support
AH_NEED_DESC_SWAP?=0		# Need to swap TX descriptor
AR5416_EMULATION?=0		# AR5416 emulation specific code
ATH_FORCE_PPM?=0		# Force Ppm workaround code
ATH_FORCE_BIAS?=1		# Force Bias current workaround code
ATH_SUPPORT_DFS?=1              # Support DFS

AH_AR5416_OVRD_TGT_PWR_5G?=0    	# specific override target power for 11a legacy
AH_AR5416_OVRD_TGT_PWR_5GHT20?=0	# specific override target power for 11na HT20
AH_AR5416_OVRD_TGT_PWR_5GHT40?=0	# specific override target power for 11na HT40
AH_AR5416_OVRD_TGT_PWR_CCK?=0		# specific override target power for 11b legacy
AH_AR5416_OVRD_TGT_PWR_2G?=0		# specific override target power for 11g legacy
AH_AR5416_OVRD_TGT_PWR_2GHT20?=0	# specific override target power for 11ng HT20
AH_AR5416_OVRD_TGT_PWR_2GHT40?=0 	# specific override target power for 11ng HT40

AH_NEED_PRIV_REGDMN?=0			# disable platform specific regdomain database

#
# If 5312 support is enabled it's almost certain we're not going
# to use the 5210 or 5211 support so disable it to save some space.
#
ifeq ($(strip ${AH_SUPPORT_AR5312}),1)
AH_SUPPORT_AR5210=0
AH_SUPPORT_AR5211=0
AH_SUPPORT_AR5414=0
endif

ifdef AR9100
AH_SUPPORT_AR5212=0     # 5212 support
AH_SUPPORT_5111=0       # 5111 RF support
AH_SUPPORT_5112=0       # 5112 RF support
AH_SUPPORT_2413=0       # 2413 RF support
AH_SUPPORT_5413=0       # 5413 RF support
AH_SUPPORT_2417=0       # 2417 RF support
AH_SUPPORT_2425=0       # 2425 RF support
endif

#
# Basic build components.
#
OBJDIR=	obj/${TARGET}

ifeq ($(AP71_DEBUG),1)
COPTS+=	-Wall -Werror -g
else
COPTS+=	-Wall -Werror -g -O2 
endif
INCS=	-I${OBJDIR} -I. -I.. -I../ar5416

ifdef ATH_CARR_DIR
INCS+= -I../../../carrier/${ATH_CARR_DIR}/
COPTS+= -D__CARRIER_PLATFORM__=1
endif

ifdef ATH_CARRPLTFRM_BASE
INCS+= -I${ATH_CARRPLTFRM_BASE}/
endif

CLEANFILES=	${OBJDIR}/.depend

include ${PUBLIC}/${TARGET}.inc

CFLAGS=	-DBUILD_HAL ${INCS} ${COPTS}
ifeq ($(ATH_SUPPORT_STA),1)
# Tell GCC not to insert stack protection codes, especially for Ubuntu
CFLAGS+= -fno-stack-protector
endif

HAL_SRCS=${HAL}/ah.c ${HAL}/ah_eeprom.c ${HAL}/ah_regdomain.c
HAL_OBJS=${OBJDIR}/ah.o ${OBJDIR}/ah_eeprom.o ${OBJDIR}/ah_regdomain.o

ifeq ($(strip ${AH_SUPPORT_AR5210}),1)
AR5210=	${HAL}/ar5210
HAL_SRCS+=${AR5210}/ar5210_attach.c ${AR5210}/ar5210_beacon.c \
	${AR5210}/ar5210_interrupts.c ${AR5210}/ar5210_keycache.c \
	${AR5210}/ar5210_misc.c ${AR5210}/ar5210_power.c \
	${AR5210}/ar5210_phy.c ${AR5210}/ar5210_recv.c \
	${AR5210}/ar5210_reset.c ${AR5210}/ar5210_xmit.c
HAL_OBJS+=${OBJDIR}/ar5210_attach.o ${OBJDIR}/ar5210_beacon.o \
	${OBJDIR}/ar5210_interrupts.o ${OBJDIR}/ar5210_keycache.o \
	${OBJDIR}/ar5210_misc.o ${OBJDIR}/ar5210_power.o \
	${OBJDIR}/ar5210_phy.o ${OBJDIR}/ar5210_recv.o \
	${OBJDIR}/ar5210_reset.o ${OBJDIR}/ar5210_xmit.o
endif

ifeq ($(strip ${AH_SUPPORT_AR5211}),1)
AR5211=	${HAL}/ar5211
HAL_SRCS+=${AR5211}/ar5211_attach.c ${AR5211}/ar5211_beacon.c \
	${AR5211}/ar5211_interrupts.c ${AR5211}/ar5211_keycache.c \
	${AR5211}/ar5211_misc.c ${AR5211}/ar5211_power.c \
	${AR5211}/ar5211_phy.c ${AR5211}/ar5211_recv.c \
	${AR5211}/ar5211_reset.c ${AR5211}/ar5211_xmit.c
HAL_OBJS+=${OBJDIR}/ar5211_attach.o ${OBJDIR}/ar5211_beacon.o \
	${OBJDIR}/ar5211_interrupts.o ${OBJDIR}/ar5211_keycache.o \
	${OBJDIR}/ar5211_misc.o ${OBJDIR}/ar5211_power.o \
	${OBJDIR}/ar5211_phy.o ${OBJDIR}/ar5211_recv.o \
	${OBJDIR}/ar5211_reset.o ${OBJDIR}/ar5211_xmit.o
endif

ifeq ($(strip ${AH_SUPPORT_AR5212}),1)
AR5212=	${HAL}/ar5212
HAL_SRCS+=${AR5212}/ar5212_attach.c ${AR5212}/ar5212_beacon.c \
	${AR5212}/ar5212_eeprom.c ${AR5212}/ar5212_gpio.c \
	${AR5212}/ar5212_interrupts.c ${AR5212}/ar5212_keycache.c \
	${AR5212}/ar5212_misc.c ${AR5212}/ar5212_power.c \
	${AR5212}/ar5212_phy.c ${AR5212}/ar5212_recv.c \
	${AR5212}/ar5212_reset.c ${AR5212}/ar5212_xmit.c \
	${AR5212}/ar5212_ani.c ${AR5212}/ar5212_radar.c
HAL_OBJS+=${OBJDIR}/ar5212_attach.o ${OBJDIR}/ar5212_beacon.o \
	${OBJDIR}/ar5212_eeprom.o ${OBJDIR}/ar5212_gpio.o \
	${OBJDIR}/ar5212_interrupts.o ${OBJDIR}/ar5212_keycache.o \
	${OBJDIR}/ar5212_misc.o ${OBJDIR}/ar5212_power.o \
	${OBJDIR}/ar5212_phy.o ${OBJDIR}/ar5212_recv.o \
	${OBJDIR}/ar5212_reset.o ${OBJDIR}/ar5212_xmit.o \
	${OBJDIR}/ar5212_ani.o ${OBJDIR}/ar5212_radar.o
endif

ifeq ($(strip ${AH_SUPPORT_AR5312}),1)
AR5312=	${HAL}/ar5312
HAL_SRCS+=${AR5312}/ar5312_attach.c ${AR5312}/ar5312_interrupts.c \
	${AR5312}/ar5312_eeprom.c ${AR5312}/ar5312_gpio.c \
	${AR5312}/ar5312_misc.c ${AR5312}/ar5312_power.c \
	${AR5312}/ar5312_reset.c \
	${AR5312}/ar5312_bsp.c
HAL_OBJS+=${OBJDIR}/ar5312_attach.o ${OBJDIR}/ar5312_interrupts.o \
	${OBJDIR}/ar5312_eeprom.o ${OBJDIR}/ar5312_gpio.o \
	${OBJDIR}/ar5312_misc.o ${OBJDIR}/ar5312_power.o \
	${OBJDIR}/ar5312_reset.o \
	${OBJDIR}/ar5312_bsp.o
endif

ifeq ($(strip ${AH_SUPPORT_5111}),1)
HAL_SRCS+=${AR5212}/ar5111.c
HAL_OBJS+=${OBJDIR}/ar5111.o
endif

ifeq ($(strip ${AH_SUPPORT_5112}),1)
HAL_SRCS+=${AR5212}/ar5112.c
HAL_OBJS+=${OBJDIR}/ar5112.o
endif

ifeq ($(strip ${AH_SUPPORT_2133}),1)
HAL_SRCS+=${AR5416}/ar2133.c
HAL_OBJS+=${OBJDIR}/ar2133.o
endif

ifeq ($(strip ${AH_SUPPORT_2413}),1)
HAL_SRCS+=${AR5212}/ar2413.c
HAL_OBJS+=${OBJDIR}/ar2413.o
endif

ifeq ($(strip ${AH_SUPPORT_5413}),1)
HAL_SRCS+=${AR5212}/ar5413.c
HAL_OBJS+=${OBJDIR}/ar5413.o
endif

ifeq ($(strip ${AH_SUPPORT_2316}),1)
HAL_SRCS+=${AR5212}/ar2316.c
HAL_OBJS+=${OBJDIR}/ar2316.o
endif

ifeq ($(strip ${AH_SUPPORT_2317}),1)
HAL_SRCS+=${AR5212}/ar2317.c
HAL_OBJS+=${OBJDIR}/ar2317.o
endif

ifeq ($(strip ${AH_SUPPORT_2425}),1)
HAL_SRCS+=${AR5212}/ar2425.c
HAL_OBJS+=${OBJDIR}/ar2425.o
endif

ifeq ($(strip ${AH_SUPPORT_AR5416}),1)
AR5416=	${HAL}/ar5416
HAL_SRCS+=${AR5416}/ar5416_attach.c ${AR5416}/ar5416_beacon.c \
    ${AR5416}/ar5416_eeprom_def.c ${AR5416}/ar5416_eeprom_4k.c \
	${AR5416}/ar5416_eeprom.c ${AR5416}/ar5416_gpio.c \
	${AR5416}/ar5416_interrupts.c ${AR5416}/ar5416_keycache.c \
	${AR5416}/ar5416_misc.c ${AR5416}/ar5416_power.c \
	${AR5416}/ar5416_phy.c \
	${AR5416}/ar5416_recv_ds.c ${AR5416}/ar5416_recv.c \
	${AR5416}/ar5416_reset.c \
	${AR5416}/ar5416_timer.c \
	${AR5416}/ar5416_xmit_ds.c ${AR5416}/ar5416_xmit.c \
	${AR5416}/ar5416_ani.c ${AR5416}/ar5416_radar.c
HAL_OBJS+=${OBJDIR}/ar5416_attach.o ${OBJDIR}/ar5416_beacon.o \
    ${OBJDIR}/ar5416_eeprom_def.o ${OBJDIR}/ar5416_eeprom_4k.o \
	${OBJDIR}/ar5416_eeprom.o ${OBJDIR}/ar5416_gpio.o \
	${OBJDIR}/ar5416_interrupts.o ${OBJDIR}/ar5416_keycache.o \
	${OBJDIR}/ar5416_misc.o ${OBJDIR}/ar5416_power.o \
	${OBJDIR}/ar5416_phy.o \
	${OBJDIR}/ar5416_recv_ds.o ${OBJDIR}/ar5416_recv.o \
	${OBJDIR}/ar5416_reset.o \
	${OBJDIR}/ar5416_timer.o \
	${OBJDIR}/ar5416_xmit_ds.o ${OBJDIR}/ar5416_xmit.o \
	${OBJDIR}/ar5416_ani.o ${OBJDIR}/ar5416_radar.o
endif


SRCS+=	${HAL_SRCS}
CLEANFILES+= ${OBJDIR}/opt_ah.h ${HAL_OBJS} \
	${OBJDIR}/t.o ${OBJDIR}/hal.mangle ${OBJDIR}/hal-release.o

#
# NB: These are typically overridden in the target-specific specification.
#
LD?=	ld
STRIP?=	strip
NM?=	nm
SED?=	sed
OBJCOPY?=objcopy
#
# These are specific to the host doing the build.
#
AWK?=	awk
UUENCODE?=uuencode
CVS?=	cvs

ALL=	${OBJDIR}/hal.o

all:	${ALL}

${OBJDIR}/hal.o: ${HAL_OBJS} Makefile
	${LD} -o $@ -r ${LDOPTS} ${HAL_OBJS}

#
# The released object file is constructed by stripping all possible symbols
# and mangling any that remain.  The latter is necessary because GCC stubornly
# uses various symbols for relocation when it doesn't need to.  Look at the
# script syms.awk to understand the symbol munging.
#
${OBJDIR}/hal.mangle: ${HAL_SRCS} ${PUBLIC}/syms.awk
	${STRIP} --strip-unneeded -o ${OBJDIR}/t.o ${OBJDIR}/hal.o
	${NM} -a ${OBJDIR}/t.o | grep -v ' U' | sed \
		-e '/ath_hal_probe/d' \
		-e '/ath_hal_attach/d' \
		-e '/_ath_hal_attach/d' \
		-e '/ath_hal_detach/d' \
		-e '/ath_hal_init_channels/d' \
		-e '/ath_hal_getwirelessmodes/d' \
		-e '/ath_hal_computetxtime/d' \
		-e '/ath_hal_mhz2ieee/d' \
		-e '/ath_hal_ieee2mhz/d' \
		-e '/ath_hal_version/d' \
		-e '/ath_hal_buildopts/d' \
		| ${AWK} -f ${PUBLIC}/syms.awk > ${OBJDIR}/hal.mangle
	rm -f t.o
${OBJDIR}/hal-release.o: ${OBJDIR}/hal.o ${OBJDIR}/hal.mangle
	cp -f ${OBJDIR}/hal.o ${OBJDIR}/hal-release.o

# name mangling
#	${STRIP} --strip-unneeded -o ${OBJDIR}/hal-release.o ${OBJDIR}/hal.o
#	${OBJCOPY} `cat ${OBJDIR}/hal.mangle` ${OBJDIR}/hal-release.o

${OBJDIR}/hal-symrelease.o: ${OBJDIR}/hal.o
	cp ${OBJDIR}/hal.o ${OBJDIR}/hal-symrelease.o

#
# XXX should validate the release to make sure, for example, that AH_DEBUG
#     was not used
#
release: ${OBJDIR}/hal-release.o
	rm -f ${PUBLIC}/${TARGET}.hal.o.uu
	(${SED} -e '1,/^$$/d' ${HAL}/COPYRIGHT; \
	 ${SED} -n -e '/ATH_HAL_VERSION/p' ${HAL}/version.h; \
	 ${UUENCODE} ${OBJDIR}/hal-release.o hal.o) > ${PUBLIC}/${TARGET}.hal.o.uu
	cp ${OBJDIR}/opt_ah.h ${PUBLIC}/${TARGET}.opt_ah.h

symrelease: ${OBJDIR}/hal-symrelease.o
	rm -f ${PUBLIC}/${TARGET}.hal.o.uu
	(${SED} -e '1,/^$$/d' ${HAL}/COPYRIGHT; \
	 ${SED} -n -e '/ATH_HAL_VERSION/p' ${HAL}/version.h; \
	 ${UUENCODE} ${OBJDIR}/hal-symrelease.o hal.o) > ${PUBLIC}/${TARGET}.hal.o.uu
	cp ${OBJDIR}/opt_ah.h ${PUBLIC}/${TARGET}.opt_ah.h


${OBJDIR}/ah.o:	${HAL}/ah.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ah_eeprom.o:	${HAL}/ah_eeprom.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ah_regdomain.o:	${HAL}/ah_regdomain.c
	${CC} -c -o $@ ${CFLAGS} $<

${OBJDIR}/ar5210_attach.o: ${AR5210}/ar5210_attach.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_beacon.o: ${AR5210}/ar5210_beacon.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_interrupts.o: ${AR5210}/ar5210_interrupts.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_keycache.o: ${AR5210}/ar5210_keycache.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_misc.o:	${AR5210}/ar5210_misc.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_power.o:	${AR5210}/ar5210_power.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_phy.o:	${AR5210}/ar5210_phy.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_recv.o:	${AR5210}/ar5210_recv.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_reset.o:	${AR5210}/ar5210_reset.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5210_xmit.o:	${AR5210}/ar5210_xmit.c
	${CC} -c -o $@ ${CFLAGS} $<

${OBJDIR}/ar5211_attach.o: ${AR5211}/ar5211_attach.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_beacon.o: ${AR5211}/ar5211_beacon.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_interrupts.o: ${AR5211}/ar5211_interrupts.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_keycache.o: ${AR5211}/ar5211_keycache.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_misc.o:	${AR5211}/ar5211_misc.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_power.o:	${AR5211}/ar5211_power.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_phy.o:	${AR5211}/ar5211_phy.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_recv.o:	${AR5211}/ar5211_recv.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_reset.o:	${AR5211}/ar5211_reset.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5211_xmit.o:	${AR5211}/ar5211_xmit.c
	${CC} -c -o $@ ${CFLAGS} $<

${OBJDIR}/ar5212_ani.o: ${AR5212}/ar5212_ani.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_attach.o: ${AR5212}/ar5212_attach.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_beacon.o: ${AR5212}/ar5212_beacon.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_eeprom.o: ${AR5212}/ar5212_eeprom.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_gpio.o: ${AR5212}/ar5212_gpio.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_interrupts.o: ${AR5212}/ar5212_interrupts.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_keycache.o: ${AR5212}/ar5212_keycache.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_misc.o:	${AR5212}/ar5212_misc.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_power.o:	${AR5212}/ar5212_power.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_phy.o:	${AR5212}/ar5212_phy.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_radar.o:	${AR5212}/ar5212_radar.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_recv.o:	${AR5212}/ar5212_recv.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_reset.o:	${AR5212}/ar5212_reset.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5212_xmit.o:	${AR5212}/ar5212_xmit.c
	${CC} -c -o $@ ${CFLAGS} $<

${OBJDIR}/ar5416_ani.o: ${AR5416}/ar5416_ani.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_attach.o: ${AR5416}/ar5416_attach.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_beacon.o: ${AR5416}/ar5416_beacon.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_eeprom_def.o: ${AR5416}/ar5416_eeprom_def.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_eeprom_4k.o: ${AR5416}/ar5416_eeprom_4k.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_eeprom.o: ${AR5416}/ar5416_eeprom.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_gpio.o: ${AR5416}/ar5416_gpio.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_interrupts.o: ${AR5416}/ar5416_interrupts.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_keycache.o: ${AR5416}/ar5416_keycache.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_misc.o:	${AR5416}/ar5416_misc.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_power.o:	${AR5416}/ar5416_power.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_phy.o:	${AR5416}/ar5416_phy.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_radar.o:	${AR5416}/ar5416_radar.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_recv.o:	${AR5416}/ar5416_recv.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_recv_ds.o:	${AR5416}/ar5416_recv_ds.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_reset.o:	${AR5416}/ar5416_reset.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_xmit.o:	${AR5416}/ar5416_xmit.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_xmit_ds.o:	${AR5416}/ar5416_xmit_ds.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5416_timer.o:	${AR5416}/ar5416_timer.c
	${CC} -c -o $@ ${CFLAGS} $<

${OBJDIR}/ar5312_attach.o: ${AR5312}/ar5312_attach.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5312_bsp.o: ${AR5312}/ar5312_bsp.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5312_eeprom.o: ${AR5312}/ar5312_eeprom.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5312_gpio.o: ${AR5312}/ar5312_gpio.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5312_interrupts.o: ${AR5312}/ar5312_interrupts.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5312_misc.o:	${AR5312}/ar5312_misc.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5312_power.o: ${AR5312}/ar5312_power.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5312_reset.o:	${AR5312}/ar5312_reset.c
	${CC} -c -o $@ ${CFLAGS} $<

${OBJDIR}/ar5111.o: ${AR5212}/ar5111.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5112.o: ${AR5212}/ar5112.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar2133.o: ${AR5416}/ar2133.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar2413.o: ${AR5212}/ar2413.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar5413.o: ${AR5212}/ar5413.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar2316.o: ${AR5212}/ar2316.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar2317.o: ${AR5212}/ar2317.c
	${CC} -c -o $@ ${CFLAGS} $<
${OBJDIR}/ar2425.o: ${AR5212}/ar2425.c
	${CC} -c -o $@ ${CFLAGS} $<

${OBJDIR}/opt_ah.h:
	test -d ${OBJDIR} || mkdir -p ${OBJDIR}
ifeq ($(strip ${AH_SUPPORT_AR5210}),1)
	echo "#define AH_SUPPORT_AR5210	1"	>> ${OBJDIR}/opt_ah.h
endif

ifneq ($(strip ${ATH_DEFINE_ENDIAN}), 0)
ifeq ($(strip ${ENDIAN}),AH_LITTLE_ENDIAN)
	echo "#define AH_BYTE_ORDER AH_LITTLE_ENDIAN"	>> ${OBJDIR}/opt_ah.h
else
	echo "#define AH_BYTE_ORDER AH_BIG_ENDIAN" >> ${OBJDIR}/opt_ah.h
endif
endif



ifeq ($(strip ${ATH_SUPPORT_STA}), 1)
	echo "#define AH_SUPPORT_STA	1"	>> ${OBJDIR}/opt_ah.h
endif

ifeq ($(strip ${AH_SUPPORT_AR5211}),1)
	echo "#define AH_SUPPORT_AR5211	1"	>> ${OBJDIR}/opt_ah.h
endif

ifeq ($(strip ${AH_SUPPORT_AR5212}),1)
	echo "#define AH_SUPPORT_AR5212	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_AR5312}),1)
	echo "#define AH_SUPPORT_AR5312	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_AR5416}),1)
	echo "#define AH_SUPPORT_AR5416	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_5111}),1)
	echo "#define AH_SUPPORT_5111	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_5112}),1)
	echo "#define AH_SUPPORT_5112	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_2133}),1)
	echo "#define AH_SUPPORT_2133	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_2413}),1)
	echo "#define AH_SUPPORT_2413	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_5413}),1)
	echo "#define AH_SUPPORT_5413	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_2316}),1)
	echo "#define AH_SUPPORT_2316	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_2317}),1)
	echo "#define AH_SUPPORT_2317	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_2425}),1)
	echo "#define AH_SUPPORT_2425	1"	>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_ASSERT}),1)
	echo "#define AH_ASSERT	1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_DEBUG_ALQ}),1)
	echo "#define AH_DEBUG_ALQ 1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_DEBUG}),1)
	echo "#define AH_DEBUG	1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AR5416_EMULATION}),1)
	echo "#define AR5416_EMULATION	1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AR5416_2_CHAIN}),1)
	echo "#define AR5416_2_CHAIN	1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AR5416_3_CHAIN}),1)
	echo "#define AR5416_3_CHAIN	1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AR5416_CES_DEMO}),1)
	echo "#define AR5416_CES_DEMO	1"		    >> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${ATH_FORCE_PPM}),1)
	echo "#define ATH_FORCE_PPM	1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${ATH_FORCE_BIAS}),1)
	echo "#define ATH_FORCE_BIAS	1"		>> ${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_WRITE_REGDOMAIN}),1)
	echo "#define AH_SUPPORT_WRITE_REGDOMAIN 1" >>${OBJDIR}/opt_ah.h
	echo "#define AH_SUPPORT_WRITE_EEPROM 1">>${OBJDIR}/opt_ah.h
else
ifeq ($(strip ${AH_WRITE_EEPROM}),1)
	echo "#define AH_SUPPORT_WRITE_EEPROM 1">>${OBJDIR}/opt_ah.h
endif
endif
ifeq ($(strip ${AH_CAL_IN_FLASH}),1)
	echo "#define AH_CAL_IN_FLASH 1">>${OBJDIR}/opt_ah.h
	echo "#define AH_CAL_RADIOS ${AH_CAL_RADIOS}">>${OBJDIR}/opt_ah.h
	echo "#define AH_CAL_LOCATIONS ${AH_CAL_LOCATIONS}">>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_DEBUG_COUNTRY}),1)
	echo "#define AH_DEBUG_COUNTRY 1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_REGOPS_FUNC}),1)
	echo "#define AH_REGOPS_FUNC 1"		>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_DISABLE_WME}),1)
	echo "#define AH_DISABLE_WME 1"		>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_ENABLE_AP_SUPPORT}),1)
	echo "#define AH_ENABLE_AP_SUPPORT 1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_PRIVATE_DIAG}),1)
	echo "#define AH_PRIVATE_DIAG 1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_NEED_DESC_SWAP}),1)
	echo "#define AH_NEED_DESC_SWAP 1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_XR}),1)
	echo "#define AH_SUPPORT_XR	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_SUPPORT_11D}),1)
	echo "#define AH_SUPPORT_11D	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AR9100}),1)
	echo "#define AR9100	1"	>>${OBJDIR}/opt_ah.h
endif

ifeq ($(strip ${AR5416_INT_MITIGATION}),1)
	echo "#define AR5416_INT_MITIGATION	1"	>>${OBJDIR}/opt_ah.h
endif

ifeq ($(strip ${AH_AR5416_OVRD_TGT_PWR_5G}),1)
	echo "#define AH_AR5416_OVRD_TGT_PWR_5G	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_AR5416_OVRD_TGT_PWR_5GHT20}),1)
	echo "#define AH_AR5416_OVRD_TGT_PWR_5GHT20	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_AR5416_OVRD_TGT_PWR_5GHT40}),1)
	echo "#define AH_AR5416_OVRD_TGT_PWR_5GHT40	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_AR5416_OVRD_TGT_PWR_CCK}),1)
	echo "#define AH_AR5416_OVRD_TGT_PWR_CCK	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_AR5416_OVRD_TGT_PWR_2G}),1)
	echo "#define AH_AR5416_OVRD_TGT_PWR_2G	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_AR5416_OVRD_TGT_PWR_2GHT20}),1)
	echo "#define AH_AR5416_OVRD_TGT_PWR_2GHT20	1"	>>${OBJDIR}/opt_ah.h
endif
ifeq ($(strip ${AH_AR5416_OVRD_TGT_PWR_2GHT40}),1)
	echo "#define AH_AR5416_OVRD_TGT_PWR_2GHT40	1"	>>${OBJDIR}/opt_ah.h
endif

ifeq ($(strip ${AH_NEED_PRIV_REGDMN}),1)
	echo "#define AH_NEED_PRIV_REGDMN	1"	>>${OBJDIR}/opt_ah.h
endif

	echo "#define DEBUG_PKTLOG	1"	>>${OBJDIR}/opt_ah.h

clean:
	rm -f ${ALL} ${OBJS} ${CLEANFILES}
	-rmdir -p ${OBJDIR}

depend: beforedepend .depend afterdepend
${OBJDIR}/.depend: ${SRCS} ${OBJDIR}/opt_ah.h
	rm -f ${OBJDIR}/.depend
	${CC} -M ${CFLAGS} ${SRCS} | \
		sed 's,\(.*\)\.o:,${OBJDIR}/\1.o:,g' > ${OBJDIR}/.depend
afterdepend:
-include ${OBJDIR}/.depend
