#ifndef _HW_DEF_H
#define _HW_DEF_H

/*
 * Atheros-specific
 */
typedef enum {
    ANTENNA_CONTROLLABLE,
    ANTENNA_FIXED_A,
    ANTENNA_FIXED_B,
    ANTENNA_DUMMY_MAX
} ANTENNA_CONTROL;

/* 
 * Number of (OEM-defined) functions using GPIO pins currently defined 
 *
 * Function 0: Link/Power LED
 * Function 1: Network/Activity LED
 * Function 2: Connection LED
 */
#define NUM_GPIO_FUNCS             3

/*
** Default cache line size, in bytes.
** Used when PCI device not fully initialized by bootrom/BIOS
*/

#define DEFAULT_CACHELINE	32

#ifdef CONFIG_ARM

/*
** This was borrowed from NETBSD.  Not very atomic
*/

static INLINE int32_t cmpxchg(int32_t *_patomic_arg, int32_t _comparand, int32_t _exchange)
{
    if(*(_patomic_arg) == _comparand)
    {
         *(_patomic_arg) = _exchange;
         return _comparand;
    }
    return (*_patomic_arg);
}


#endif 

#endif
