/*
 * IEEE 802.11 generic handler
 */

#ifndef AUTOCONF_INCLUDED
#include <linux/config.h>
#endif

#include <linux/version.h>
#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/rtnetlink.h>		/* XXX for rtnl_lock */

#include <osdep.h> 
#include "if_media.h"
#include "ieee80211_interfaces.h"

#include <net80211/ieee80211_var.h>
#include <net80211/if_athproto.h>


void
ieee80211_add_vap_target(struct ieee80211com *ic, struct ieee80211vap *vap)
{
    struct ieee80211_vap_target vt;
    int i;

    printk("%s Enter \n", __FUNCTION__);

    for (i = 0; i < 4; i++) {
        if (ic->target_vap_bitmap[i] == 0) {
            ic->target_vap_bitmap[i] = 1;
            vap->iv_vapindex = i;
            break;
        }
    }

    vt.iv_vapindex = vap->iv_vapindex;
    vt.iv_opmode = vap->iv_opmode;
    vt.iv_mcast_rate = vap->iv_mcast_rate; 
    vt.iv_rtsthreshold = vap->iv_rtsthreshold;

    OS_MEMCPY(&vt.iv_des_bssid, &(vap->iv_des_bssid), (IEEE80211_ADDR_LEN * sizeof(u_int8_t)));
    OS_MEMCPY(&vt.iv_myaddr, &(vap->iv_myaddr), (IEEE80211_ADDR_LEN * sizeof(u_int8_t)));
    OS_MEMCPY(&vt.iv_ni_bssid, &(vap->iv_bss->ni_bssid), (IEEE80211_ADDR_LEN * sizeof(u_int8_t)));

    ic->ic_add_vap_target(ic, &vt, sizeof(vt));

    printk("%s Exit \n", __FUNCTION__);
}

void
ieee80211_add_node_target(struct ieee80211_node *ni)
{
    struct ieee80211_node_target nt, *ntar;
    int i, j;

    for (i = 0; i < 32; i++) {
       if (ni->ni_ic->target_node_bitmap[i] == 0) {
           ni->ni_ic->target_node_bitmap[i] = 1;
           ni->ni_nodeindex = i;
           break;
       }
    }		
    
    printk("%s nodeindex %d  \n", __FUNCTION__, ni->ni_nodeindex);

    if (ni != NULL)
    {
        printk(" %s nodeindex %d  \n", __FUNCTION__, ni->ni_nodeindex);
        printk(" %s ni->ni_associd) %d  \n", __FUNCTION__, ni->ni_associd);
        printk(" %s ni_txpower %d  \n", __FUNCTION__, ni->ni_txpower);
        printk(" %s ni_capinfo %d  \n", __FUNCTION__, ni->ni_capinfo);
        printk(" %s ni_macaddr  \n", __FUNCTION__);

        for(i=0;i<6;i++)
            printk(" %d:",ni->ni_macaddr[i]);
        printk(" \n %s ni_bssid   \n", __FUNCTION__);
        
        for(i=0;i<6;i++)
            printk(" %d:",ni->ni_bssid[i]);
        printk("\n");

        /* adf_os_print(" %s nodeindex %d  \n",__FUNCTION__, nt.ni_ucastkey);	*/
        nt.ni_nodeindex = ni->ni_nodeindex;
        if (ni->ni_vap != NULL)		  
        {
            nt.ni_vapindex = ni->ni_vap->iv_vapindex;
        }
        else {
            printk("\n ni->ni_vap IS NUMLL");
        }

        nt.ni_associd   = htons(ni->ni_associd);
        nt.ni_txpower   = htons(ni->ni_txpower);
        nt.ni_capinfo   = ni->ni_capinfo; 
        nt.ni_flags     = ni->ni_flags;
        OS_MEMCPY(&nt.ni_macaddr, &(ni->ni_macaddr), (IEEE80211_ADDR_LEN * sizeof(u_int8_t)));
        OS_MEMCPY(&nt.ni_bssid, &(ni->ni_bssid), (IEEE80211_ADDR_LEN * sizeof(u_int8_t)));
        /*  adf_os_mem_copy(&nt.ni_ucastkey, &(ni->ni_ucastkey), sizeof(struct ieee80211_key)); */
    }
    else {
        printk("\nNODE is NULL\n");
    }

    ntar = &nt;
    printk("%s call add node: %d\n", __FUNCTION__, ni->ni_nodeindex);

    ni->ni_ic->ic_add_node_target(ni->ni_ic, ntar, sizeof(struct ieee80211_node_target));
    printk("%s Exit  \n", __FUNCTION__);
}
