/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.log.common.util;

import com.huawei.support.basicconfigservice.helper.SysconfigSpringContextHelper;
import com.huawei.support.entitlementservice.model.User;
import com.huawei.support.entitlementservice.service.UserService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.util.HttpUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.tools.commonlib.exception.ServiceException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Id2SystemUserIdUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(Id2SystemUserIdUtils.class);
    private static UserService userService;

    private Id2SystemUserIdUtils() {
    }

    public static String getSysUserId(String userId) {
        userService = (UserService)SysconfigSpringContextHelper.getBean(UserService.class);
        if (userService == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "userService is null");
            throw new UnsupportedOperationException("userService is null");
        }
        User user = new User();
        user.setUserId(userId.toLowerCase(Locale.ENGLISH));
        String sysUserId = "";
        try {
            List simpleUsers = userService.getSimpleUsers(user);
            if (CollectionUtils.isNotEmpty((Collection)simpleUsers)) {
                sysUserId = ((User)simpleUsers.get(0)).getSysUserId();
            }
        }
        catch (ServiceException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "userService.getSimpleUsers error.", (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)sysUserId)) {
            return "";
        }
        return sysUserId;
    }

    public static String getSysUserId(HttpServletRequest request) {
        if (request == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "request is null");
            return "";
        }
        String userId = HttpUtils.getUserId(request);
        if (StringUtils.isBlank((CharSequence)userId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "empty userID in request");
            return "";
        }
        String sysUserId = Id2SystemUserIdUtils.getSysUserId(userId);
        if (StringUtils.isBlank((CharSequence)sysUserId)) {
            return "";
        }
        return sysUserId;
    }
}

