/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.log.common.util;

import com.huawei.support.cbb.util.address.IPUtil;
import com.huawei.support.icscbb.log.common.util.Id2SystemUserIdUtils;
import com.huawei.support.icscbb.log.web.dto.LogInfoDto;
import com.huawei.support.icscbb.log.web.dto.LogOperationDto;
import com.huawei.support.icscbb.log.web.dto.SecurityLogDto;
import com.huawei.support.operationlogservice.model.OperationLog;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class LogUtils {
    private static final int LENGTH_LIMIT = 50;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final int INDEX_ZERO = 0;
    private static final int INDEX_FORTY_NINE = 49;

    private LogUtils() {
    }

    public static OperationLog setOperationLog(HttpServletRequest request, String status, LogInfoDto logInfoDto, LogOperationDto logOperationDto) {
        String systemId;
        OperationLog operationLog = new OperationLog();
        String ip = IPUtil.getClientTrueIP((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            operationLog.setClientIp(ip);
        }
        if (StringUtils.isNotBlank((CharSequence)(systemId = Id2SystemUserIdUtils.getSysUserId(request)))) {
            operationLog.setOperator(systemId);
        }
        operationLog.setModuleId(logInfoDto.getModuleId());
        operationLog.setModuleType(logInfoDto.getModuleType());
        operationLog.setOperationParam(logOperationDto.getOperationParam());
        operationLog.setOldParam(logOperationDto.getOldParam());
        operationLog.setOperation(logOperationDto.getOperation());
        operationLog.setOperationTime(logOperationDto.getOperationTime());
        operationLog.setOperationType(logOperationDto.getOperationType());
        operationLog.setStatus(status);
        operationLog.setSystemType(logInfoDto.getSystemType());
        return operationLog;
    }

    public static LogOperationDto setOperationLog(String operationType, String operation, String operationParam, String oldParam) {
        String operationTypeStr = operationType;
        if (StringUtils.isNotBlank((CharSequence)operationTypeStr)) {
            operationTypeStr = operationTypeStr.toLowerCase(Locale.ENGLISH);
        }
        if (operationTypeStr.length() > 50) {
            operationTypeStr = operationTypeStr.substring(0, 50);
        }
        LogOperationDto logOperation = new LogOperationDto();
        logOperation.setOperationType(operationTypeStr);
        logOperation.setOldParam(oldParam);
        logOperation.setOperationParam(operationParam);
        logOperation.setOperation(operation);
        String operationTime = LogUtils.getCurrentTime();
        logOperation.setOperationTime(operationTime);
        return logOperation;
    }

    public static LogInfoDto setLogInfoDto(String systemType, String moduleId, String moduleType) {
        String moduleTypeStr = moduleType;
        String moduleIdStr = moduleId;
        if (StringUtils.isNotBlank((CharSequence)moduleTypeStr)) {
            moduleTypeStr = moduleTypeStr.toLowerCase(Locale.ROOT);
        }
        if (StringUtils.isNotBlank((CharSequence)moduleIdStr)) {
            moduleIdStr = moduleIdStr.toLowerCase(Locale.ROOT);
        }
        if (moduleIdStr.length() > 50) {
            moduleIdStr = moduleIdStr.substring(0, 49);
        }
        if (moduleTypeStr.length() > 50) {
            moduleTypeStr = moduleTypeStr.substring(0, 49);
        }
        LogInfoDto logInfo = new LogInfoDto();
        logInfo.setModuleId(moduleIdStr);
        logInfo.setModuleType(moduleTypeStr);
        logInfo.setSystemType(systemType);
        return logInfo;
    }

    public static LogOperationDto setOperationLogDto(String operationType, String operation, String operationParam, String oldParam) {
        String operationTypeStr = operationType;
        if (StringUtils.isNotBlank((CharSequence)operationTypeStr)) {
            operationTypeStr = operationTypeStr.toLowerCase(Locale.ROOT);
        }
        if (operationTypeStr.length() > 50) {
            operationTypeStr = operationTypeStr.substring(0, 49);
        }
        LogOperationDto logOperation = new LogOperationDto();
        logOperation.setOperationType(operationTypeStr);
        logOperation.setOldParam(oldParam);
        logOperation.setOperationParam(operationParam);
        logOperation.setOperation(operation);
        logOperation.setOperationTime(LogUtils.getCurrentTime());
        return logOperation;
    }

    public static SecurityLogDto setSecurityLogDto(HttpServletRequest request, String subtype, String operationName, String moduleName, String result) {
        String systemId;
        SecurityLogDto securityLogDto = new SecurityLogDto();
        securityLogDto.setSubtype(subtype);
        securityLogDto.setOperationName(operationName);
        securityLogDto.setModuleName(moduleName);
        securityLogDto.setResult(result);
        String ip = IPUtil.getClientTrueIP((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            securityLogDto.setTerminal(ip);
        }
        if (StringUtils.isNotBlank((CharSequence)(systemId = Id2SystemUserIdUtils.getSysUserId(request)))) {
            securityLogDto.setOperator(systemId);
        }
        securityLogDto.setAppId("com.huawei.support.infocenter");
        String event = StringUtils.joinWith((String)" ", (Object[])new Object[]{LogUtils.getCurrentTime(), systemId, operationName, result});
        securityLogDto.setEvent(event);
        return securityLogDto;
    }

    private static String getCurrentTime() {
        return DATE_TIME_FORMATTER.format(LocalDateTime.now());
    }

    public static OperationLog getOperationLog(Object ... objects) {
        OperationLog operationLog = new OperationLog();
        for (Object object : objects) {
            if (object == null || !(object instanceof OperationLog)) continue;
            operationLog = (OperationLog)object;
            break;
        }
        return operationLog;
    }

    public static SecurityLogDto getSecurityLogDto(Object ... objects) {
        SecurityLogDto securityLogDto = new SecurityLogDto();
        for (Object object : objects) {
            if (object == null || !(object instanceof SecurityLogDto)) continue;
            securityLogDto = (SecurityLogDto)object;
            break;
        }
        return securityLogDto;
    }

    public static Throwable getThrowable(Object ... objects) {
        Throwable throwable = null;
        for (Object object : objects) {
            if (object == null || !(object instanceof Throwable)) continue;
            throwable = (Throwable)object;
            break;
        }
        return throwable;
    }
}

