/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.log.lite.adapter;

import com.huawei.support.icscbb.log.common.util.MethodStackUtils;
import java.io.FileNotFoundException;
import java.net.BindException;
import java.security.acl.NotOwnerException;
import java.sql.SQLException;
import java.util.ConcurrentModificationException;
import java.util.MissingResourceException;
import java.util.jar.JarException;
import javax.naming.InsufficientResourcesException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;

public class LogUtilAdpter {
    private static final int CURRENT_METHOD_DEEP = 5;
    private static final int MAX_MSG_LEN = 100000;

    public static void log(LogLevel level, Logger gol, String msg, Throwable exec) {
        if (null != gol) {
            String gsm = LogUtilAdpter.clearLogForging(msg);
            if (exec == null) {
                LogUtilAdpter.logSwitch(level, gol, gsm, null);
            } else {
                Throwable stacktraceinfo = exec.getCause();
                if (stacktraceinfo != null) {
                    exec = stacktraceinfo;
                }
                if (exec instanceof FileNotFoundException) {
                    gol.error(gsm);
                } else if (exec instanceof MissingResourceException) {
                    gol.error(gsm);
                } else if (exec instanceof JarException) {
                    gol.error(gsm);
                } else if (exec instanceof NotOwnerException) {
                    gol.error(gsm);
                } else if (exec instanceof ConcurrentModificationException) {
                    gol.error(gsm);
                } else if (exec instanceof BindException) {
                    gol.error(gsm);
                } else if (exec instanceof InsufficientResourcesException) {
                    gol.error(gsm);
                } else if (exec instanceof OutOfMemoryError) {
                    gol.error(gsm);
                } else if (exec instanceof SQLException) {
                    gol.error(gsm);
                } else if (exec instanceof StackOverflowError) {
                    gol.error(gsm);
                } else {
                    LogUtilAdpter.logSwitch(level, gol, gsm, exec);
                }
            }
        }
    }

    private static void logSwitch(LogLevel level, Logger gol, String gsm, Throwable exec) {
        int lineNumber = MethodStackUtils.getAnyMethodLineNumber(5);
        gsm = "[line:" + lineNumber + "]-" + gsm;
        switch (level) {
            case DEBUG: {
                gol.debug("{}", (Object)gsm, (Object)exec);
                break;
            }
            case WARN: {
                gol.warn("{}", (Object)gsm, (Object)exec);
                break;
            }
            case ERROR: {
                gol.error("{}", (Object)gsm, (Object)exec);
                break;
            }
            case INFO: {
                gol.info("{}", (Object)gsm, (Object)exec);
                break;
            }
            default: {
                gol.info("{}", (Object)gsm, (Object)exec);
            }
        }
    }

    public static String clearTrustViolation(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        return StringEscapeUtils.escapeHtml4((String)message);
    }

    public static String clearLogForging(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        if (message.length() > 100000) {
            return "the length of msg is greatter than 100000";
        }
        return message.replace('\n', '_').replace('\r', '_').replace("%0a", "_").replace("%0d", "_").replace("%0A", "_").replace("%0D", "_").replace("%09", "_").replace('\t', '_').replace("%0b", "_").replace("%0B", "_").replace("\\v", "_").replace("%0c", "_").replace("%0C", "_").replace('\f', '_').replace("%08", "_").replace('\b', '_').replace("%7f", "_").replace("%7F", "_");
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

