/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.db.dbconfig;

import com.alibaba.fastjson.JSONObject;
import com.huawei.support.ics.common.adapter.encryption.service.impl.KmcDataSecurityHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.SqlSessionFactorySingleton;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.db.constant.DbConstants;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class DataBaseHandler
implements DbConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(DataBaseHandler.class);
    private File dataBaseInfoFile;

    public static DataBaseHandler getInstance() {
        return DataBaseHandlerHolder.INSTANCE;
    }

    public void initDb() {
        this.setDerbyLogFilePath();
        this.dataBaseInfoFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getSysProgramDataPath() + ConfigServiceHandler.getInstance().get("system.lang") + File.separator + "dataBaseInfo.txt"});
        String migrated = ConfigServiceHandler.getInstance().getFromFile("system.old.encryptData.migrated");
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)migrated) && FileUtils.getFile((String[])new String[]{DERBY_DB_PATH}).exists()) {
            this.deleteDb();
        }
        SqlSessionFactorySingleton.INSTANCE.buildSqlSessionFactory("spring/mybatis_config.xml", "", "", "", ICS_LOG_DIR);
    }

    private void setDerbyLogFilePath() {
        String dirPath = ICS_LOG_DIR + DB_LOG_DIR_PATH;
        String filePath = dirPath + File.separator + "derby.log";
        File file = FileUtils.getFile((String[])new String[]{dirPath});
        if (!file.exists() && !file.mkdirs()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create db log dir fail");
        }
        File logFile = FileUtils.getFile((String[])new String[]{filePath});
        try {
            if (!logFile.createNewFile()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "create db log file fail");
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create db log file fail", (Throwable)e);
        }
        System.setProperty("derby.stream.error.file", filePath);
    }

    public String getUserName() {
        return this.getDataFromDataBaseInfoFile("dbUserName");
    }

    public String getPassword() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "application prepare to link db file");
        return this.getDataFromDataBaseInfoFile("dbPassword");
    }

    public String getBootPassword() {
        return this.getDataFromDataBaseInfoFile("bootPassword");
    }

    private String getDataFromDataBaseInfoFile(String key) {
        if (!this.dataBaseInfoFile.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "dataBaseInfo not exits");
            return "";
        }
        try {
            byte[] bytes = FileUtils.readFileToByteArray((File)this.dataBaseInfoFile);
            if (ArrayUtils.isEmpty((byte[])bytes)) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "read database info is empty");
                return "";
            }
            String decrpy = KmcDataSecurityHandler.getInstance().decrpy(0, bytes);
            if (StringUtils.isEmpty((CharSequence)decrpy)) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "decrpy database info fail");
                return "";
            }
            JSONObject jsonObject = JSONObject.parseObject((String)decrpy);
            if (jsonObject == null) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "jsonObject is null");
                return "";
            }
            return jsonObject.getString(key);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get dataBaseInfo fail", (Throwable)e);
            return "";
        }
    }

    public boolean isNormalDb() {
        String dbPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "icslitedb";
        File dbfile = FileUtils.getFile((String[])new String[]{dbPath});
        if (!dbfile.exists()) {
            return false;
        }
        boolean isValid = false;
        try {
            SqlSessionFactory sqlSessionFactory = SqlSessionFactorySingleton.INSTANCE.getSqlSessionFactory();
            SqlSession sqlSession = sqlSessionFactory.openSession();
            Connection connection = sqlSession.getConnection();
            isValid = connection.isValid(1);
        }
        catch (SQLException | PersistenceException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "connection db is error", e);
            return isValid;
        }
        if (!isValid) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "sqlSession.getConnection() is ok,but connection db is error");
        }
        return isValid;
    }

    public void deleteDb() {
        File dbfile = FileUtils.getFile((String[])new String[]{DERBY_DB_PATH});
        if (dbfile.exists()) {
            if (!this.isBackupDb(dbfile)) {
                return;
            }
            try {
                FileUtils.deleteDirectory((File)dbfile);
                OperationLogUtils.INSTANCE.successOperationLog("DELETE", "icslite-db", String.format(Locale.ENGLISH, "the %s had backuped then deleted successfully", "icslitedb"));
            }
            catch (IOException e) {
                OperationLogUtils.INSTANCE.failOperationLog("DELETE", "icslite-db", String.format(Locale.ENGLISH, "the %s delete fail", "icslitedb"), (Throwable)e);
            }
        }
    }

    private boolean isBackupDb(File dbfile) {
        String backupPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "backup";
        File backupFile = FileUtils.getFile((String[])new String[]{backupPath});
        String backupDbName = "";
        try {
            if (backupFile.exists()) {
                OperationLogUtils.INSTANCE.successOperationLog("DELETE", "icslite-db", "statrt to delete the before backup isclitedb");
                FileUtils.cleanDirectory((File)backupFile);
                OperationLogUtils.INSTANCE.successOperationLog("DELETE", "icslite-db", "the before backup isclitedb had deleted successfully");
            }
            String backupDbPath = backupPath + File.separator + "icslitedb";
            File backupDbFile = FileUtils.getFile((String[])new String[]{backupDbPath});
            OperationLogUtils.INSTANCE.successOperationLog("CREATE", "icslite-db", "statrt to backup the isclitedb");
            FileUtils.copyDirectory((File)dbfile, (File)backupDbFile);
            OperationLogUtils.INSTANCE.successOperationLog("CREATE", "icslite-db", String.format(Locale.ENGLISH, "the %s isclitedb backup successfully", backupDbName));
            return true;
        }
        catch (IOException e) {
            OperationLogUtils.INSTANCE.failOperationLog("CREATE", "icslite-db", String.format(Locale.ENGLISH, "the %s isclitedb backup fail", backupDbName), (Throwable)e);
            return false;
        }
    }

    private static class DataBaseHandlerHolder {
        private static final DataBaseHandler INSTANCE = new DataBaseHandler();

        private DataBaseHandlerHolder() {
        }
    }
}

