/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.db.dbconfig;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.db.constant.DbConstants;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;

public class DbConnectionUtil
implements DbConstants {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DbConnectionUtil.class);

    public static Connection buildConnection(String user, String password, String bootPassword, String icsDirLog) {
        String hisDbUrl = String.format(Locale.ENGLISH, "jdbc:derby:%sicslitedb;create=false;dataEncryption=true;encryptionAlgorithm=AES/OFB/NoPadding;encryptionKeyLength=256;bootPassword=%s", icsDirLog, bootPassword);
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Load db driver failed.");
        }
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", user);
        connectionProperties.put("password", password);
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(hisDbUrl, connectionProperties);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Get db Connection error.");
        }
        return conn;
    }
}

