/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.db.dbconfig;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DbMigrateResultSetHandler<T> {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DbMigrateResultSetHandler.class);
    private final List<T> beanList;
    private final Class<T> type;
    private final ResultSet resultSet;
    private final Map<Class<?>, Function<String, Object>> functionMap = this.initFunction();
    private ResultSetMetaData metaData;

    public DbMigrateResultSetHandler(ResultSet resultSet, Class<T> type) {
        this.beanList = new ArrayList<T>();
        this.type = type;
        this.resultSet = resultSet;
        try {
            this.metaData = resultSet.getMetaData();
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "GetMetaData fail.");
        }
        this.handlerData();
    }

    private Map<Class<?>, Function<String, Object>> initFunction() {
        HashMap funcMap = new HashMap();
        funcMap.put(String.class, this::getString);
        funcMap.put(Byte.class, this::getByte);
        funcMap.put(Byte.TYPE, this::getByte);
        funcMap.put(Short.class, this::getShort);
        funcMap.put(Short.TYPE, this::getShort);
        funcMap.put(Integer.class, this::getInt);
        funcMap.put(Integer.TYPE, this::getInt);
        funcMap.put(Long.class, this::getLong);
        funcMap.put(Long.TYPE, this::getLong);
        funcMap.put(Double.class, this::getDouble);
        funcMap.put(Double.TYPE, this::getDouble);
        funcMap.put(Float.class, this::getFloat);
        funcMap.put(Float.TYPE, this::getFloat);
        funcMap.put(java.util.Date.class, this::getDate);
        funcMap.put(Date.class, this::getDate);
        funcMap.put(Time.class, this::getTime);
        funcMap.put(Boolean.class, this::getBoolean);
        funcMap.put(Boolean.TYPE, this::getBoolean);
        return funcMap;
    }

    private String getString(String columnLabel) {
        String value = "";
        try {
            value = this.resultSet.getString(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getString() error.");
        }
        return value;
    }

    private Byte getByte(String columnLabel) {
        Byte value = null;
        try {
            value = this.resultSet.getByte(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getByte() error.");
        }
        return value;
    }

    private Short getShort(String columnLabel) {
        Short value = null;
        try {
            value = this.resultSet.getShort(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getShort() error.");
        }
        return value;
    }

    private Integer getInt(String columnLabel) {
        Integer value = null;
        try {
            value = this.resultSet.getInt(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getInt() error.");
        }
        return value;
    }

    private Long getLong(String columnLabel) {
        Long value = null;
        try {
            value = this.resultSet.getLong(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getLong() error.");
        }
        return value;
    }

    private Double getDouble(String columnLabel) {
        Double value = null;
        try {
            value = this.resultSet.getDouble(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getDouble() error.");
        }
        return value;
    }

    private Float getFloat(String columnLabel) {
        Float value = null;
        try {
            value = Float.valueOf(this.resultSet.getFloat(columnLabel));
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getFloat() error.");
        }
        return value;
    }

    private Date getDate(String columnLabel) {
        Date value = null;
        try {
            value = this.resultSet.getDate(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getDate() error.");
        }
        return value;
    }

    private Time getTime(String columnLabel) {
        Time value = null;
        try {
            value = this.resultSet.getTime(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getTime() error.");
        }
        return value;
    }

    private Boolean getBoolean(String columnLabel) {
        Boolean isSuccess = null;
        try {
            isSuccess = this.resultSet.getBoolean(columnLabel);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "resultSet.getBoolean() error.");
        }
        return isSuccess;
    }

    private void handlerData() {
        List<Field> declaredFields = this.getAllFields();
        Map<String, Field> fieldMap = declaredFields.stream().collect(Collectors.toMap(e -> StringUtils.toRootUpperCase((String)e.getName()), e -> e, (k1, k2) -> k1));
        try {
            while (this.resultSet.next()) {
                this.beanList.add(this.getT(fieldMap));
            }
        }
        catch (IllegalAccessException | InstantiationException | SQLException e2) {
            CodeCCUtils.INSTANCE.errorLog(log, "DbMigrateResultSetHandler.getT() error.", (Throwable)e2);
        }
    }

    private List<Field> getAllFields() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<T> currentType = this.type; currentType != null; currentType = currentType.getSuperclass()) {
            fieldList.addAll(Arrays.asList(currentType.getDeclaredFields()));
        }
        return fieldList;
    }

    private T getT(Map<String, Field> fieldMap) throws InstantiationException, IllegalAccessException, SQLException {
        int columnCount = this.metaData.getColumnCount();
        T target = this.type.newInstance();
        for (int i = 1; i <= columnCount; ++i) {
            String columnLabel = this.metaData.getColumnLabel(i);
            if (!fieldMap.containsKey(columnLabel)) continue;
            Field field = fieldMap.get(columnLabel);
            field.setAccessible(true);
            Object value = null;
            Class<?> fieldType = field.getType();
            Function<String, Object> objectFunction = this.functionMap.get(fieldType);
            if (objectFunction != null) {
                value = objectFunction.apply(columnLabel);
            }
            field.set(target, value);
        }
        return target;
    }

    public List<T> getBeanList() {
        return this.beanList;
    }

    public T getBean() {
        return CollectionUtils.isEmpty(this.beanList) ? null : (T)this.beanList.remove(0);
    }
}

