/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.q;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@q
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> do;
    private IGenericEqualityComparer<TKey> if;
    private int for;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.if = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.for = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.do = new Dictionary(this.if);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.do != null) {
            return this.do.containsKey(key);
        }
        return this.do(key) >= 0;
    }

    private int do(TKey TKey) {
        for (int i10 = this.size() - 1; i10 >= 0; --i10) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i10));
            if (!this.if.equalsT(TKey, TKey2)) continue;
            return i10;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.do != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.do.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n10 = this.do(key);
        if (n10 == -1) {
            return false;
        }
        this.removeAt(n10);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.if;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.do != null && ((Dictionary.KeyCollection)this.do.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.do.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.do != null) {
            return this.do.get_Item(key);
        }
        int n10 = this.do(key);
        if (n10 >= 0) {
            return (TItem)super.get_Item(n10);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.if.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.do != null) {
            if (!this.do.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.do.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.do != null) {
            this.do.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n10;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.do != null && this.do.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.do == null) {
            for (n10 = 0; n10 < this.size(); ++n10) {
                if (!this.if.equalsT(TKey, this.getKeyForItem(super.get_Item(n10)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.do != null) {
            this.do.addItem(TKey, item);
        } else if (this.for != -1 && this.size() > this.for) {
            this.do = new Dictionary(this.if);
            for (n10 = 0; n10 < this.size(); ++n10) {
                Object t10 = super.get_Item(n10);
                this.do.addItem(this.getKeyForItem(t10), t10);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.do != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.do.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.do != null) {
            this.do.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.do.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.do;
    }
}

