/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ad.service.impl;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.ad.dto.AdInfo;
import com.huawei.support.icslite.business.ad.service.AdBusiness;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkConnServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AdBusinessHandler
implements AdBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(AdBusinessHandler.class);
    private static final String AD_INTERFACE_KEY = "Ad.interface";
    private static final String AD_BUSINESS = "AdBusiness";
    private static final String NETWORK_DATA_JSON = "dataJson";

    private AdBusinessHandler() {
    }

    public static AdBusinessHandler getInstance() {
        return AdBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public Optional<AdInfo> getAdInfo() {
        Optional<AdInfo> adInfo = Optional.empty();
        try {
            adInfo = this.getAd();
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get ad fail.");
        }
        return adInfo;
    }

    private Optional<AdInfo> getAd() throws DownloadException {
        if (NetworkConnServiceHandler.getInstance().isClosed()) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "The network connection switch is not turned on.");
            throw new DownloadException("The network connection switch is not turned on.");
        }
        String mainUrl = NetworkServiceHandler.getInstance().getMainUrl(AD_INTERFACE_KEY);
        if (StringUtils.isBlank((CharSequence)mainUrl)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get main url is fail.");
            throw new DownloadException("Get main url is fail.");
        }
        String finalUrl = mainUrl + "?lang=" + ConfigServiceHandler.getInstance().get("system.lang");
        Map<String, String> networkMap = NetworkServiceHandler.getInstance().getNetworkData(finalUrl, AD_BUSINESS);
        String data = Optional.ofNullable(networkMap).map(map -> (String)map.get(NETWORK_DATA_JSON)).map(JSON::parseObject).map(jsonObj -> jsonObj.getString("data")).orElse("");
        if (StringUtils.isBlank((CharSequence)data) || StringUtils.equalsIgnoreCase((CharSequence)data, (CharSequence)"null")) {
            return Optional.empty();
        }
        AdInfo adInfo = null;
        try {
            adInfo = (AdInfo)JsonUtils.stringToBean((String)data, AdInfo.class);
        }
        catch (JsonUtils.JsonException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "AdJson can't convert to Bean.", (Throwable)e);
        }
        if (adInfo == null || StringUtils.equals((CharSequence)adInfo.getVersion(), (CharSequence)IcsCommonServiceHandler.getInstance().getAppVersion())) {
            return Optional.empty();
        }
        return Optional.of(adInfo);
    }

    private static class AdBusinessHandlerHolder {
        private static final AdBusinessHandler INSTANCE = new AdBusinessHandler();

        private AdBusinessHandlerHolder() {
        }
    }
}

