/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.applysearch.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.applysearch.dto.ApplyFileDto;
import com.huawei.support.icslite.business.applysearch.dto.ApplyVersionDto;
import com.huawei.support.icslite.business.applysearch.service.ApplySearchBusiness;
import com.huawei.support.icslite.business.applysearch.vo.QueryApplyFileVo;
import com.huawei.support.icslite.business.applysearch.vo.QueryApplyVo;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.common.util.HoupHttpsUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplySearchBusinessHandler
implements ApplySearchBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(ApplySearchBusinessHandler.class);

    private ApplySearchBusinessHandler() {
    }

    public static ApplySearchBusinessHandler getInstance() {
        return ApplySearchBusinessHolder.INSTANCE;
    }

    @Override
    public QueryApplyVo getApplyList(String domain) {
        String responseJsonString = HoupHttpsUtils.doGetByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.apply.list.url") + "?domain=" + domain, Collections.singletonMap("lang", ConfigServiceHandler.getInstance().get("system.lang")));
        QueryApplyVo queryApplyVo = new QueryApplyVo();
        if (StringUtils.isBlank((CharSequence)responseJsonString)) {
            CodeCCUtils.INSTANCE.errorLog(log, "get user apply error");
            return queryApplyVo;
        }
        return (QueryApplyVo)JSONObject.parseObject((String)responseJsonString, QueryApplyVo.class);
    }

    @Override
    public QueryApplyFileVo getApplyFile(ApplyFileDto applyFileDto) {
        QueryApplyFileVo queryApplyFileTotal = new QueryApplyFileVo();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        for (ApplyVersionDto applyVersionDto : applyFileDto.getApplyVersionList()) {
            queryMap.put("domain", applyFileDto.getDomain());
            queryMap.put("applyNum", applyVersionDto.getApplyNum());
            String responseJsonString = HoupHttpsUtils.doPostByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.apply.file.url"), queryMap, null);
            QueryApplyFileVo queryApplyFile = (QueryApplyFileVo)JSONObject.parseObject((String)responseJsonString, QueryApplyFileVo.class);
            if (ObjectUtils.isEmpty((Object)queryApplyFile) || CollectionUtils.isEmpty(queryApplyFile.getData())) continue;
            queryApplyFile.getData().forEach(applyFileVo -> applyFileVo.setVersionName(applyVersionDto.getVersionName()));
            queryApplyFileTotal.getData().addAll(queryApplyFile.getData());
            if (!StringUtils.isEmpty((CharSequence)queryApplyFileTotal.getDestUrl())) continue;
            queryApplyFileTotal.setDestUrl(queryApplyFile.getDestUrl());
        }
        queryApplyFileTotal.setTotal(queryApplyFileTotal.getData().size());
        return queryApplyFileTotal;
    }

    private static class ApplySearchBusinessHolder {
        private static final ApplySearchBusinessHandler INSTANCE = new ApplySearchBusinessHandler();

        private ApplySearchBusinessHolder() {
        }
    }
}

