/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.authorization.dao;

import com.huawei.support.ics.common.adapter.encryption.service.factory.DataSecurityHandlerFactory;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icslite.business.authorization.dto.CsTokenResponseDto;
import com.huawei.support.icslite.business.authorization.dto.LoginParamsDto;
import com.huawei.support.icslite.business.authorization.util.LoginUtils;
import com.huawei.support.icslite.common.resources.software.dto.SoftwareDto;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public class UniportalAuthDaoHandler {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(UniportalAuthDaoHandler.class);
    private static final int AUTH_ENCRYPTION_DOMAIN_KEY_ID = 4;
    private static final String MTOKEN_USER_INFO_FILE = IcsCommonServiceHandler.getInstance().getSysAppDataPath() + File.separator + "mtokenUserInfo.properties";
    private static final String REMEMBER_ACCOUNT_NAME_FILE = IcsCommonServiceHandler.getInstance().getSysAppDataPath() + File.separator + "rememberAccountName.properties";
    private Map<String, String> userAuthInfoMap = new ConcurrentHashMap(8);
    private LoginParamsDto loginParamsDto;

    private UniportalAuthDaoHandler() {
        this.setLoginParamsDto();
    }

    public static UniportalAuthDaoHandler getInstance() {
        return UniportalAuthDaoHandlerHolder.INSTANCE;
    }

    public LoginParamsDto getLoginParamsDto() {
        return this.loginParamsDto;
    }

    public void clear() {
        if (MapUtils.isNotEmpty(this.userAuthInfoMap)) {
            this.userAuthInfoMap.clear();
        }
    }

    public void saveMtokenAndMacAddress(String mtoken) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        this.saveMtokenInMemory(mtoken, timestamp);
        String encryptMtoken = this.getDpapiEncryptString(mtoken);
        this.saveMtokenAndMacAddressToLocalFile(timestamp, encryptMtoken);
    }

    private String getDpapiEncryptString(String plainText) {
        return this.encryptStr(Base64.encodeBase64String((byte[])plainText.getBytes(StandardCharsets.UTF_8)));
    }

    public void saveRememberAccountNameConfig(Map<String, String> configMap) {
        if (!this.createConfigFile(REMEMBER_ACCOUNT_NAME_FILE)) {
            return;
        }
        if (this.storeProperties(configMap, REMEMBER_ACCOUNT_NAME_FILE)) {
            return;
        }
        CodeCCUtils.INSTANCE.errorLog(log, "saveRememberAccountNameConfig fail");
    }

    public String getMtoken() {
        return this.userAuthInfoMap.get("mtoken");
    }

    public void saveToken(String token) {
        this.userAuthInfoMap.put("token", token);
        this.userAuthInfoMap.put("token_timestamp", String.valueOf(System.currentTimeMillis()));
    }

    public String getToken() {
        return this.userAuthInfoMap.get("token");
    }

    public void saveSsoUuid(String ssoUuid) {
        this.userAuthInfoMap.put("ssouuid", ssoUuid);
    }

    public String getSsoUuid() {
        return this.userAuthInfoMap.get("ssouuid");
    }

    public CsTokenResponseDto.TokenDto getSsoToken() {
        CsTokenResponseDto tokenDto = LoginUtils.getTokenDto(this.getToken(), CsTokenResponseDto.class);
        return tokenDto.getToken();
    }

    public boolean isTokenOrMtokenValid(String tokenName, String timeKey, long cycleTime) {
        if (this.isTokenOrMtokenBlank(tokenName)) {
            return false;
        }
        String timestampText = this.userAuthInfoMap.get(timeKey);
        if (StringUtils.isNotBlank((CharSequence)timestampText)) {
            long timestamp = Long.parseLong(timestampText);
            return LoginUtils.isValidPeriodOk(timestamp, cycleTime);
        }
        return false;
    }

    public boolean isTokenOrMtokenBlank(String tokenName) {
        String tokenOrMtoken = "";
        if (StringUtils.equals((CharSequence)tokenName, (CharSequence)"mtoken")) {
            tokenOrMtoken = this.getMtoken();
        }
        if (StringUtils.equals((CharSequence)tokenName, (CharSequence)"token")) {
            tokenOrMtoken = this.getToken();
        }
        return StringUtils.isBlank((CharSequence)tokenOrMtoken);
    }

    public boolean isLocalMtokenValid() {
        Properties mtokenProperties = LoginUtils.getPropertiesByFile(MTOKEN_USER_INFO_FILE);
        String mtoken = this.decryptLocalEncryptValue(mtokenProperties, "mtoken");
        if (StringUtils.isBlank((CharSequence)mtoken)) {
            return false;
        }
        String mtokenTimeStamp = mtokenProperties.getProperty("mtoken_timestamp");
        if (StringUtils.isBlank((CharSequence)mtokenTimeStamp)) {
            CodeCCUtils.INSTANCE.infoLog(log, "Local Mtoken TimeStamp isBlank");
            return false;
        }
        long timestamp = 0L;
        try {
            timestamp = Long.parseLong(mtokenTimeStamp);
        }
        catch (NumberFormatException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Local Mtoken TimeStamp Parse Is Error", (Throwable)e);
        }
        boolean isValidPeriodOk = LoginUtils.isValidPeriodOk(timestamp, 31104000000L);
        if (isValidPeriodOk) {
            this.saveMtokenInMemory(mtoken, mtokenTimeStamp);
        }
        return isValidPeriodOk;
    }

    public String getLocalDeviceId() {
        Properties mtokenProperties = LoginUtils.getPropertiesByFile(MTOKEN_USER_INFO_FILE);
        return this.decryptLocalEncryptValue(mtokenProperties, "mac_address");
    }

    private String decryptLocalEncryptValue(Properties properties, String propKey) {
        String encryptPropValue = properties.getProperty(propKey);
        if (StringUtils.isBlank((CharSequence)encryptPropValue)) {
            CodeCCUtils.INSTANCE.infoLog(log, "Local {0} isBlank", new Object[]{propKey});
            return "";
        }
        String decryptPropValue = this.decryptStr(encryptPropValue);
        if (StringUtils.isBlank((CharSequence)decryptPropValue)) {
            CodeCCUtils.INSTANCE.infoLog(log, "Local {0} Decrypt isBlank", new Object[]{propKey});
            return "";
        }
        return decryptPropValue;
    }

    private String encryptStr(String plainText) {
        return Base64.encodeBase64String((byte[])DataSecurityHandlerFactory.getInstance((String)"DPAPI").encrypt(4, plainText));
    }

    private String decryptStr(String encryptStr) {
        String decrpyMtoken = DataSecurityHandlerFactory.getInstance((String)"DPAPI").decrpy(4, Base64.decodeBase64((String)encryptStr));
        return new String(Base64.decodeBase64((String)decrpyMtoken), StandardCharsets.UTF_8);
    }

    private void saveMtokenInMemory(String mtoken, String timestamp) {
        this.userAuthInfoMap.put("mtoken", mtoken);
        this.userAuthInfoMap.put("mtoken_timestamp", timestamp);
    }

    private void saveMtokenAndMacAddressToLocalFile(String timestamp, String encryptMtoken) {
        if (!this.createConfigFile(MTOKEN_USER_INFO_FILE)) {
            return;
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("mtoken", encryptMtoken);
        configMap.put("mtoken_timestamp", timestamp);
        String encryptDeviceId = this.getDpapiEncryptString(this.loginParamsDto.getDeviceId());
        if (StringUtils.isNotBlank((CharSequence)encryptDeviceId)) {
            configMap.put("mac_address", encryptDeviceId);
        } else {
            CodeCCUtils.INSTANCE.errorLog(log, "saveMtokenAndMacAddressToLocalFile encryptDeviceId is blank");
        }
        if (this.storeProperties(configMap, MTOKEN_USER_INFO_FILE)) {
            return;
        }
        CodeCCUtils.INSTANCE.errorLog(log, "saveMtokenAndMacAddressToLocalFile fail");
    }

    private boolean storeProperties(Map<String, String> configMap, String filePath) {
        Properties mtokeProperties = new Properties();
        configMap.forEach((configKey, configVsalue) -> mtokeProperties.put(configKey, configVsalue));
        return PropertiesUtils.storeProperties((Properties)mtokeProperties, (String)filePath);
    }

    private boolean createConfigFile(String filePath) {
        File file = FileUtils.getFile((String[])new String[]{filePath});
        if (file.exists()) {
            return true;
        }
        String fileName = file.getName();
        try {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                CodeCCUtils.INSTANCE.errorLog(log, "{0} Parent file is null.", new Object[]{fileName});
                return false;
            }
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                CodeCCUtils.INSTANCE.errorLog(log, "{0} Parent dir create failed.", new Object[]{fileName});
                return false;
            }
            if (!file.createNewFile()) {
                CodeCCUtils.INSTANCE.errorLog(log, "{0} file create failed.", new Object[]{fileName});
                return false;
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "{0} file create error.", (Throwable)e, new Object[]{fileName});
            return false;
        }
        return true;
    }

    public void deleteLocalMtokenFile() {
        this.deleteLocalConfigFile(MTOKEN_USER_INFO_FILE);
    }

    public void deleteLocalRememberAccountNameFile() {
        this.deleteLocalConfigFile(REMEMBER_ACCOUNT_NAME_FILE);
    }

    private void deleteLocalConfigFile(String filePath) {
        File configFile = FileUtils.getFile((String[])new String[]{filePath});
        String configFileName = configFile.getName();
        if (!configFile.exists()) {
            CodeCCUtils.INSTANCE.infoLog(log, "Delete {0} file, but the file is not exist.", new Object[]{configFileName});
            return;
        }
        if (!FileUtils.deleteQuietly((File)configFile)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Delete {0} config fail.", new Object[]{configFileName});
        }
        CodeCCUtils.INSTANCE.infoLog(log, "Delete {0} config success.", new Object[]{configFileName});
    }

    public Map<String, String> getRememberAccountNameCookieMap() {
        HashMap<String, String> rememberAccountNameCookieMap = new HashMap<String, String>();
        Properties rememberAccountNameProperties = LoginUtils.getPropertiesByFile(REMEMBER_ACCOUNT_NAME_FILE);
        rememberAccountNameCookieMap.put("loginAccountMobile", this.getPropertyIfBlankReturnEmpty(rememberAccountNameProperties, "loginAccountMobile"));
        rememberAccountNameCookieMap.put("rememberAccountNameMobile", this.getPropertyIfBlankReturnEmpty(rememberAccountNameProperties, "rememberAccountNameMobile"));
        return rememberAccountNameCookieMap;
    }

    private void setLoginParamsDto() {
        SoftwareDto softwareInfo = IcsCommonServiceHandler.getInstance().getSoftwareInfo();
        if (softwareInfo == null) {
            return;
        }
        String version = softwareInfo.getSoftName() + ":" + softwareInfo.getSoftVersion();
        String lang = ConfigServiceHandler.getInstance().get("system.lang");
        String deviceId = LoginUtils.getMacAddress();
        String clientIp = LoginUtils.getIpAddress();
        this.loginParamsDto = new LoginParamsDto.Builder().version(version).lang(lang).deviceId(deviceId).clientIp(clientIp).build();
    }

    private String getPropertyIfBlankReturnEmpty(Properties properties, String propertyKey) {
        return (String)StringUtils.defaultIfBlank((CharSequence)properties.getProperty(propertyKey), (CharSequence)"");
    }

    private static final class UniportalAuthDaoHandlerHolder {
        private static final UniportalAuthDaoHandler INSTANCE = new UniportalAuthDaoHandler();

        private UniportalAuthDaoHandlerHolder() {
        }
    }
}

