/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.authorization.dto;

import org.apache.commons.lang3.StringUtils;

public class LoginParamsDto {
    private String version;
    private String redirect;
    private String lang;
    private String deviceId;
    private String clientIp;

    private LoginParamsDto(Builder builder) {
        this.version = builder.version;
        this.redirect = builder.redirect;
        this.lang = builder.lang;
        this.deviceId = builder.deviceId;
        this.clientIp = builder.clientIp;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public String getLang() {
        return this.lang;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public static class Builder {
        private String version;
        private String redirect;
        private String lang;
        private String deviceId;
        private String clientIp;

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder redirect(String redirect) {
            this.redirect = redirect;
            return this;
        }

        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public LoginParamsDto build() {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.version, this.lang, this.deviceId, this.clientIp})) {
                throw new IllegalArgumentException("version and redirect and lang and deviceId and clientIp are mandatory.");
            }
            return new LoginParamsDto(this);
        }
    }
}

