/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.authorization.serviceimpl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icslite.business.authorization.dto.CertificateDto;
import com.huawei.support.icslite.business.authorization.dto.CertificateRequestDto;
import com.huawei.support.icslite.business.authorization.dto.CertificateStatus;
import com.huawei.support.icslite.business.authorization.dto.GenerateCsrDto;
import com.huawei.support.icslite.business.authorization.mapper.CertificateConverter;
import com.huawei.support.icslite.business.authorization.service.CertificateBusiness;
import com.huawei.support.icslite.business.authorization.util.CertificateUtils;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.common.util.HoupHttpsUtils;
import com.huawei.support.icslite.certificate.service.impl.CertificateServiceHandler;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class CertificateBusinessHandler
implements CertificateBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(CertificateBusinessHandler.class);
    private static final AtomicReference<CertificateStatus> ATOMIC_REFERENCE = new AtomicReference<CertificateStatus>(CertificateStatus.INIT_CERTIFICATE);
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    private CertificateBusinessHandler() {
    }

    public static CertificateBusinessHandler getInstance() {
        return CertificateBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        CertificateServiceHandler.getInstance().createTb();
    }

    @Override
    public boolean issueCertificate() {
        if (StringUtils.equals((CharSequence)ATOMIC_REFERENCE.get().getCode(), (CharSequence)CertificateStatus.ISSUING_CERTIFICATE.getCode())) {
            return true;
        }
        CertificateDto certificateDto = this.getCertificateDto();
        if (Objects.isNull(certificateDto) || !this.checkPrivateKey(certificateDto) || !this.checkDeviceId(certificateDto.getCertificate())) {
            ATOMIC_REFERENCE.getAndSet(CertificateStatus.ISSUING_CERTIFICATE);
            Optional<CertificateDto> certificateDtoOptional = this.getRemoteCertificate();
            if (!certificateDtoOptional.isPresent()) {
                ATOMIC_REFERENCE.getAndSet(CertificateStatus.ISSUE_CERTIFICATE_ERROR);
                return false;
            }
            CertificateServiceHandler.getInstance().addCertificate(CertificateConverter.INSTANCE.convertDtoToDo(certificateDtoOptional.get()));
            NetworkServiceHandler.getInstance().initHoupHttpClient();
        }
        ATOMIC_REFERENCE.getAndSet(CertificateStatus.ISSUED_CERTIFICATE);
        return true;
    }

    @Override
    public CertificateDto getCertificateDto() {
        CertificateDto certificateDto = CertificateConverter.INSTANCE.convertDoToDto(CertificateServiceHandler.getInstance().getCertificate());
        if (Objects.isNull(certificateDto) || Objects.isNull(certificateDto.getCertificate())) {
            CodeCCUtils.INSTANCE.errorLog(log, "Get Certificate has error, database save is null");
            return null;
        }
        return certificateDto;
    }

    @Override
    public String getIssueCertificateStatus() {
        return ATOMIC_REFERENCE.get().getCode();
    }

    @Override
    public void updateCertificate() {
        if (StringUtils.equalsAny((CharSequence)ATOMIC_REFERENCE.get().getCode(), (CharSequence[])new CharSequence[]{CertificateStatus.ISSUING_CERTIFICATE.getCode(), CertificateStatus.UPDATING_CERTIFICATE.getCode()})) {
            return;
        }
        CertificateDto certificateDto = this.getCertificateDto();
        if (this.checkValidTime(certificateDto.getCertificate())) {
            return;
        }
        boolean compareResult = ATOMIC_REFERENCE.compareAndSet(CertificateStatus.ISSUED_CERTIFICATE, CertificateStatus.UPDATING_CERTIFICATE);
        if (!compareResult) {
            CodeCCUtils.INSTANCE.errorLog(log, "Update certificate has exception, change reference error");
            return;
        }
        this.updateLocalCertificate(certificateDto);
    }

    private void updateLocalCertificate(CertificateDto certificateDto) {
        Optional<CertificateRequestDto> certificateRequestDtoOptional = CertificateUtils.generateCsr(new GenerateCsrDto(this.getDeviceId()));
        if (!certificateRequestDtoOptional.isPresent()) {
            ATOMIC_REFERENCE.set(CertificateStatus.ISSUE_CERTIFICATE_ERROR);
            return;
        }
        String renewCertificateUrl = UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.renew.certificate.url");
        String resultJsonString = HoupHttpsUtils.doPostByCert(renewCertificateUrl, Collections.singletonMap("certReqFile", certificateRequestDtoOptional.get().getCsr()), new HashMap<String, String>());
        Optional<String> resultValueOpt = HoupHttpsUtils.getResultValue(resultJsonString, true, "certContent");
        if (!resultValueOpt.isPresent()) {
            ATOMIC_REFERENCE.set(CertificateStatus.ISSUE_CERTIFICATE_ERROR);
            return;
        }
        certificateDto.setCertificate(resultValueOpt.get());
        certificateDto.setPrivateKey(certificateRequestDtoOptional.get().getPrivateKey());
        CertificateServiceHandler.getInstance().updateCertificate(CertificateConverter.INSTANCE.convertDtoToDo(certificateDto));
        NetworkServiceHandler.getInstance().initHoupHttpClient();
        CodeCCUtils.INSTANCE.infoLog(log, "Update certificate is successful");
        ATOMIC_REFERENCE.set(CertificateStatus.ISSUED_CERTIFICATE);
    }

    private Optional<CertificateDto> getRemoteCertificate() {
        CodeCCUtils.INSTANCE.infoLog(log, "start get remote certificate");
        Optional<CertificateRequestDto> certificateRequestDtoOptional = CertificateUtils.generateCsr(new GenerateCsrDto(this.getDeviceId()));
        if (!certificateRequestDtoOptional.isPresent()) {
            return Optional.empty();
        }
        CertificateRequestDto certificateRequestDto = certificateRequestDtoOptional.get();
        String issueCertificateUrl = UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.ISSUE.NGINX", "icslite.houp.issue.certificate.url");
        try {
            HttpClientDto.Builder clientDtoBuilder = NetworkServiceHandler.getInstance().getHttpClientForHuawei().newBuilder().url(issueCertificateUrl);
            clientDtoBuilder.params(Collections.singletonMap("certReqFile", certificateRequestDto.getCsr()));
            HttpClientDto clientDto = clientDtoBuilder.build();
            CertificateDto certificateDto = new CertificateDto();
            certificateDto.setPrivateKey(certificateRequestDto.getPrivateKey());
            Optional<String> resultOpt = this.parseResult(NetWorkUtil.post((HttpClientDto)clientDto));
            if (!resultOpt.isPresent()) {
                return Optional.empty();
            }
            certificateDto.setCertificate(resultOpt.get());
            CodeCCUtils.INSTANCE.infoLog(log, "Get remote certificate has successful");
            return Optional.of(certificateDto);
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "network switch is not open", (Throwable)e);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "get response error", (Throwable)e);
        }
        catch (CustomSslException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Local certificate not available", (Throwable)e);
        }
        return Optional.empty();
    }

    private Optional<String> parseResult(String responseStr) {
        Map responseMap = (Map)JSONObject.parseObject((String)responseStr, MAP_TYPE_REFERENCE, (Feature[])new Feature[0]);
        return HoupHttpsUtils.getResultValue(responseMap.get("result"), false, "certContent");
    }

    private boolean checkDeviceId(String certificate) {
        Optional<X509Certificate> x509ByCertOpt = CertificateUtils.getX509ByCert(certificate);
        return x509ByCertOpt.filter(x509Certificate -> StringUtils.equals((CharSequence)x509Certificate.getSubjectDN().toString(), (CharSequence)new GenerateCsrDto(this.getDeviceId()).toString())).isPresent();
    }

    private boolean checkPrivateKey(CertificateDto certificateDto) {
        PrivateKey privateKey;
        PublicKey publicValByCert = CertificateUtils.getPublicKeyByCert(certificateDto.getCertificate());
        boolean verifyPrivateKey = CertificateUtils.checkPrivateKey(publicValByCert, privateKey = CertificateUtils.getPrivateKeyByStr(certificateDto.getPrivateKey()));
        if (verifyPrivateKey) {
            CodeCCUtils.INSTANCE.infoLog(log, "Check private Key success!");
        }
        return verifyPrivateKey;
    }

    private String getDeviceId() {
        String clientIdFilePath = IcsCommonServiceHandler.getInstance().getSysProgramDataPath() + ConfigServiceHandler.getInstance().get("system.lang") + CommonConstants.CLIENT_MARK;
        return IcsFileUtils.readFileContent((String)clientIdFilePath, null);
    }

    private boolean checkValidTime(String cert) {
        Optional<X509Certificate> x509ByCertOpt = CertificateUtils.getX509ByCert(cert);
        if (x509ByCertOpt.isPresent()) {
            Date expireTime = x509ByCertOpt.get().getNotAfter();
            Date date = DateUtils.plusNumMonths((Date)new Date(), (int)1);
            return !date.after(expireTime);
        }
        return false;
    }

    private static class CertificateBusinessHandlerHolder {
        private static final CertificateBusinessHandler INSTANCE = new CertificateBusinessHandler();

        private CertificateBusinessHandlerHolder() {
        }
    }
}

