/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.authorization.serviceimpl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icscbb.util.response.ResultCode;
import com.huawei.support.icscbb.util.response.ServiceResponse;
import com.huawei.support.icslite.business.authorization.dao.UniportalAuthDaoHandler;
import com.huawei.support.icslite.business.authorization.dto.AuthoUrlDto;
import com.huawei.support.icslite.business.authorization.dto.AutoLoginMessageDto;
import com.huawei.support.icslite.business.authorization.dto.CsAuthErrorCode;
import com.huawei.support.icslite.business.authorization.dto.CsTokenResponseDto;
import com.huawei.support.icslite.business.authorization.dto.LoginParamsDto;
import com.huawei.support.icslite.business.authorization.service.UniportalAuthorizationBusiness;
import com.huawei.support.icslite.business.authorization.strategy.JfxLoginPageStrategyHandler;
import com.huawei.support.icslite.business.authorization.util.LoginUtils;
import com.huawei.support.icslite.business.common.dto.LoginInfo;
import com.huawei.support.icslite.business.common.dto.UrlDataDto;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.preferences.serviceimpl.PreferencesServiceHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class UniportalAuthorizationBusinessHandler
implements UniportalAuthorizationBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(UniportalAuthorizationBusinessHandler.class);
    private static final String SSO_MANAGEMENT_URL_KEY = "oauth.ssomanagementurl";
    private static final String CS_SSO_MANAGEMENT_URL_KEY = "oauth.cs.ssomanagementurl";
    private static final String OAUTH_CS_AUTHORIZE_MTOKEN_URL_KEY = "oauth.cs.authorizemtokenurl";
    private static final String OAUTH_CS_AUTHORIZE_TOKEN_URL_KEY = "oauth.cs.authorizetokenurl";
    private static final String OAUTH_CS_AUTHORIZE_CS_LOGOUT_URL_KEY = "oauth.cs.authorizecslogouturl";
    private static final String ICSLITE_MTOKEN_AUTH_BASE_URL_KEY = "/api/oauth2/rest/v1/authorization";
    private static final String HDX_FEED_BACK = "hdxFeedbackInfoDataV2";
    private static final String ICS_FEED_BACK = "icsFeedbackInfoDataV2";
    private static final String VIEW_FEED_BACK = "viewFeedback";
    private static final List<String> REDIRECT_WHITE_LIST = Arrays.asList(UniportalAuthorizationBusinessHandler.getUrl("hdxFeedbackInfoDataV2"), UniportalAuthorizationBusinessHandler.getUrl("icsFeedbackInfoDataV2"), UniportalAuthorizationBusinessHandler.getUrl("viewFeedback"));
    private static final List<String> MTOKEN_INVALIDATION_CODES = Collections.unmodifiableList(Arrays.asList("IDC-03-00015", "IDC-03-00018", "IDC-03-00022", "IDC-03-00056"));
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final LoginInfo loginInfo = new LoginInfo();
    private LoginParamsDto loginParamsDto = UniportalAuthDaoHandler.getInstance().getLoginParamsDto();

    private UniportalAuthorizationBusinessHandler() {
    }

    public static UniportalAuthorizationBusinessHandler getInstance() {
        return UniportalAuthorizationBusinessHandlerHolder.INSTANCE;
    }

    private static String getUrl(String key) {
        UrlDataDto urlDataDto = UrlDataServiceHandler.getInstance().getUrlOrDefault(null, key, false, "");
        return urlDataDto.getMainUrl();
    }

    @Override
    public void csLogOut() {
        if (this.isMtokenInValid()) {
            this.clearAuthInfo(false);
            return;
        }
        String oauthLogOutUrl = UniportalAuthorizationBusinessHandler.getUrl(OAUTH_CS_AUTHORIZE_CS_LOGOUT_URL_KEY);
        Map<String, String> bodies = this.buildBody();
        bodies.put("ssouuid", UniportalAuthDaoHandler.getInstance().getSsoUuid());
        Optional<ServiceResponse<Object>> response = this.sendRequest(oauthLogOutUrl, bodies, true);
        boolean isPresent = response.isPresent();
        if (!isPresent || response.get().getCode() == ResultCode.ERROR.getReusltCode()) {
            OperationLogUtils.INSTANCE.failOperationLog("icslite-authorization-business-service", "AUTHORIZATION", "log out");
            String msg = isPresent ? response.get().getMsg() : "";
            CodeCCUtils.INSTANCE.errorLog(log, "failed to log out and error code is {0} : ", new Object[]{msg});
        } else {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-authorization-business-service", "AUTHORIZATION", "log out");
        }
        this.clearAuthInfo(false);
        this.loginParamsDto.setDeviceId(LoginUtils.getMacAddress());
    }

    @Override
    public Map<String, Object> getAuthorizedInfo() {
        return this.loginInfo.getLoginInfo();
    }

    @Override
    public boolean isLogin() {
        Map<String, Object> loginInfoMap = this.loginInfo.getLoginInfo();
        return (Boolean)loginInfoMap.get("status");
    }

    @Override
    public Map<String, Object> getSsoCookieInfo() {
        Object responseData;
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String actionUrl = UniportalAuthorizationBusinessHandler.getUrl(SSO_MANAGEMENT_URL_KEY);
        responseMap.put("actionUrl", actionUrl);
        Optional<ServiceResponse<Object>> response = this.sendRequest(UniportalAuthorizationBusinessHandler.getUrl("oauth.ssocookieurl"), null, false);
        Map<Object, Object> ssoCookies = Collections.emptyMap();
        if (response.isPresent() && response.get().getCode() == ResultCode.SUCCESS.getReusltCode() && response.get().getData() != null && (responseData = response.get().getData()) instanceof Map) {
            ssoCookies = this.getResponseDataMap(JsonUtils.objectToString((Object)responseData));
        }
        responseMap.put("ssoCookie", ssoCookies);
        return responseMap;
    }

    @Override
    public void login(String appReqRootUrl) {
        if (this.hasAutoLogin()) {
            EventBusUtils.INSTANCE.getEventBus().post((Object)new AutoLoginMessageDto(true, false));
            return;
        }
        this.openWebViewLogin(appReqRootUrl);
    }

    private void openWebViewLogin(String homeBaseUrl) {
        Optional<AuthoUrlDto> authorizationDto = this.getAuthoUrlDto(homeBaseUrl);
        if (authorizationDto.isPresent()) {
            JfxLoginPageStrategyHandler.getInstance().userAuthentication(authorizationDto.get());
            return;
        }
        this.recordeFailOperationLog(CsAuthErrorCode.AUTHO_URL_DTO_EMPTY.getDescription());
    }

    private Optional<AuthoUrlDto> getAuthoUrlDto(String homeBaseUrl) {
        String authMtokenUrl = homeBaseUrl + ICSLITE_MTOKEN_AUTH_BASE_URL_KEY;
        if (StringUtils.isBlank((CharSequence)authMtokenUrl)) {
            CodeCCUtils.INSTANCE.errorLog(log, CsAuthErrorCode.AUTH_MTOKEN_URL_BLANK.getDescription());
            return Optional.empty();
        }
        String redirectUrl = URI.create(this.verifyUrl(authMtokenUrl)).normalize().toString();
        String authUserInfoUrl = this.getAuthorizationUrl();
        if (StringUtils.isBlank((CharSequence)authUserInfoUrl)) {
            CodeCCUtils.INSTANCE.errorLog(log, CsAuthErrorCode.AUTH_USER_INFO_URL_BLANK.getDescription());
            return Optional.empty();
        }
        return Optional.of(new AuthoUrlDto(authUserInfoUrl, redirectUrl));
    }

    @Override
    public boolean mtokenAuthSaveUserInfo(boolean isAutoLogin) {
        if (!isAutoLogin && this.isMtokenInValid()) {
            this.clearAuthInfo(false);
            this.recordeFailOperationLog(CsAuthErrorCode.MTOKEN_INVALID.getDescription());
            return false;
        }
        Map<String, Object> tokenAndUuidMap = this.mtokenAuth(isAutoLogin);
        if (MapUtils.isEmpty(tokenAndUuidMap)) {
            return false;
        }
        JSONObject csToken = (JSONObject)tokenAndUuidMap.get("token");
        if (csToken == null || csToken.isEmpty()) {
            this.recordeFailOperationLog(CsAuthErrorCode.CSTOKEN_BLANK.getDescription());
            return false;
        }
        String csTokenJson = csToken.toJSONString();
        CsTokenResponseDto csTokenResponseDto = LoginUtils.getTokenDto(csTokenJson, CsTokenResponseDto.class);
        if (csTokenResponseDto == null || csTokenResponseDto.getToken() == null || csTokenResponseDto.getUserInfo() == null) {
            this.recordeFailOperationLog(CsAuthErrorCode.CSTOKEN_RESPONSE_DTO_BLANK.getDescription());
            return false;
        }
        String ssouuid = (String)tokenAndUuidMap.get("ssouuid");
        this.saveAuthInfo(csTokenJson, ssouuid);
        this.loginInfo.set(csTokenResponseDto.getUserInfo().getUid());
        return true;
    }

    private void recordeFailOperationLog(String description) {
        OperationLogUtils.INSTANCE.failOperationLog("icslite-authorization-business-service", "AUTHORIZATION", "Authorization failed. because {0}", new Object[]{description});
    }

    @Override
    public boolean isTokenValid() {
        return UniportalAuthDaoHandler.getInstance().isTokenOrMtokenValid("token", "token_timestamp", 1500000L);
    }

    @Override
    public synchronized Map<String, String> getSsoUuidInfo() {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        String actionUrl = UniportalAuthorizationBusinessHandler.getUrl(CS_SSO_MANAGEMENT_URL_KEY);
        if (StringUtils.isBlank((CharSequence)actionUrl)) {
            return responseMap;
        }
        Optional<String> ssoUuid = this.getSsoUuid();
        if (!ssoUuid.isPresent()) {
            return responseMap;
        }
        responseMap.put("ssoUuid", ssoUuid.get());
        responseMap.put("actionUrl", actionUrl);
        return responseMap;
    }

    @Override
    public synchronized Optional<CsTokenResponseDto.TokenDto> getSsoToken() {
        Object tokenObject;
        Optional<Object> ssotoken = this.getAuthOptional("token");
        if (ssotoken.isPresent() && (tokenObject = ssotoken.get()) instanceof CsTokenResponseDto.TokenDto) {
            return Optional.ofNullable((CsTokenResponseDto.TokenDto)tokenObject);
        }
        return Optional.empty();
    }

    @Override
    public synchronized Optional<String> getSsoUuid() {
        Object uuidObject;
        Optional<Object> ssouuid = this.getAuthOptional("ssouuid");
        if (ssouuid.isPresent() && (uuidObject = ssouuid.get()) instanceof String) {
            return Optional.ofNullable((String)uuidObject);
        }
        return Optional.empty();
    }

    private Optional<Object> getAuthOptional(String authInfoNanme) {
        if (UniportalAuthDaoHandler.getInstance().isTokenOrMtokenBlank("token")) {
            return Optional.empty();
        }
        if (this.isTokenValid()) {
            return this.getAuthInfo(authInfoNanme);
        }
        if (this.isMtokenInValid()) {
            this.clearAuthInfo(false);
            return Optional.empty();
        }
        if (this.isRefreshedToken()) {
            return this.getAuthInfo(authInfoNanme);
        }
        return Optional.empty();
    }

    private synchronized Optional<Object> getAuthInfo(String authInfoNanme) {
        if (StringUtils.equals((CharSequence)authInfoNanme, (CharSequence)"ssouuid")) {
            return Optional.ofNullable(UniportalAuthDaoHandler.getInstance().getSsoUuid());
        }
        if (StringUtils.equals((CharSequence)authInfoNanme, (CharSequence)"token")) {
            return Optional.ofNullable(UniportalAuthDaoHandler.getInstance().getSsoToken());
        }
        return Optional.empty();
    }

    @Override
    public boolean hasAutoLogin() {
        boolean isSuccess;
        if (StringUtils.equals((CharSequence)PreferencesServiceHandler.getInstance().getAutoLoginSwitchStatus(), (CharSequence)"0")) {
            CodeCCUtils.INSTANCE.warnLog(log, "auto login AutoLogInSwitchStatus is OFF");
            return false;
        }
        if (!UniportalAuthDaoHandler.getInstance().isLocalMtokenValid()) {
            CodeCCUtils.INSTANCE.warnLog(log, "auto login LocalMtoken is Invalidation");
            return false;
        }
        String localDeviceId = UniportalAuthDaoHandler.getInstance().getLocalDeviceId();
        if (StringUtils.isNotBlank((CharSequence)localDeviceId)) {
            this.loginParamsDto.setDeviceId(localDeviceId);
        }
        if (isSuccess = this.mtokenAuthSaveUserInfo(true)) {
            CodeCCUtils.INSTANCE.infoLog(log, "auto login success");
        } else {
            CodeCCUtils.INSTANCE.warnLog(log, "auto login failed");
        }
        return isSuccess;
    }

    public boolean isPassingRedirectWhiteList(String redirectUrl) {
        return REDIRECT_WHITE_LIST.stream().anyMatch(redirectwhiteStr -> StringUtils.startsWith((CharSequence)redirectUrl, (CharSequence)redirectwhiteStr));
    }

    private boolean isMtokenInValid() {
        return !UniportalAuthDaoHandler.getInstance().isTokenOrMtokenValid("mtoken", "mtoken_timestamp", 31104000000L);
    }

    private boolean isRefreshedToken() {
        Map<String, Object> tokenAndUuidMap = this.mtokenAuth(false);
        if (MapUtils.isEmpty(tokenAndUuidMap)) {
            return false;
        }
        Optional<CsTokenResponseDto> csToken = this.getCsToken(tokenAndUuidMap);
        if (!csToken.isPresent()) {
            return false;
        }
        String csTokenJson = JsonUtils.objectToString((Object)csToken.get());
        UniportalAuthDaoHandler.getInstance().saveToken(csTokenJson);
        this.saveSsoUuid((String)tokenAndUuidMap.get("ssouuid"));
        return true;
    }

    private Optional<CsTokenResponseDto> getCsToken(Map<String, Object> tokenAndUuidMap) {
        if (MapUtils.isEmpty(tokenAndUuidMap)) {
            return Optional.empty();
        }
        String csTokenJsonStr = this.getCsTokenJsonStr(tokenAndUuidMap);
        if (StringUtils.isBlank((CharSequence)csTokenJsonStr)) {
            return Optional.empty();
        }
        return Optional.ofNullable(LoginUtils.getTokenDto(csTokenJsonStr, CsTokenResponseDto.class));
    }

    private String getCsTokenJsonStr(Map<String, Object> tokenAndUuidMap) {
        Object tokenJsonObject = tokenAndUuidMap.get("token");
        if (tokenJsonObject instanceof JSONObject) {
            return ((JSONObject)tokenJsonObject).toJSONString();
        }
        CodeCCUtils.INSTANCE.errorLog(log, "failed to obtain the cstoken.");
        return "";
    }

    private Map<String, Object> mtokenAuth(boolean isAutoLogin) {
        String oauthTokenUrl = UniportalAuthorizationBusinessHandler.getUrl(OAUTH_CS_AUTHORIZE_TOKEN_URL_KEY);
        Map<String, String> bodies = this.buildBody();
        Optional<ServiceResponse<Object>> tokenResp = this.sendRequest(oauthTokenUrl, bodies, true);
        Map<String, Object> responseDataMap = Collections.emptyMap();
        if (!tokenResp.isPresent()) {
            CodeCCUtils.INSTANCE.errorLog(log, "failed to obtain the token and uuid.");
            return responseDataMap;
        }
        if (tokenResp.get().getCode() == ResultCode.ERROR.getReusltCode()) {
            String errorCode = tokenResp.get().getMsg();
            CodeCCUtils.INSTANCE.errorLog(log, "web failed to get token an error code : {0}", new Object[]{errorCode});
            OperationLogUtils.INSTANCE.failOperationLog("icslite-authorization-business-service", "AUTHORIZATION", "Authorization failed.");
            if (MTOKEN_INVALIDATION_CODES.contains(errorCode)) {
                this.clearAuthInfo(isAutoLogin);
            }
            return responseDataMap;
        }
        return this.getResponseDataMap(JsonUtils.objectToString((Object)tokenResp.get().getData()));
    }

    private Map<String, String> buildBody() {
        HashMap<String, String> bodies = new HashMap<String, String>();
        bodies.put("mtoken", UniportalAuthDaoHandler.getInstance().getMtoken());
        bodies.put("deviceId", this.loginParamsDto.getDeviceId());
        bodies.put("clientIp", this.loginParamsDto.getClientIp());
        bodies.put("version", this.loginParamsDto.getVersion());
        return bodies;
    }

    private void saveAuthInfo(String tokenResult, String ssouuid) {
        UniportalAuthDaoHandler.getInstance().saveToken(tokenResult);
        this.saveSsoUuid(ssouuid);
    }

    private void saveSsoUuid(String ssouuid) {
        if (StringUtils.isBlank((CharSequence)ssouuid)) {
            CodeCCUtils.INSTANCE.errorLog(log, CsAuthErrorCode.SSOUUID_BLANK.getDescription());
            return;
        }
        UniportalAuthDaoHandler.getInstance().saveSsoUuid(ssouuid);
    }

    private String getAuthorizationUrl() {
        if (this.loginParamsDto == null) {
            CodeCCUtils.INSTANCE.errorLog(log, "loginParamsDto is null");
            return "";
        }
        String idaasAuthUrl = UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("UNIPORTAL.NGINX", OAUTH_CS_AUTHORIZE_MTOKEN_URL_KEY);
        if (StringUtils.isBlank((CharSequence)idaasAuthUrl)) {
            return "";
        }
        return String.format(Locale.ENGLISH, idaasAuthUrl, this.loginParamsDto.getLang(), this.loginParamsDto.getVersion(), this.loginParamsDto.getDeviceId());
    }

    private Map<String, Object> getResponseDataMap(String data) {
        return (Map)JSONObject.parseObject((String)data, MAP_TYPE_REFERENCE, (Feature[])new Feature[0]);
    }

    private Optional<ServiceResponse<Object>> sendRequest(String url, Map<String, String> param, boolean isPost) {
        if (StringUtils.isBlank((CharSequence)url)) {
            CodeCCUtils.INSTANCE.warnLog(log, "url is blank.");
            return Optional.empty();
        }
        try {
            String result;
            HttpClientDto.Builder clientDtoBuilder = NetworkServiceHandler.getInstance().getHttpClientForHuawei().newBuilder().url(url);
            if (MapUtils.isNotEmpty(param)) {
                clientDtoBuilder.params(param);
            }
            HttpClientDto clientDto = clientDtoBuilder.build();
            String string = result = isPost ? NetWorkUtil.post((HttpClientDto)clientDto) : NetWorkUtil.get((HttpClientDto)clientDto);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                Map responseMap = JsonUtils.stringToMap((String)result);
                return Optional.of(ServiceResponse.getServiceResponse((String)((String)responseMap.get("msg")), (int)((Integer)responseMap.get("code")), responseMap.get("data")));
            }
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "network switch is not open", (Throwable)e);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "get response error", (Throwable)e);
        }
        return Optional.empty();
    }

    private void clearAuthInfo(boolean isAutoLogin) {
        UniportalAuthDaoHandler.getInstance().deleteLocalMtokenFile();
        if (isAutoLogin) {
            return;
        }
        this.loginInfo.reset();
        UniportalAuthDaoHandler.getInstance().clear();
    }

    private String verifyUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        return url.replace(System.lineSeparator(), "");
    }

    private static final class UniportalAuthorizationBusinessHandlerHolder {
        private static final UniportalAuthorizationBusinessHandler INSTANCE = new UniportalAuthorizationBusinessHandler();

        private UniportalAuthorizationBusinessHandlerHolder() {
        }
    }
}

