/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.authorization.strategy;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.http.TrustAllCertsConfig;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.authorization.dao.UniportalAuthDaoHandler;
import com.huawei.support.icslite.business.authorization.dto.AuthoUrlDto;
import com.huawei.support.icslite.business.authorization.dto.AutoLoginMessageDto;
import com.huawei.support.icslite.business.authorization.dto.CsAuthErrorCode;
import com.huawei.support.icslite.business.authorization.strategy.LoginPageStrategy;
import com.huawei.support.icslite.business.common.dto.ProxyDto;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkConnServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.ProxyServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.preferences.serviceimpl.PreferencesServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import netscape.javascript.JSObject;
import org.apache.commons.lang3.StringUtils;

public class JfxLoginPageStrategyHandler
implements LoginPageStrategy {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(JfxLoginPageStrategyHandler.class);
    private static final AtomicBoolean IS_LOGIN_ING = new AtomicBoolean(Boolean.FALSE);
    private static final int SCENE_WIDTH = 1050;
    private static final int SCENE_HEIGHT = 700;
    private static final String USER_AGENT = "windowsprogram";
    private static final String WINDOW_MEMBER_NAME = "external";
    private static final String SCRIPT = "window";
    private static final String STAGE_TITLE = "ICS Lite";
    private static final CookieManager MANAGER = new CookieManager();
    private static final AsyncEventBus EVENT_BUS = EventBusUtils.INSTANCE.getEventBus();
    private static final SSLSocketFactory SSL_SOCKET_FACTORY = HttpsURLConnection.getDefaultSSLSocketFactory();

    private JfxLoginPageStrategyHandler() {
    }

    public static JfxLoginPageStrategyHandler getInstance() {
        return JfxLoginPageStrategyHandlerHolder.INSTANCE;
    }

    @Override
    public void userAuthentication(AuthoUrlDto authorizationDto) {
        if (!IS_LOGIN_ING.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
            return;
        }
        new JFXPanel();
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> this.start(authorizationDto.getAuthMtokenUrl(), authorizationDto.getAuthUserInfoUrl()));
    }

    public void start(String authenticationUrl, String redirectUrl) {
        URL url;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{authenticationUrl, redirectUrl})) {
            return;
        }
        if (StringUtils.equals((CharSequence)NetworkConnServiceHandler.getInstance().getCertVerifySwitchStatus(), (CharSequence)"0")) {
            HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllCertsConfig.getSslSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(TrustAllCertsConfig.getHostnameVerifier());
        } else {
            HttpsURLConnection.setDefaultSSLSocketFactory(SSL_SOCKET_FACTORY);
        }
        this.setProxy();
        WebView webView = new WebView();
        try {
            url = new URL(authenticationUrl);
        }
        catch (MalformedURLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, CsAuthErrorCode.LOAD_LOGIN_PAGE_ERROR.getDescription(), (Throwable)e);
            OperationLogUtils.INSTANCE.failOperationLog("icslite-authorization-business-service", "AUTHORIZATION", "Authorization failed. because " + CsAuthErrorCode.LOAD_LOGIN_PAGE_ERROR.getDescription());
            return;
        }
        Stage primaryStage = new Stage();
        WebEngine webEngine = webView.getEngine();
        this.addEvent(redirectUrl, primaryStage, webEngine);
        this.setStyle(primaryStage, webView);
        webEngine.setUserAgent(USER_AGENT);
        this.clearThenAddCookie();
        webEngine.setJavaScriptEnabled(true);
        webEngine.load(url.toString());
    }

    private void setProxy() {
        ProxyDto proxyDto = ProxyServiceHandler.getInstance().getProxyProperty(true);
        if (StringUtils.equalsAny((CharSequence)proxyDto.getType(), (CharSequence[])new CharSequence[]{"2", "1"})) {
            this.setProxyWithoutAuthenticator(proxyDto.getAddress(), proxyDto.getPort());
            this.setProxyWithAuthenticator(proxyDto.getUsername(), proxyDto.getPassword());
        } else {
            this.resetProxy();
        }
    }

    private void resetProxy() {
        System.setProperty("proxyHost", "");
        System.setProperty("proxyPort", "");
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "Basic");
        System.setProperty("jdk.https.auth.tunneling.disabledSchemes", "Basic");
    }

    private void setProxyWithoutAuthenticator(String proxyHost, String proxyPort) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{proxyHost, proxyHost})) {
            CodeCCUtils.INSTANCE.warnLog(log, "setProxyWithoutAuthenticator proxyHost or proxyPort is blank.");
            return;
        }
        System.setProperty("proxyHost", proxyHost);
        System.setProperty("proxyPort", proxyPort);
    }

    private void setProxyWithAuthenticator(String proxyUser, String proxyPassword) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{proxyUser, proxyPassword})) {
            CodeCCUtils.INSTANCE.warnLog(log, "setProxyWithAuthenticator User or Password is blank.");
            return;
        }
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        System.setProperty("jdk.https.auth.tunneling.disabledSchemes", "");
        Authenticator.setDefault(new ProxyAuthenticator(proxyUser, proxyPassword));
    }

    private void clearThenAddCookie() {
        MANAGER.getCookieStore().removeAll();
        HashMap<String, List<String>> resPonseHeaderds = new HashMap<String, List<String>>();
        resPonseHeaderds.put("Set-Cookie", this.getCookies(this.getCookieMap()));
        String authUrlNoParams = UrlDataServiceHandler.getInstance().getUniportalUrl() + "/";
        try {
            MANAGER.put(URI.create(authUrlNoParams), resPonseHeaderds);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, CsAuthErrorCode.JAVAFX_SET_COOKIE_EXCEPTION.getDescription(), (Throwable)e);
        }
    }

    private Map<String, String> getCookieMap() {
        Map<String, String> rememberAccountNameCookieMap = UniportalAuthDaoHandler.getInstance().getRememberAccountNameCookieMap();
        String lang = (String)StringUtils.defaultIfBlank((CharSequence)ConfigServiceHandler.getInstance().get("system.lang"), (CharSequence)"");
        rememberAccountNameCookieMap.put("lang", lang);
        return rememberAccountNameCookieMap;
    }

    private List<String> getCookies(Map cookieMap) {
        ArrayList<String> cookies = new ArrayList<String>();
        cookieMap.forEach((cookieKey, cookieValue) -> cookies.add(cookieKey + "=" + cookieValue));
        return cookies;
    }

    private void setStyle(Stage primaryStage, WebView webView) {
        Scene scene = new Scene((Parent)webView, 1050.0, 700.0);
        primaryStage.setScene(scene);
        primaryStage.setTitle(STAGE_TITLE);
        primaryStage.initStyle(StageStyle.DECORATED);
        primaryStage.show();
        primaryStage.centerOnScreen();
        primaryStage.setAlwaysOnTop(true);
        primaryStage.getIcons().add((Object)new Image(JfxLoginPageStrategyHandler.class.getClassLoader().getResourceAsStream("/pic/tray_main.png")));
    }

    private void addEvent(String redirectUrl, Stage primaryStage, WebEngine webEngine) {
        ExternalJavaConnector externalJavaConnector = new ExternalJavaConnector(redirectUrl, primaryStage);
        webEngine.documentProperty().addListener((observable, oldValue, newValue) -> {
            JSObject window = (JSObject)webEngine.executeScript(SCRIPT);
            window.setMember(WINDOW_MEMBER_NAME, externalJavaConnector);
        });
        primaryStage.setOnCloseRequest((EventHandler)new CloseEventHandler());
        this.recordErrorMessageLog(webEngine);
    }

    private void recordErrorMessageLog(WebEngine webEngine) {
        webEngine.setOnError(event -> CodeCCUtils.INSTANCE.errorLog(log, "webEngine.error: {0}", new Object[]{event.toString()}));
        webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            Throwable exception = webEngine.getLoadWorker().getException();
            if (exception != null) {
                CodeCCUtils.INSTANCE.errorLog(log, "webEngine.exception", exception);
            }
            if (StringUtils.equalsAny((CharSequence)newValue.toString(), (CharSequence[])new CharSequence[]{Worker.State.RUNNING.toString(), Worker.State.FAILED.toString()})) {
                CodeCCUtils.INSTANCE.errorLog(log, "webEngine.state: {0}", new Object[]{newValue});
            }
        });
    }

    static {
        CookieHandler.setDefault(MANAGER);
    }

    public static class ExternalJavaConnector {
        private String redirectUrl;
        private Stage globalPrimaryStage;

        public ExternalJavaConnector(String redirectUrl, Stage globalPrimaryStage) {
            this.redirectUrl = redirectUrl;
            this.globalPrimaryStage = globalPrimaryStage;
        }

        public void intoProgram(String javaScriptData) {
            byte[] decode = Base64.getDecoder().decode(javaScriptData);
            Map valueMap = JsonUtils.stringToMap((String)new String(decode, StandardCharsets.UTF_8));
            String mtoken = (String)valueMap.get("mtoken");
            if (StringUtils.isNotBlank((CharSequence)mtoken)) {
                UniportalAuthDaoHandler.getInstance().saveMtokenAndMacAddress(mtoken);
            } else {
                String errorMsg = (String)valueMap.get("errorMsg");
                CodeCCUtils.INSTANCE.errorLog(log, errorMsg);
            }
            this.saveRememberAccountNameConfig();
            if (this.globalPrimaryStage != null) {
                this.globalPrimaryStage.close();
            }
            if (StringUtils.equals((CharSequence)PreferencesServiceHandler.getInstance().getAutoLoginSwitchStatus(), (CharSequence)"0") && PreferencesServiceHandler.getInstance().isAutoLoginRemind()) {
                EVENT_BUS.post((Object)new AutoLoginMessageDto(false, true));
            } else {
                NetworkServiceHandler.getInstance().sendGetRequest(this.redirectUrl, "IDaas2.0 mtokenToTaken");
            }
            IS_LOGIN_ING.compareAndSet(Boolean.TRUE, Boolean.FALSE);
        }

        private void saveRememberAccountNameConfig() {
            List<HttpCookie> cookies = MANAGER.getCookieStore().getCookies();
            HashMap<String, String> rememberAccountNameConfigMap = new HashMap<String, String>();
            for (HttpCookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (StringUtils.equals((CharSequence)cookieName, (CharSequence)"rememberAccountNameMobile")) {
                    String value = cookie.getValue();
                    if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"false")) {
                        UniportalAuthDaoHandler.getInstance().deleteLocalRememberAccountNameFile();
                        return;
                    }
                    rememberAccountNameConfigMap.put(cookieName, value);
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)cookieName, (CharSequence)"loginAccountMobile")) continue;
                rememberAccountNameConfigMap.put(cookieName, cookie.getValue());
            }
            UniportalAuthDaoHandler.getInstance().saveRememberAccountNameConfig(rememberAccountNameConfigMap);
        }
    }

    public static class CloseEventHandler
    implements EventHandler {
        public void handle(Event event) {
            IS_LOGIN_ING.compareAndSet(Boolean.TRUE, Boolean.FALSE);
        }
    }

    private static final class JfxLoginPageStrategyHandlerHolder {
        private static final JfxLoginPageStrategyHandler INSTANCE = new JfxLoginPageStrategyHandler();

        private JfxLoginPageStrategyHandlerHolder() {
        }
    }

    public static class ProxyAuthenticator
    extends Authenticator {
        private String proxyUser;
        private String proxyPassword;

        public ProxyAuthenticator(String proxyUser, String proxyPassword) {
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.proxyUser, this.proxyPassword.toCharArray());
        }
    }
}

