/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.authorization.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.authorization.dto.CertificateRequestDto;
import com.huawei.support.icslite.business.authorization.dto.GenerateCsrDto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class CertificateUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(CertificateUtils.class);
    private static final Provider BOUNCY_PROVIDER = new BouncyCastleProvider();
    private static final String ENCODE_SECURITY_DATA = "hello";

    private CertificateUtils() {
    }

    private static byte[] getBase64PrivateKey(String privateKey) {
        return Base64.getDecoder().decode(privateKey.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s", ""));
    }

    public static Optional<CertificateRequestDto> generateCsr(GenerateCsrDto generateCsrDto) {
        if (generateCsrDto.isEmpty()) {
            return Optional.empty();
        }
        int keyLen = generateCsrDto.getKeyLen();
        CodeCCUtils.INSTANCE.infoLog(log, "Generate CSR has started.");
        String principal = String.format(Locale.ROOT, "C=%s,O=%s,OU=%s,CN=%s", generateCsrDto.getGenerateC(), generateCsrDto.getGenerateO(), generateCsrDto.getGenerateOU(), generateCsrDto.getDeviceId());
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", BOUNCY_PROVIDER);
            keyPairGenerator.initialize(keyLen);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            X500Principal subject = new X500Principal(principal);
            ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSA").setProvider(BOUNCY_PROVIDER).build(privateKey);
            JcaPKCS10CertificationRequestBuilder certificationRequestBuilder = new JcaPKCS10CertificationRequestBuilder(subject, publicKey);
            PKCS10CertificationRequest csr = certificationRequestBuilder.build(signer);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
            CertificateRequestDto certificateRequestDto = new CertificateRequestDto();
            certificateRequestDto.setCsr(CertificateUtils.getPemString("CERTIFICATE REQUEST", csr.getEncoded()));
            certificateRequestDto.setPrivateKey(CertificateUtils.getPemString("PRIVATE KEY", pkcs8EncodedKeySpec.getEncoded()));
            CodeCCUtils.INSTANCE.infoLog(log, "Generate CSR has successful");
            return Optional.of(certificateRequestDto);
        }
        catch (IOException | NoSuchAlgorithmException | OperatorCreationException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "GenerateCsr has exception", e);
            return Optional.empty();
        }
    }

    /*
     * Exception decompiling
     */
    private static String getPemString(String beginLine, byte[] content) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static PublicKey getPublicKeyByCert(String cert) {
        Optional<X509Certificate> x509ByCertOpt = CertificateUtils.getX509ByCert(cert);
        return x509ByCertOpt.map(Certificate::getPublicKey).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<X509Certificate> getX509ByCert(String cert) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8));){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Optional<X509Certificate> optional = Optional.of((X509Certificate)certificateFactory.generateCertificate(inputStream));
            return optional;
        }
        catch (IOException | CertificateException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Get public key has exception", (Throwable)e);
            return Optional.empty();
        }
    }

    public static boolean checkPrivateKey(PublicKey publicKey, PrivateKey privateKey) {
        if (Objects.isNull(publicKey) || Objects.isNull(privateKey)) {
            return false;
        }
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            byte[] data = ENCODE_SECURITY_DATA.getBytes(StandardCharsets.UTF_8);
            signature.update(data);
            byte[] digitalSignature = signature.sign();
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(digitalSignature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Check private key has exception, verify has error", (Throwable)e);
            return false;
        }
    }

    public static PrivateKey getPrivateKeyByStr(String privateKey) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(CertificateUtils.getBase64PrivateKey(privateKey));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "PrivateKey str change to PrivateKey has exception", (Throwable)e);
            return null;
        }
    }
}

