/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.authorization.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class LoginUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(LoginUtils.class);

    private LoginUtils() {
    }

    public static String getMacAddress() {
        StringBuilder macsBuilder = new StringBuilder();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                byte[] macs;
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (LoginUtils.isNormalNetInterface(netInterface) || (macs = netInterface.getHardwareAddress()) == null) continue;
                for (byte mac : macs) {
                    macsBuilder.append(String.format("%02X", mac));
                }
            }
        }
        catch (SocketException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "getMacAddress SocketException", (Throwable)e);
            macsBuilder.append("unknown");
        }
        String macsStr = macsBuilder.toString();
        return macsStr.length() > 128 ? macsStr.substring(0, 120) : macsStr;
    }

    private static boolean isNormalNetInterface(NetworkInterface netInterface) throws SocketException {
        return BooleanUtils.or((Boolean[])new Boolean[]{netInterface.isLoopback(), netInterface.isVirtual(), netInterface.isPointToPoint(), !netInterface.isUp()});
    }

    public static String getIpAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "getIpAddress UnknownHostException", (Throwable)e);
            return "unknown";
        }
    }

    public static <T> T getTokenDto(String tokenResponseJson, Class<T> tokenDto) {
        Object oauthTokenDto = null;
        try {
            oauthTokenDto = JsonUtils.fromString((String)tokenResponseJson, tokenDto);
        }
        catch (JsonUtils.JsonException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "getOauthTokenDto parse json error", (Throwable)e);
        }
        return (T)oauthTokenDto;
    }

    public static boolean isValidPeriodOk(long timestamp, long cycleTime) {
        long currentTime = System.currentTimeMillis() - timestamp;
        return currentTime < cycleTime;
    }

    public static Properties getPropertiesByFile(String filePath) {
        Properties properties = new Properties();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.errorLog(log, "getPropertiesByFile filePath is blank.");
            return properties;
        }
        File file = FileUtils.getFile((String[])new String[]{filePath});
        String name = file.getName();
        if (!file.exists()) {
            CodeCCUtils.INSTANCE.errorLog(log, name + " not exists.");
            return properties;
        }
        properties = PropertiesUtils.getPropertiesByFile((File)file);
        if (properties == null) {
            CodeCCUtils.INSTANCE.errorLog(log, name + " load failed.");
        }
        return properties;
    }
}

