/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.io.File;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class UrlDataDaoHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UrlDataDaoHandler.class);
    private final Object lock = new Object();
    private volatile JSONObject urlDataCache;

    private UrlDataDaoHandler() {
    }

    public static UrlDataDaoHandler getInstance() {
        return UrlDataDaoHandlerHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCacheIfNeeded() {
        if (MapUtils.isNotEmpty((Map)this.urlDataCache)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (MapUtils.isNotEmpty((Map)this.urlDataCache)) {
                return;
            }
            String localJson = IcsFileUtils.readFileContent((String)this.getFilePath(), null);
            try {
                this.urlDataCache = JSON.parseObject((String)localJson);
            }
            catch (JSONException e) {
                this.urlDataCache = new JSONObject();
                CodeCCUtils.INSTANCE.errorLog(LOG, "can not parse local urlData file", (Throwable)e);
            }
        }
    }

    private String getFilePath() {
        return IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + "urlData.json";
    }

    public synchronized boolean update(String jsonString) {
        JSONObject newData = null;
        try {
            newData = JSON.parseObject((String)jsonString);
        }
        catch (JSONException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "can not parse incoming url data: {0}", new Object[]{jsonString});
        }
        if (newData == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "fail to update urldata file");
            return false;
        }
        this.urlDataCache = newData;
        IcsFileUtils.writeFileContent((String)this.getFilePath(), (String)jsonString);
        CodeCCUtils.INSTANCE.infoLog(LOG, "update urldata file successfully");
        return true;
    }

    public String getValueByKey(String key) {
        this.initCacheIfNeeded();
        return this.urlDataCache.getString(key);
    }

    public String getDomainNginxByScene(String scene) {
        this.initCacheIfNeeded();
        try {
            String domainJson = this.urlDataCache.getString("Domain");
            JSONObject domainMap = JSON.parseObject((String)domainJson);
            if (MapUtils.isNotEmpty((Map)domainMap)) {
                return domainMap.getString(scene);
            }
        }
        catch (JSONException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Can not get server domain by {0} from urldata.json", new Object[]{scene});
        }
        return "";
    }

    private static class UrlDataDaoHandlerHolder {
        private static final UrlDataDaoHandler INSTANCE = new UrlDataDaoHandler();

        private UrlDataDaoHandlerHolder() {
        }
    }
}

