/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.interceptors;

import com.huawei.support.icslite.business.authorization.serviceimpl.CertificateBusinessHandler;
import com.huawei.support.icslite.business.common.interceptors.CookieInterceptor;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public class CertificateInterceptor
extends CookieInterceptor {
    private static final List<String> HOUP_REQEUST_URL;
    private static final List<String> HOUP_URL_KEYS;

    @Override
    public boolean canApply(Request request) {
        String requestPath = request.url().encodedPath();
        if (StringUtils.startsWith((CharSequence)requestPath, (CharSequence)UrlDataServiceHandler.getInstance().getUrlFromKey("icslite.houp.issue.certificate.url"))) {
            return false;
        }
        return StringUtils.startsWith((CharSequence)requestPath, (CharSequence)"/clientservice/");
    }

    @Override
    public Request handler(Request request) {
        if (HOUP_REQEUST_URL.stream().anyMatch(houpUrl -> StringUtils.startsWith((CharSequence)request.url().toString(), (CharSequence)houpUrl))) {
            CertificateBusinessHandler.getInstance().updateCertificate();
            String ssoToken = this.getSsoToken();
            String ssoCookieString = this.getSsoCookieString(ssoToken);
            if (StringUtils.isBlank((CharSequence)ssoCookieString)) {
                return request;
            }
            return request.newBuilder().header("Cookie", ssoCookieString).build();
        }
        return request;
    }

    static {
        HOUP_URL_KEYS = Collections.unmodifiableList(Arrays.asList("icslite.houp.softwarelist.productline.url", "icslite.houp.softwarelist.product.url", "icslite.houp.softwarelist.version.url", "icslite.houp.softwarelist.software.url", "icslite.houp.softwarelist.productsuggest.url", "icslite.houp.softwarelist.software.apply.url", "icslite.houp.apply.file.url", "icslite.houp.apply.list.url"));
        HOUP_REQEUST_URL = HOUP_URL_KEYS.stream().map(key -> UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", (String)key)).collect(Collectors.toList());
    }
}

