/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.interceptors;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.authorization.dto.CsTokenResponseDto;
import com.huawei.support.icslite.business.authorization.service.UniportalAuthorizationBusiness;
import com.huawei.support.icslite.business.common.interceptors.RequestInterceptorService;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class CookieInterceptor
implements RequestInterceptorService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(CookieInterceptor.class);
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    protected String getSsoToken() {
        UniportalAuthorizationBusiness uniportalAuthService = (UniportalAuthorizationBusiness)SpringContextUtil.getBean((String)"uniportalAuthorizationBusiness");
        Optional<CsTokenResponseDto.TokenDto> ssoToken = uniportalAuthService.getSsoToken();
        String result = "";
        if (!ssoToken.isPresent()) {
            return "";
        }
        try {
            result = JsonUtils.objectToString((Object)ssoToken.get());
        }
        catch (JsonUtils.JsonException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "TokenDto parse jsonStr error", (Throwable)e);
        }
        return result;
    }

    protected String getSsoCookieString(String responseJson) {
        if (StringUtils.isBlank((CharSequence)responseJson)) {
            return "";
        }
        Map<String, Object> ssoCookies = this.getResponseDataMap(responseJson);
        return ssoCookies.entrySet().stream().map(kv -> (String)kv.getKey() + "=" + kv.getValue()).collect(Collectors.joining(";"));
    }

    private Map<String, Object> getResponseDataMap(String data) {
        return (Map)JSONObject.parseObject((String)data, MAP_TYPE_REFERENCE, (Feature[])new Feature[0]);
    }
}

