/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.interceptors;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.authorization.service.UniportalAuthorizationBusiness;
import com.huawei.support.icslite.business.common.dto.UrlDataDto;
import com.huawei.support.icslite.business.common.interceptors.RequestInterceptorService;
import com.huawei.support.icslite.business.common.service.UrlDataService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public class IcsLiteWebInterceptor
implements RequestInterceptorService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(IcsLiteWebInterceptor.class);
    private static final List<String> ICSLITE_SERVICE_AUTH_URL_KEY_SET = Collections.unmodifiableList(Arrays.asList("DocInfosData", "ProdVersData", "OfflineDownloadCountData", "OfflineDownloadListData", "UserCollectLog", "UpgradeRoleMatch"));
    private static final List<String> ICSLITE_SERVICE_AUTH_URLS = Collections.unmodifiableList(IcsLiteWebInterceptor.getUrlsByKeys(ICSLITE_SERVICE_AUTH_URL_KEY_SET));

    private static String getUrl(String key) {
        UrlDataService urlDataService = (UrlDataService)SpringContextUtil.getBean((String)"urlDataService");
        UrlDataDto urlDataDto = urlDataService.getUrlOrDefault(null, key, false, "");
        return urlDataDto.getMainUrl();
    }

    public static List<String> getUrlsByKeys(List<String> keys) {
        return keys.stream().map(IcsLiteWebInterceptor::getUrl).collect(Collectors.toList());
    }

    @Override
    public boolean canApply(Request request) {
        return StringUtils.startsWith((CharSequence)request.url().encodedPath(), (CharSequence)"/icsliteweb/");
    }

    @Override
    public Request handler(Request request) {
        UniportalAuthorizationBusiness uniportalAuthorizationBusiness = (UniportalAuthorizationBusiness)SpringContextUtil.getBean((String)"uniportalAuthorizationBusiness");
        if (ICSLITE_SERVICE_AUTH_URLS.stream().anyMatch(authurl -> StringUtils.startsWith((CharSequence)request.url().toString(), (CharSequence)authurl))) {
            return uniportalAuthorizationBusiness.getSsoUuid().map(ssoUuid -> request.newBuilder().header("ssouuid", ssoUuid).build()).orElse(request);
        }
        return request;
    }
}

