/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.interceptors;

import com.huawei.support.icslite.business.common.interceptors.CertificateInterceptor;
import com.huawei.support.icslite.business.common.interceptors.IcsLiteWebInterceptor;
import com.huawei.support.icslite.business.common.interceptors.RequestInterceptorService;
import com.huawei.support.icslite.business.common.interceptors.SsoAuthInterceptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import okhttp3.Request;

public class RequestInterceptorChainHandler {
    private final List<RequestInterceptorService> handlers = Collections.unmodifiableList(Arrays.asList(new IcsLiteWebInterceptor(), new CertificateInterceptor(), new SsoAuthInterceptor()));

    private RequestInterceptorChainHandler() {
    }

    public static RequestInterceptorChainHandler getInstance() {
        return RequestInterceptorChainHandlerHolder.INSTANCE;
    }

    public Request handler(Request request) {
        for (RequestInterceptorService interceptorHandler : this.handlers) {
            if (!interceptorHandler.canApply(request)) continue;
            return interceptorHandler.handler(request);
        }
        return request;
    }

    public static class RequestInterceptorChainHandlerHolder {
        private static final RequestInterceptorChainHandler INSTANCE = new RequestInterceptorChainHandler();
    }
}

