/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.interceptors;

import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.common.interceptors.CookieInterceptor;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public class SsoAuthInterceptor
extends CookieInterceptor {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(SsoAuthInterceptor.class);

    @Override
    public boolean canApply(Request request) {
        return StringUtils.endsWith((CharSequence)request.url().host(), (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)ConfigServiceHandler.getInstance().get("server.domain.suffix"), (CharSequence)".huawei.com")).substring(1));
    }

    @Override
    public Request handler(Request request) {
        String ssoToken = this.getSsoToken();
        String ssoCookieString = this.getSsoCookieString(ssoToken);
        if (StringUtils.isBlank((CharSequence)ssoCookieString)) {
            return request;
        }
        return request.newBuilder().header("Cookie", ssoCookieString).build();
    }
}

