/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.interceptors;

import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class UserAgentInterceptor
implements Interceptor {
    private static final String SEMICOLON_SEPARATOR = ";";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request requestWithUserAgent = originalRequest.newBuilder().header("User-Agent", this.buildUserAgent()).build();
        return chain.proceed(requestWithUserAgent);
    }

    private String buildUserAgent() {
        String softVersion = IcsCommonServiceHandler.getInstance().getAppVersion();
        if (StringUtils.isBlank((CharSequence)softVersion)) {
            softVersion = "Unknown";
        }
        Object[] userAgents = new String[]{"ICS Lite / " + softVersion, System.getProperty("os.name"), ConfigServiceHandler.getInstance().get("system.lang"), this.getAppScene(), "icslite_verify_version"};
        return StringUtils.joinWith((String)SEMICOLON_SEPARATOR, (Object[])userAgents);
    }

    private String getAppScene() {
        String scene = ConfigServiceHandler.getInstance().get("system.ics.scene");
        return StringUtils.equalsIgnoreCase((CharSequence)scene, (CharSequence)"support") ? "carrier" : "enterprise";
    }
}

