/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.schedule;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;

public class UrlDataSchedule {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(UrlDataSchedule.class);

    private UrlDataSchedule() {
    }

    public static UrlDataSchedule getInstance() {
        return UrlDataScheduleHolder.INSTANCE;
    }

    public boolean scheduleUpdataUrlTask() {
        try {
            HttpClientDto httpClient = NetworkServiceHandler.getInstance().getHttpClientForHuawei();
            return UrlDataServiceHandler.getInstance().refreshLocalData(httpClient);
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "failed to get the httpClient.", (Throwable)e);
        }
        catch (CustomSslException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "scheduleCrlUpdate has CustomSslException", (Throwable)e);
        }
        return false;
    }

    private static class UrlDataScheduleHolder {
        private static final UrlDataSchedule INSTANCE = new UrlDataSchedule();

        private UrlDataScheduleHolder() {
        }
    }
}

