/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.serviceimpl;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.ics.common.adapter.encryption.service.impl.KmcDataSecurityHandler;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.exception.KmcPropertiesException;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icslite.business.common.constant.EncryptionPathConstants;
import com.huawei.support.icslite.business.common.service.KmcPathInitConfigService;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class KmcPathInitConfigHandler
implements KmcPathInitConfigService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(KmcPathInitConfigHandler.class);
    private static final Object SYNC_OBJ = new Object();
    private boolean isInitFinish = false;
    private Properties properties;

    private KmcPathInitConfigHandler() {
        this.init();
    }

    public static KmcPathInitConfigHandler getInstance() {
        return KmcPathInitConfigHandlerHolder.INSTANCE;
    }

    private void init() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        String kmcDllLibAbsoultPath = IcsCommonServiceHandler.getInstance().getWebAppPath() + EncryptionPathConstants.WEB_INF_KMC_DLL_LIB_RELAPATH;
        propertiesMap.put("kmcDllLibAbsolutePath", kmcDllLibAbsoultPath);
        String programDataPath = IcsCommonServiceHandler.getInstance().getSysProgramDataPath() + ConfigServiceHandler.getInstance().get("system.lang");
        String primaryKeyStoreFileValue = programDataPath + EncryptionPathConstants.PRIMARY_KEY_RELPATH;
        propertiesMap.put("primary_key_store_file", primaryKeyStoreFileValue);
        String standbyFileStoreFileValue = programDataPath + EncryptionPathConstants.STANDBY_KEY_RELPATH;
        propertiesMap.put("standby_key_store_file", standbyFileStoreFileValue);
        String backupPath = programDataPath + EncryptionPathConstants.FILE2_PATH;
        propertiesMap.put("backupPath", backupPath);
        this.setKmcPathProperties(propertiesMap);
    }

    private void setKmcPathProperties(Map<String, String> propertiesMap) {
        this.properties = PropertiesUtils.getPropertiesByResourceName((String)"application-kmc.properties");
        for (Map.Entry<String, String> propertyEntry : propertiesMap.entrySet()) {
            this.properties.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    @Override
    public Properties getKmcProperties() {
        return this.properties;
    }

    private KmcDataSecurityHandler kmcInit() throws KmcPropertiesException {
        AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();
        Properties kmcProperties = this.getKmcProperties();
        KmcDataSecurityHandler kmcDataSecurityHandler = KmcDataSecurityHandler.getInstanceByinit((AsyncEventBus)eventBus, (Properties)kmcProperties);
        this.isInitFinish = true;
        CodeCCUtils.INSTANCE.infoLog(log, "kmc init is finish");
        return kmcDataSecurityHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkKmcInitStatus() throws KmcPropertiesException {
        Object object = SYNC_OBJ;
        synchronized (object) {
            if (!this.isInitFinish) {
                this.kmcInit();
            }
        }
    }

    private static class KmcPathInitConfigHandlerHolder {
        private static final KmcPathInitConfigHandler INSTANCE = new KmcPathInitConfigHandler();

        private KmcPathInitConfigHandlerHolder() {
        }
    }
}

