/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.serviceimpl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icslite.business.common.service.NetworkConnService;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import org.apache.commons.lang3.StringUtils;

public class NetworkConnServiceHandler
implements NetworkConnService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(NetworkConnServiceHandler.class);

    private NetworkConnServiceHandler() {
    }

    public static NetworkConnServiceHandler getInstance() {
        return NetworkConnServiceHandlerHolder.INSTANCE;
    }

    @Override
    public boolean updateNetworkSwitchStatus(String status) {
        return this.updateSwitchStatus(status, "networkSwitch", "system.network.status");
    }

    @Override
    public boolean updateCertVerifySwitchStatus(String status) {
        boolean isSuccess = this.updateSwitchStatus(status, "certificateVerifySwitch", "system.cert.verify.switch.status");
        if (isSuccess) {
            NetworkServiceHandler.getInstance().initHttpClient();
            NetworkServiceHandler.getInstance().initHoupHttpClient();
        }
        return isSuccess;
    }

    private boolean updateSwitchStatus(String status, String operateDes, String configKey) {
        if (StringUtils.isBlank((CharSequence)status)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "NetworkConfig status updating, but is null.");
            return false;
        }
        boolean isUpdated = ConfigServiceHandler.getInstance().set(configKey, status);
        if (isUpdated) {
            this.recodeSuccessOperationLog(status, operateDes);
        } else {
            this.recodeFailOperationLog(status, operateDes);
        }
        return isUpdated;
    }

    private void recodeSuccessOperationLog(String status, String operateDes) {
        if (StringUtils.equals((CharSequence)"1", (CharSequence)status)) {
            OperationLogUtils.INSTANCE.successOperationLog("NetworkingService", "OPENED", "The {0} is opened.", new Object[]{operateDes});
            return;
        }
        OperationLogUtils.INSTANCE.successOperationLog("NetworkingService", "CLOSED", "The {0} is closed.", new Object[]{operateDes});
    }

    private void recodeFailOperationLog(String status, String operateDes) {
        if (StringUtils.equals((CharSequence)"1", (CharSequence)status)) {
            OperationLogUtils.INSTANCE.failOperationLog("NetworkingService", "OPENED", "The {0} fail to open.", new Object[]{operateDes});
            return;
        }
        OperationLogUtils.INSTANCE.failOperationLog("NetworkingService", "CLOSED", "The {0} fail to close.", new Object[]{operateDes});
    }

    @Override
    public String getNetworkSwitchStatus() {
        return this.getSwitchStatus("system.network.status", "0", "NetworkStatus");
    }

    @Override
    public String getCertVerifySwitchStatus() {
        return this.getSwitchStatus("system.cert.verify.switch.status", "1", "CertVerifySwitchStatus");
    }

    @Override
    public boolean isClosed() {
        return StringUtils.equals((CharSequence)this.getNetworkSwitchStatus(), (CharSequence)"0");
    }

    @Override
    public boolean checkSslCert(String webDomainType) {
        String checkUrl = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)webDomainType, (CharSequence)"support")) {
            checkUrl = UrlDataServiceHandler.getInstance().getDomain();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)webDomainType, (CharSequence)"uniportal")) {
            checkUrl = UrlDataServiceHandler.getInstance().getUniportalUrl();
        }
        if (StringUtils.isBlank((CharSequence)checkUrl)) {
            return false;
        }
        try {
            HttpClientDto httpClientForHuawei = NetworkServiceHandler.getInstance().getHttpClientForHuawei().newBuilder().url(checkUrl).build();
            String requestResult = NetWorkUtil.get((HttpClientDto)httpClientForHuawei);
            return StringUtils.isNotBlank((CharSequence)requestResult);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "checksslcert response is failed.", (Throwable)e);
            return false;
        }
    }

    private String getSwitchStatus(String configKey, String defaultValue, String switchDes) {
        String switchStatus = ConfigServiceHandler.getInstance().getOrSetDefault(configKey, defaultValue);
        if (StringUtils.equalsAny((CharSequence)switchStatus, (CharSequence[])new CharSequence[]{"1", "0"})) {
            return switchStatus;
        }
        CodeCCUtils.INSTANCE.warnLog(LOGGER, "{0} is wrong status:{1}.", new Object[]{switchDes, switchStatus});
        return defaultValue;
    }

    private static class NetworkConnServiceHandlerHolder {
        private static final NetworkConnServiceHandler INSTANCE = new NetworkConnServiceHandler();

        private NetworkConnServiceHandlerHolder() {
        }
    }
}

