/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.serviceimpl;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.TrustAllCertsConfig;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.HoupDownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.authorization.dto.CertificateDto;
import com.huawei.support.icslite.business.authorization.dto.CertificateStatus;
import com.huawei.support.icslite.business.authorization.serviceimpl.CertificateBusinessHandler;
import com.huawei.support.icslite.business.common.dto.ProxyDto;
import com.huawei.support.icslite.business.common.dto.UrlDataDto;
import com.huawei.support.icslite.business.common.exception.HoupCertException;
import com.huawei.support.icslite.business.common.interceptors.OauthInterceptor;
import com.huawei.support.icslite.business.common.interceptors.UserAgentInterceptor;
import com.huawei.support.icslite.business.common.service.NetworkConnService;
import com.huawei.support.icslite.business.common.service.NetworkService;
import com.huawei.support.icslite.business.common.service.ProxyService;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkConnServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.common.util.HoupCertUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.owasp.esapi.errors.EncodingException;

public class NetworkServiceHandler
implements NetworkService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(NetworkServiceHandler.class);
    private static final Pattern ALLOW_PEER_HOST_COM = Pattern.compile("[\\w.-]+\\.huawei\\.com");
    private static final Pattern ALLOW_PEER_HOST_CN = Pattern.compile("[\\w.-]+\\.huawei\\.cn");
    private static final Pattern ALLOW_PEER_HOST_RU = Pattern.compile("[\\w.-]+\\.huawei\\.ru");
    private static final String NETWORK_DATA_JSON = "dataJson";
    private static final String RESULT_ERROR_CODE = "-1";
    private static final int PORT_MAX_NUM = 65535;
    private static final String NETWORK_CODE = "code";
    private static final int READ_TIMEOUT_SECOND = 60;
    private static final int CONNECT_TIMEOUT_SECOND = 30;
    private static final String PROXY_READ_TIMEOUT_SECOND = "5";
    private static final String PROXY_CONNECT_TIMEOUT_SECOND = "5";
    private static final String TLS_VERSION = "TLSv1.2";
    private static final int SCRECT_KEY_LENGTH = 64;
    private volatile OkHttpClient houpOkHttpClient;
    private volatile OkHttpClient okHttpClient;
    private volatile OkHttpClient hwOkHttpClient;

    private NetworkServiceHandler() {
        this.init();
    }

    public static NetworkServiceHandler getInstance() {
        return NetworkBusinessHandlerHolder.INSTANCE;
    }

    private static HostnameVerifier getHostnameVerifier() {
        return (hostname, session) -> {
            String peerHost = session.getPeerHost();
            return NetworkServiceHandler.checkHostName(hostname, peerHost);
        };
    }

    private static boolean checkHostName(String hostname, String peerHost) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)hostname, (CharSequence)peerHost)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "peerHost and hostname not equal");
            return false;
        }
        if (ALLOW_PEER_HOST_COM.matcher(hostname).matches() && ALLOW_PEER_HOST_COM.matcher(peerHost).matches()) {
            return true;
        }
        if (ALLOW_PEER_HOST_CN.matcher(hostname).matches() && ALLOW_PEER_HOST_CN.matcher(peerHost).matches()) {
            return true;
        }
        if (ALLOW_PEER_HOST_RU.matcher(hostname).matches() && ALLOW_PEER_HOST_RU.matcher(peerHost).matches()) {
            return true;
        }
        CodeCCUtils.INSTANCE.warnLog(LOGGER, "peerHost and hostname mismatch the allowed patterns");
        return false;
    }

    private void init() {
        this.okHttpClient = new OkHttpClient();
        this.hwOkHttpClient = new OkHttpClient();
        if (StringUtils.equals((CharSequence)NetworkConnServiceHandler.getInstance().getCertVerifySwitchStatus(), (CharSequence)"0")) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "trust all cert.");
            this.okHttpClient = this.getTrustClientBuilder(this.okHttpClient).build();
            this.hwOkHttpClient = this.getTrustClientBuilder(this.hwOkHttpClient).build();
        } else {
            this.okHttpClient = this.getClientBuilder(this.okHttpClient).build();
            this.hwOkHttpClient = this.getClientBuilder(this.hwOkHttpClient).hostnameVerifier(NetworkServiceHandler.getHostnameVerifier()).build();
        }
        this.initHoupHttpClient();
    }

    @Override
    public void initHoupHttpClient() {
        this.houpOkHttpClient = this.getHoupClientBuilder(new OkHttpClient()).build();
    }

    private OkHttpClient.Builder getClientBuilder(OkHttpClient client) {
        OkHttpClient.Builder builder = this.getDefaultClientBuilder(client, 60, 30);
        ProxyService proxyService = (ProxyService)SpringContextUtil.getBean((String)"proxyService");
        ProxyDto proxyProperty = proxyService.getProxyProperty(true);
        return this.setProxy(builder, proxyProperty);
    }

    private OkHttpClient.Builder getTrustClientBuilder(OkHttpClient client) {
        OkHttpClient.Builder builder = this.getClientBuilder(client);
        builder.sslSocketFactory(TrustAllCertsConfig.getSslSocketFactory(), TrustAllCertsConfig.getX509TrustManager());
        builder.hostnameVerifier(TrustAllCertsConfig.getHostnameVerifier());
        return builder;
    }

    private OkHttpClient.Builder getDefaultClientBuilder(OkHttpClient client, int readTimeout, int connectTimeout) {
        return client.newBuilder().readTimeout((long)readTimeout, TimeUnit.SECONDS).connectTimeout((long)connectTimeout, TimeUnit.SECONDS).addInterceptor((Interceptor)new UserAgentInterceptor()).addInterceptor((Interceptor)OauthInterceptor.getInstance());
    }

    private OkHttpClient.Builder getProxyClientBuilder(OkHttpClient client) {
        OkHttpClient.Builder proxyOkHttpClient = this.getDefaultClientBuilder(client, this.getProxyTimeConfig("network.proxy.test.read.timeout", "5"), this.getProxyTimeConfig("network.proxy.test.connect.timeout", "5"));
        if (StringUtils.equals((CharSequence)NetworkConnServiceHandler.getInstance().getCertVerifySwitchStatus(), (CharSequence)"0")) {
            proxyOkHttpClient.sslSocketFactory(TrustAllCertsConfig.getSslSocketFactory(), TrustAllCertsConfig.getX509TrustManager());
            proxyOkHttpClient.hostnameVerifier(TrustAllCertsConfig.getHostnameVerifier());
        }
        return proxyOkHttpClient;
    }

    private int getProxyTimeConfig(String configKey, String defaultValue) {
        return Integer.parseInt(ConfigServiceHandler.getInstance().getOrSetDefault(configKey, defaultValue));
    }

    @Override
    public void initHttpClient() {
        this.init();
    }

    @Override
    public HttpClientDto getHttpClientForHoup(String certificateStatus) throws DownloadException {
        this.checkNetworkSwitch();
        if (StringUtils.isNotBlank((CharSequence)certificateStatus) && !StringUtils.equalsAny((CharSequence)certificateStatus, (CharSequence[])new CharSequence[]{CertificateStatus.ISSUED_CERTIFICATE.getCode(), CertificateStatus.UPDATING_CERTIFICATE.getCode()})) {
            throw new HoupDownloadException(certificateStatus);
        }
        return new HttpClientDto.Builder().httpClient(this.updateProxy(this.houpOkHttpClient)).build();
    }

    @Override
    public HttpClientDto getHttpClientForHuawei() throws NetWorkSwitchException {
        this.checkNetworkSwitch();
        return new HttpClientDto.Builder().httpClient(this.updateProxy(this.hwOkHttpClient)).build();
    }

    @Override
    public HttpClientDto getHttpClientDefault() throws NetWorkSwitchException {
        this.checkNetworkSwitch();
        return new HttpClientDto.Builder().httpClient(this.updateProxy(this.okHttpClient)).build();
    }

    @Override
    public HttpClientDto getHttpClientForProxyTest() throws NetWorkSwitchException {
        this.checkNetworkSwitch();
        OkHttpClient proxyTestOkHttpClient = new OkHttpClient();
        proxyTestOkHttpClient = this.getProxyClientBuilder(proxyTestOkHttpClient).hostnameVerifier(NetworkServiceHandler.getHostnameVerifier()).build();
        return new HttpClientDto.Builder().httpClient(proxyTestOkHttpClient).build();
    }

    @Override
    public void updateHttpClientForProxy() {
        this.okHttpClient = this.updateProxy(this.okHttpClient);
        this.hwOkHttpClient = this.updateProxy(this.hwOkHttpClient);
        this.houpOkHttpClient = this.updateProxy(this.houpOkHttpClient);
    }

    private OkHttpClient updateProxy(OkHttpClient client) {
        ProxyService proxyService = (ProxyService)SpringContextUtil.getBean((String)"proxyService");
        ProxyDto proxyProperty = proxyService.getProxyProperty(true);
        return this.setProxy(client.newBuilder(), proxyProperty).build();
    }

    private OkHttpClient.Builder setProxy(OkHttpClient.Builder builder, ProxyDto proxyProperty) {
        if (proxyProperty == null || StringUtils.equals((CharSequence)proxyProperty.getType(), (CharSequence)"0") || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{proxyProperty.getAddress(), proxyProperty.getPort()})) {
            return builder.proxy(Proxy.NO_PROXY);
        }
        try {
            int port = this.checkPort(proxyProperty.getPort());
            CodeCCUtils.INSTANCE.infoLog(LOGGER, String.format(Locale.ENGLISH, "use proxy proxyAddress: %s", proxyProperty.getAddress()));
            return builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyProperty.getAddress(), port))).proxyAuthenticator((route, response) -> this.setProxyAuthenticator(response, proxyProperty.getUsername(), proxyProperty.getPassword()));
        }
        catch (NumberFormatException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "port transform error,please input 0-65535", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "port must in 0-65535", (Throwable)e);
        }
        return builder.proxy(Proxy.NO_PROXY);
    }

    private OkHttpClient.Builder getHoupClientBuilder(OkHttpClient client) {
        OkHttpClient.Builder builder = this.getClientBuilder(client);
        try {
            SSLSocketFactory sslSocketFactory = this.getSslSocketFactory();
            if (StringUtils.equals((CharSequence)NetworkConnServiceHandler.getInstance().getCertVerifySwitchStatus(), (CharSequence)"0")) {
                builder.hostnameVerifier(TrustAllCertsConfig.getHostnameVerifier());
                builder.sslSocketFactory(sslSocketFactory, TrustAllCertsConfig.getX509TrustManager());
            } else {
                builder.sslSocketFactory(sslSocketFactory, this.getSystemDefaultX509TrustManager());
            }
        }
        catch (HoupCertException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to getHoupClientBuilder.", (Throwable)e);
        }
        return builder;
    }

    private X509TrustManager getSystemDefaultX509TrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (ArrayUtils.isEmpty((Object[])trustManagers)) {
                throw new HoupCertException("Can not find any trustManagers.");
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Init trustManager failed with exception.", (Throwable)e);
            throw new HoupCertException("Init trustManager failed.");
        }
    }

    private SSLContext getSslContextByCertInfo() {
        try {
            CertificateDto certificateDto = CertificateBusinessHandler.getInstance().getCertificateDto();
            HoupCertUtils.verifyCertificatesExist(certificateDto);
            SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String secretKey = HoupCertUtils.getRandomString(64);
            keyManagerFactory.init(HoupCertUtils.createKeyStore(certificateDto.getPrivateKey(), certificateDto.getCertificate(), secretKey), secretKey.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to getSslContextByCertInfo with exception.", (Throwable)e);
            return null;
        }
    }

    private SSLSocketFactory getSslSocketFactory() {
        SSLContext sslContext = this.getSslContextByCertInfo();
        if (Objects.isNull(sslContext)) {
            throw new HoupCertException("Failed to get sslContext.");
        }
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        if (Objects.isNull(sslSocketFactory)) {
            throw new HoupCertException("Failed to get sslSocketFactory.");
        }
        return sslSocketFactory;
    }

    private int checkPort(String port) {
        int checkPort = Integer.parseInt(port);
        if (checkPort < 1 || checkPort > 65535) {
            throw new IllegalArgumentException(port);
        }
        return checkPort;
    }

    private Request setProxyAuthenticator(Response response, String username, String password) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{username, password})) {
            return response.request();
        }
        String credential = Credentials.basic((String)username, (String)password);
        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
    }

    private void checkNetworkSwitch() throws NetWorkSwitchException {
        NetworkConnService networkConnService = (NetworkConnService)SpringContextUtil.getBean((String)"networkConnService");
        if (networkConnService.isClosed()) {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "Http method invoke, but network switch is not opened.");
            throw new NetWorkSwitchException("Network status is closed.");
        }
    }

    @Override
    public String getMainUrl(String key) {
        HttpClientDto builder = null;
        try {
            builder = this.getHttpClientForHuawei();
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "The network connection switch is not turned on.", (Throwable)e);
        }
        if (builder == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The builder get value is failed.");
            return "";
        }
        UrlDataDto urlDataDto = UrlDataServiceHandler.getInstance().getUrl(builder, key, false);
        if (urlDataDto == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The key:{0}--get value is failed.", new Object[]{key});
            return "";
        }
        return urlDataDto.getMainUrl();
    }

    @Override
    public Map<String, String> getNetworkData(String url, String originBusiness) {
        Object codeObject;
        String json = "";
        try {
            HttpClientDto builder = this.getHttpClientForHuawei();
            builder = builder.newBuilder().url(url).build();
            json = NetWorkUtil.get((HttpClientDto)builder);
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "{0},The network connection switch is not turned on.", (Throwable)e, new Object[]{originBusiness});
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "{0},getNetWorkData is DownloadException.", (Throwable)e, new Object[]{originBusiness});
        }
        Map jsonInfoMap = JsonUtils.stringToMap((String)json);
        String resultCode = MapUtils.isEmpty((Map)jsonInfoMap) ? RESULT_ERROR_CODE : ((codeObject = jsonInfoMap.get(NETWORK_CODE)) == null ? RESULT_ERROR_CODE : codeObject.toString());
        HashMap<String, String> networkMap = new HashMap<String, String>();
        networkMap.put(NETWORK_CODE, resultCode);
        networkMap.put(NETWORK_DATA_JSON, json);
        return networkMap;
    }

    @Override
    public Map<String, String> getNetworkData(String url, List<String> params, String originBusiness) {
        ArrayList encodeParams = new ArrayList();
        Optional.ofNullable(params).orElseGet(ArrayList::new).forEach(param -> {
            try {
                encodeParams.add(HWEncoder.encodeForURL((String)param));
            }
            catch (EncodingException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "{0} is EncodingException", new Object[]{param, e});
            }
        });
        return this.getNetworkData(String.format(Locale.ENGLISH, url, encodeParams.toArray()), originBusiness);
    }

    public String sendGetRequest(String url, String visitionDescript) {
        Request request = new Request.Builder().url(url).get().build();
        OkHttpClient client = new OkHttpClient.Builder().build();
        try {
            Response response = client.newCall(request).execute();
            if (response != null) {
                return response.body().string();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "{0} sendGetRequest is IOException", (Throwable)e, new Object[]{visitionDescript});
        }
        return "";
    }

    private static class NetworkBusinessHandlerHolder {
        private static final NetworkServiceHandler INSTANCE = new NetworkServiceHandler();

        private NetworkBusinessHandlerHolder() {
        }
    }
}

