/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.serviceimpl;

import com.huawei.support.ics.common.adapter.encryption.service.factory.DataSecurityHandlerFactory;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icscbb.util.proxy.IeProxyConfig;
import com.huawei.support.icscbb.util.proxy.IeProxyUtils;
import com.huawei.support.icslite.business.common.dto.ProxyDto;
import com.huawei.support.icslite.business.common.exception.ProxyException;
import com.huawei.support.icslite.business.common.service.ProxyService;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ProxyServiceHandler
implements ProxyService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ProxyServiceHandler.class);
    private static final String NETWORK_CONFIG = "networkConfig.properties";
    private static final String PROXY_TYPE = "type";
    private static final String PROXY_ADDRESS = "address";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_USERNAME = "username";
    private static final String PROXY_PORT_NUM = "80";
    private static final String DUMMY_SECRET = "******";
    private static final Pattern PATTERN = Pattern.compile("^([0-9]{1,})$");
    private static final int ENCRYPTION_DOMAIN_KEY_ID = 3;
    private static final int MAX_PORT_NUM = 65535;
    private static final String NETWORK_FILE = IcsCommonServiceHandler.getInstance().getSysAppDataPath() + File.separator + ConfigServiceHandler.getInstance().get("system.lang") + File.separator + "networkConfig.properties";

    private ProxyServiceHandler() {
    }

    public static ProxyServiceHandler getInstance() {
        return ProxyServiceHandlerHolder.INSTANCE;
    }

    @Override
    public ProxyDto saveNetworkConfig(ProxyDto proxyDto) {
        ProxyDto resultDto = this.preSaveNetworkConfig(proxyDto);
        try {
            NetworkServiceHandler.getInstance().updateHttpClientForProxy();
            OperationLogUtils.INSTANCE.successOperationLog("icslite-business-common", "SAVE", "The proxy config save is change.");
        }
        catch (IllegalArgumentException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Proxy port is not number when save.", (Throwable)e);
            OperationLogUtils.INSTANCE.failOperationLog("icslite-business-common", "SAVE", "The proxy config save has exception.");
        }
        if (StringUtils.equalsAny((CharSequence)proxyDto.getType(), (CharSequence[])new CharSequence[]{"1", "2"})) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Proxy type is {0},the address is {1}.", new Object[]{resultDto.getType(), resultDto.getAddress()});
        }
        return resultDto;
    }

    @Override
    public boolean checkNetworkProxy(ProxyDto proxyDto) throws ProxyException {
        HttpClientDto httpClientDto;
        if (StringUtils.equals((CharSequence)"0", (CharSequence)proxyDto.getType())) {
            return true;
        }
        String domain = UrlDataServiceHandler.getInstance().getDomain();
        try {
            httpClientDto = NetworkServiceHandler.getInstance().getHttpClientForProxyTest();
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "failed to get the httpClient.", (Throwable)e);
            throw new ProxyException("not get test address");
        }
        return this.preCheckNetworkProxy(proxyDto, domain, httpClientDto);
    }

    public boolean preCheckNetworkProxy(ProxyDto proxyDo, String domain, HttpClientDto httpClientDto) throws ProxyException {
        ProxyDto networkProxyDo = proxyDo;
        if (StringUtils.isBlank((CharSequence)domain)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "not get test address when check network proxy");
            throw new ProxyException("not get test address");
        }
        String address = networkProxyDo.getAddress();
        if (StringUtils.startsWithAny((CharSequence)address, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            int index = address.indexOf("://");
            if (index < 0) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "IE proxy not conforming standard of address:port");
                return false;
            }
            networkProxyDo.setAddress(address.substring(index + "://".length()));
        }
        networkProxyDo.setPassword(this.getRealPassword(networkProxyDo.getPassword()));
        try {
            HttpClientDto newClientDto = httpClientDto.newBuilder().url(domain).mediaType(networkProxyDo.getType()).proxyHost(networkProxyDo.getAddress()).proxyPort(networkProxyDo.getPort()).proxyUserName(networkProxyDo.getUsername()).proxyPassword(networkProxyDo.getPassword()).build();
            String requestResult = NetWorkUtil.get((HttpClientDto)newClientDto);
            return StringUtils.isNotBlank((CharSequence)requestResult);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "response is failed.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "port is illegal.", (Throwable)e);
        }
        return false;
    }

    @Override
    public ProxyDto getProxyProperty(boolean isRealPwd) {
        String address;
        ProxyDto proxyDo = new ProxyDto();
        Properties networkProperty = this.preGetProxyProperty();
        proxyDo = this.getProxyDo(proxyDo, networkProperty);
        if (!isRealPwd && StringUtils.isNotBlank((CharSequence)proxyDo.getPassword())) {
            proxyDo.setPassword(DUMMY_SECRET);
        }
        if (StringUtils.startsWithAny((CharSequence)(address = proxyDo.getAddress()), (CharSequence[])new CharSequence[]{"http://", "https://"}) && isRealPwd) {
            int index = address.indexOf("://");
            if (index >= 0) {
                proxyDo.setAddress(address.substring(index + "://".length()));
                return proxyDo;
            }
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IE proxy not conforming standard of address:port");
        }
        return proxyDo;
    }

    public ProxyDto preSaveNetworkConfig(ProxyDto proxyInfo) {
        String port;
        ProxyDto proxyDo = proxyInfo;
        if (StringUtils.isNotBlank((CharSequence)proxyDo.getPassword())) {
            String realPassword = this.getRealPassword(proxyDo.getPassword());
            proxyDo.setPassword(this.encryPassword(realPassword));
        }
        if ((port = proxyDo.getPort()) != null) {
            proxyDo.setPort(this.verifyPort(port));
        }
        String type = proxyDo.getType();
        if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"0", "2"})) {
            this.updateProperties(proxyDo);
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
            proxyDo = this.getIeProxy(proxyDo);
            this.updateProperties(proxyDo);
        }
        OperationLogUtils.INSTANCE.successOperationLog("NetworkingService", "CHANGED", "The proxyInfo is changed.");
        return this.getProxyFile();
    }

    public ProxyDto getProxyFile() {
        ProxyDto proxyDo = new ProxyDto();
        Properties networkProperty = this.preGetProxyProperty();
        String password = (proxyDo = this.getProxyDo(proxyDo, networkProperty)).getPassword();
        if (StringUtils.isNotBlank((CharSequence)password)) {
            proxyDo.setPassword(DUMMY_SECRET);
        }
        return proxyDo;
    }

    public String getRealPassword(String sourcePassword) {
        String webPassword = sourcePassword;
        Properties proxyProperty = this.preGetProxyProperty();
        String oldPassword = proxyProperty.getProperty(this.getIdentityKey());
        if (StringUtils.isNotBlank((CharSequence)oldPassword)) {
            String realPassword = this.decryPassword(oldPassword);
            if (StringUtils.equals((CharSequence)webPassword, (CharSequence)DUMMY_SECRET)) {
                webPassword = realPassword;
            }
        }
        return webPassword;
    }

    public ProxyDto getIeProxy(ProxyDto proxyDo) {
        IeProxyConfig ieProxyConfig = IeProxyUtils.detectIeProxyConfig();
        if (ieProxyConfig == null || StringUtils.isBlank((CharSequence)ieProxyConfig.getProxy())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Ie get proxy is null");
            ProxyDto networkDo = new ProxyDto();
            networkDo.setType("1");
            return networkDo;
        }
        String proxy = ieProxyConfig.getProxy();
        int index = proxy.lastIndexOf(":");
        if (index < 0) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "proxy not conforming standard of address");
            ProxyDto networkDo = new ProxyDto();
            networkDo.setType("1");
            return networkDo;
        }
        proxyDo.setAddress(proxy.substring(0, index));
        proxyDo.setPort(proxy.substring(index + 1));
        return proxyDo;
    }

    public Properties preGetProxyProperty() {
        File file = FileUtils.getFile((String[])new String[]{NETWORK_FILE});
        if (!file.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "proxy networkConfig not exists.");
            return new Properties();
        }
        Properties networkProperty = PropertiesUtils.getPropertiesByFile((File)file);
        if (networkProperty == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "networkProperty load failed.");
            return new Properties();
        }
        return networkProperty;
    }

    public ProxyDto getProxyDo(ProxyDto proxyDo, Properties networkProperty) {
        String password;
        String username;
        String port;
        String address;
        String type = StringUtils.trim((String)networkProperty.getProperty(PROXY_TYPE));
        if (StringUtils.isNotBlank((CharSequence)type)) {
            proxyDo.setType(type);
        }
        if (StringUtils.isNotBlank((CharSequence)(address = StringUtils.trim((String)networkProperty.getProperty(PROXY_ADDRESS))))) {
            proxyDo.setAddress(address);
        }
        if ((port = StringUtils.trim((String)networkProperty.getProperty(PROXY_PORT))) != null) {
            port = port.replaceAll("^(0+)", "");
            proxyDo.setPort(this.verifyPort(port));
            this.updateProxyField(networkProperty, PROXY_PORT, this.verifyPort(port));
        }
        if (StringUtils.isNotBlank((CharSequence)(username = StringUtils.trim((String)networkProperty.getProperty(PROXY_USERNAME))))) {
            proxyDo.setUsername(username);
        }
        if (StringUtils.isNotBlank((CharSequence)(password = StringUtils.trim((String)networkProperty.getProperty(this.getIdentityKey()))))) {
            proxyDo.setPassword(this.decryPassword(password));
        }
        return proxyDo;
    }

    public String verifyPort(String port) {
        Matcher isNum = PATTERN.matcher(port);
        if (StringUtils.isBlank((CharSequence)port) || !isNum.matches()) {
            return PROXY_PORT_NUM;
        }
        if (Long.parseLong(port) > 65535L || Long.parseLong(port) < 1L) {
            return PROXY_PORT_NUM;
        }
        return port;
    }

    public String encryPassword(String sourcePwd) {
        String source = sourcePwd;
        byte[] encrypt = DataSecurityHandlerFactory.getInstance((String)"DPAPI").encrypt(3, source);
        return Base64.encodeBase64String((byte[])encrypt);
    }

    public String decryPassword(String enPwd) {
        return DataSecurityHandlerFactory.getInstance((String)"DPAPI").decrpy(3, Base64.decodeBase64((String)enPwd));
    }

    public boolean updateProperties(ProxyDto proxyDo) {
        Optional<Properties> networkPropertyOpt = this.getNetworkProperty();
        if (!networkPropertyOpt.isPresent()) {
            return false;
        }
        Properties networkProperty = networkPropertyOpt.get();
        this.updateProxyField(networkProperty, PROXY_TYPE, proxyDo.getType());
        this.updateProxyField(networkProperty, PROXY_ADDRESS, proxyDo.getAddress());
        this.updateProxyField(networkProperty, PROXY_PORT, proxyDo.getPort());
        this.updateProxyField(networkProperty, PROXY_USERNAME, proxyDo.getUsername());
        this.updateProxyField(networkProperty, this.getIdentityKey(), proxyDo.getPassword());
        return PropertiesUtils.storeProperties((Properties)networkProperty, (String)NETWORK_FILE);
    }

    public boolean updatePassWordProperties(String passWord) {
        Optional<Properties> networkPropertyOpt = this.getNetworkProperty();
        if (!networkPropertyOpt.isPresent()) {
            return false;
        }
        Properties networkProperty = networkPropertyOpt.get();
        this.updateProxyField(networkProperty, this.getIdentityKey(), passWord);
        return PropertiesUtils.storeProperties((Properties)networkProperty, (String)NETWORK_FILE);
    }

    private Optional<Properties> getNetworkProperty() {
        File file = FileUtils.getFile((String[])new String[]{NETWORK_FILE});
        if (!this.existProxyConfigFile(file)) {
            return Optional.empty();
        }
        Properties networkProperty = PropertiesUtils.getPropertiesByFile((File)file);
        if (networkProperty == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "networkProperty load failed.");
            return Optional.empty();
        }
        return Optional.of(networkProperty);
    }

    private boolean existProxyConfigFile(File file) {
        if (file.exists()) {
            return true;
        }
        try {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                return false;
            }
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "ICSLite dir create failed.");
                return false;
            }
            if (!file.createNewFile()) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "proxy networkConfig create failed.");
                return false;
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "proxy networkConfig not exists, but create error.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void updateProxyField(Properties properties, String proxyKey, String proxyValue) {
        if (StringUtils.isNotBlank((CharSequence)proxyValue)) {
            properties.setProperty(proxyKey, proxyValue);
        } else {
            properties.setProperty(proxyKey, "");
        }
    }

    public String getIdentityKey() {
        return "password";
    }

    private static class ProxyServiceHandlerHolder {
        private static final ProxyServiceHandler INSTANCE = new ProxyServiceHandler();

        private ProxyServiceHandlerHolder() {
        }
    }
}

