/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.serviceimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.response.ResultCode;
import com.huawei.support.icslite.business.common.dao.UrlDataDaoHandler;
import com.huawei.support.icslite.business.common.dto.UrlDataDto;
import com.huawei.support.icslite.business.common.service.UrlDataService;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class UrlDataServiceHandler
implements UrlDataService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UrlDataServiceHandler.class);
    private String clientId;
    private String version;

    private UrlDataServiceHandler() {
    }

    public static UrlDataServiceHandler getInstance() {
        return UrlDataServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void init() {
        ConfigServiceHandler.getInstance().getOrSetDefault("server.domain.suffix", ".huawei.com");
    }

    @Override
    public UrlDataDto getUrl(HttpClientDto httpClientDto, String key, boolean isUpdateFile) {
        String url;
        if (isUpdateFile) {
            this.refreshLocalData(httpClientDto);
        }
        if (StringUtils.isEmpty((CharSequence)(url = this.getCompleteUrlByKey(key)))) {
            return null;
        }
        return new UrlDataDto(url);
    }

    @Override
    public UrlDataDto getUrlOrDefault(HttpClientDto httpClientDto, String key, boolean isUpdateFile, String defaultVal) {
        UrlDataDto result = this.getUrl(httpClientDto, key, isUpdateFile);
        return result != null ? result : new UrlDataDto(defaultVal);
    }

    @Override
    public String getDomain() {
        return this.getDomainByScene("SUPPORT.NGINX");
    }

    @Override
    public String getDomainByScene(String scene) {
        return UrlDataDaoHandler.getInstance().getDomainNginxByScene(scene) + ConfigServiceHandler.getInstance().get("server.domain.suffix");
    }

    @Override
    public String getUniportalUrl() {
        return UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("UNIPORTAL.NGINX", "oauth.cs.uniportalurl.suffix");
    }

    @Override
    public String getUrlFromKey(String key) {
        return this.getValueByKey(key);
    }

    @Override
    public String getUrlEntry(HttpClientDto httpClientDto, String key, boolean isUpdateFile) {
        if (isUpdateFile) {
            this.refreshLocalData(httpClientDto);
        }
        return this.getValueByKey(key);
    }

    public boolean refreshLocalData(HttpClientDto httpClientDto) {
        if (httpClientDto == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "can not refresh url data. httpClientDto is null.");
            return false;
        }
        String newJson = this.getUrlDataFromRemote(httpClientDto);
        return UrlDataDaoHandler.getInstance().update(newJson);
    }

    private String getUrlDataFromRemote(HttpClientDto httpClientDto) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.clientId, this.version})) {
            String clientIdFilePath = IcsCommonServiceHandler.getInstance().getSysProgramDataPath() + ConfigServiceHandler.getInstance().get("system.lang") + CommonConstants.CLIENT_MARK;
            this.clientId = IcsFileUtils.readFileContent((String)clientIdFilePath, null);
            this.version = IcsCommonServiceHandler.getInstance().getAppVersion();
        }
        String param = String.format(Locale.ENGLISH, "?clientId=%s&lang=%s&clientVersion=%s", this.clientId, ConfigServiceHandler.getInstance().get("system.lang"), this.version);
        String updateUrl = this.getCompleteUrlByKey("UrlUpgrade") + param;
        HttpClientDto newHttpClientDto = httpClientDto.newBuilder().url(updateUrl).build();
        try {
            String respJson = NetWorkUtil.get((HttpClientDto)newHttpClientDto);
            JSONObject resp = JSON.parseObject((String)respJson);
            if (resp == null) {
                return "";
            }
            if (ResultCode.SUCCESS.getReusltCode() == resp.getIntValue("code")) {
                return resp.getString("data");
            }
            CodeCCUtils.INSTANCE.warnLog(LOG, "Fail to get latest urldata, response is: " + respJson);
        }
        catch (JSONException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Parse response json error", (Throwable)e);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Fail to get url data from server", (Throwable)e);
        }
        return "";
    }

    private String getValueByKey(String key) {
        String value = UrlDataDaoHandler.getInstance().getValueByKey(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Can not find key[{0}]", new Object[]{key});
        }
        return value;
    }

    private String getCompleteUrlByKey(String key) {
        return this.getDomain() + this.getValueByKey(key);
    }

    @Override
    public String getUrlFromConfig(String key) {
        UrlDataDto urlDataDto = UrlDataServiceHandler.getInstance().getUrl(null, key, false);
        if (urlDataDto == null) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Get url from config warning ,value is empty. key = {0}", new Object[]{key});
            return "";
        }
        return urlDataDto.getMainUrl();
    }

    @Override
    public String getUrlFromSceneAndKey(String scene, String key) {
        return this.getDomainByScene(scene) + this.getValueByKey(key);
    }

    private static class UrlDataServiceHandlerHolder {
        private static final UrlDataServiceHandler INSTANCE = new UrlDataServiceHandler();

        private UrlDataServiceHandlerHolder() {
        }
    }
}

