/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.authorization.dto.CertificateDto;
import com.huawei.support.icslite.business.common.exception.HoupCertException;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.reference.BcStrongRandomizer;

public class HoupCertUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(HoupCertUtils.class);
    private static final String KEYSTORE_TYPE = "JKS";

    public static void verifyCertificatesExist(CertificateDto certificateDto) {
        if (ObjectUtils.isEmpty((Object)certificateDto)) {
            throw new HoupCertException("Client certificate is not exist!");
        }
        if (StringUtils.isEmpty((CharSequence)certificateDto.getCertificate())) {
            throw new HoupCertException("Client cert is not exist!");
        }
        if (StringUtils.isEmpty((CharSequence)certificateDto.getPrivateKey())) {
            throw new HoupCertException("Client key is not exist!");
        }
    }

    public static KeyStore createKeyStore(String keyPem, String certPem, String pwStr) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        PrivateKey privateKey = HoupCertUtils.loadPrivateKey(keyPem);
        Objects.requireNonNull(privateKey);
        List<Certificate> privateCertificates = HoupCertUtils.loadCertificates(certPem);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        keyStore.load(null);
        keyStore.setKeyEntry(pwStr, privateKey, pwStr.toCharArray(), privateCertificates.toArray(new Certificate[0]));
        return keyStore;
    }

    /*
     * Exception decompiling
     */
    private static List<Certificate> loadCertificates(String certPem) throws IOException, CertificateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static PrivateKey loadPrivateKey(String keyPem) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<Certificate> loadCertificates(Reader reader) throws IOException, CertificateException {
        try (PEMParser pemParser = new PEMParser(reader);){
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            Object certObj = pemParser.readObject();
            if (certObj instanceof X509CertificateHolder) {
                X509CertificateHolder certificateHolder = (X509CertificateHolder)certObj;
                certificates.add(certificateConverter.getCertificate(certificateHolder));
            }
            ArrayList<Certificate> arrayList = certificates;
            return arrayList;
        }
    }

    private static PrivateKey loadPrivateKey(Reader reader) throws IOException {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object readObject = pemParser.readObject();
            while (readObject != null) {
                PrivateKeyInfo privateKeyInfo = HoupCertUtils.getPrivateKeyInfo(readObject);
                if (privateKeyInfo != null) {
                    PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                    return privateKey;
                }
                readObject = pemParser.readObject();
            }
        }
        return null;
    }

    private static PrivateKeyInfo getPrivateKeyInfo(Object pemObject) {
        if (pemObject instanceof PEMKeyPair) {
            PEMKeyPair pemKeyPair = (PEMKeyPair)pemObject;
            return pemKeyPair.getPrivateKeyInfo();
        }
        if (pemObject instanceof PrivateKeyInfo) {
            return (PrivateKeyInfo)pemObject;
        }
        if (pemObject instanceof ASN1ObjectIdentifier) {
            CodeCCUtils.INSTANCE.infoLog(log, "Ignoring asn1ObjectIdentifier.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "Unknown object.");
        return null;
    }

    public static String getRandomString(Integer length) {
        return BcStrongRandomizer.getInstance().getRandomString(length.intValue(), EncoderConstants.CHAR_ALPHANUMERICS);
    }
}

