/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class HoupHttpsUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(HoupHttpsUtils.class);
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    public static String doGetByCert(String url, Map<String, String> headers) {
        try {
            HttpClientDto httpClientDto = NetworkServiceHandler.getInstance().getHttpClientForHoup(null).newBuilder().url(url).headers(headers).build();
            return HoupHttpsUtils.parseResult(NetWorkUtil.get((HttpClientDto)httpClientDto));
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to doGetByCert with NetWorkSwitchException.", (Throwable)e);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to doGetByCert with DownloadException.", (Throwable)e);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to doGetByCert with Exception.", (Throwable)e);
        }
        return "";
    }

    public static String doPostByCert(String url, String body, Map<String, String> headers) {
        return HoupHttpsUtils.getPostString(url, null, body, headers);
    }

    public static String doPostByCert(String url, Map<String, String> body, Map<String, String> headers) {
        return HoupHttpsUtils.getPostString(url, body, null, headers);
    }

    private static String getPostString(String url, Map<String, String> body, String bodyJson, Map<String, String> headers) {
        try {
            HttpClientDto httpClientDto = NetworkServiceHandler.getInstance().getHttpClientForHoup(null).newBuilder().url(url).headers(headers).params(body).body(bodyJson).build();
            return HoupHttpsUtils.parseResult(NetWorkUtil.post((HttpClientDto)httpClientDto));
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to doPostByCert with NetWorkSwitchException.", (Throwable)e);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to doPostByCert with DownloadException.", (Throwable)e);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to doPostByCert with Exception.", (Throwable)e);
        }
        return "";
    }

    public static String parseResult(String responseStr) {
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            return "";
        }
        String result = JSON.toJSONString(((Map)JSONObject.parseObject((String)responseStr, MAP_TYPE_REFERENCE, (Feature[])new Feature[0])).get("result"));
        return StringUtils.equals((CharSequence)result, (CharSequence)"null") ? "" : result;
    }

    public static Optional<String> getResultValue(Object result, boolean isJson, String key) {
        if (Objects.isNull(result) || StringUtils.isBlank((CharSequence)key)) {
            return Optional.empty();
        }
        String json = isJson ? String.valueOf(result) : JSONObject.toJSONString((Object)result);
        Map resultMap = (Map)JSONObject.parseObject((String)json, MAP_TYPE_REFERENCE, (Feature[])new Feature[0]);
        if (CollectionUtils.isEmpty((Map)resultMap)) {
            CodeCCUtils.INSTANCE.errorLog(log, "GetResultValue convert map is empty, input json", new Object[]{json});
            return Optional.empty();
        }
        return Optional.ofNullable((String)resultMap.get(key));
    }
}

