/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.json.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;

public class NetWorkUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(NetWorkUtils.class);

    private NetWorkUtils() {
    }

    public static <T> List<T> getJsonList(String json, Class<T> clazz) {
        Optional<Object> objectOptional = NetWorkUtils.getDataStr(json);
        if (!objectOptional.isPresent()) {
            return new ArrayList();
        }
        String docInfosJson = objectOptional.get().toString();
        List infoDtos = new ArrayList();
        try {
            infoDtos = JSON.parseArray((String)docInfosJson, clazz);
        }
        catch (JSONException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Json transform list fail.", (Throwable)e);
        }
        return infoDtos;
    }

    public static <T> List<T> getList(String json, Class<T> clazz) {
        Optional<Object> objectOptional = NetWorkUtils.getDataStr(json);
        if (!objectOptional.isPresent()) {
            return new ArrayList();
        }
        return JsonUtils.castList((Object)objectOptional.get(), clazz);
    }

    private static Optional<Object> getDataStr(String json) {
        Map infoMap = JsonUtils.stringToMap((String)json);
        if (MapUtils.isEmpty((Map)infoMap)) {
            return Optional.empty();
        }
        return Optional.ofNullable(infoMap.get("data"));
    }
}

