/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.customsort.service.impl;

import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import com.huawei.support.icslite.business.customsort.convert.CustomSortConverter;
import com.huawei.support.icslite.business.customsort.dependency.CustomSortDependency;
import com.huawei.support.icslite.business.customsort.dto.CustomSortDto;
import com.huawei.support.icslite.business.customsort.service.CustomSortBusiness;
import com.huawei.support.icslite.business.customsort.util.CustomSortUtils;
import com.huawei.support.icslite.business.customsort.util.DocFilterUtils;
import com.huawei.support.icslite.business.libmanage.dto.FilterParamDto;
import com.huawei.support.icslite.customsort.dto.CustomSortDo;
import com.huawei.support.icslite.customsort.service.impl.CustomSortServiceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomSortBusinessHandler
implements CustomSortBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CustomSortBusinessHandler.class);

    private CustomSortBusinessHandler() {
    }

    public static CustomSortBusinessHandler getInstance() {
        return CustomSortBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        CustomSortServiceHandler.getInstance().createTb();
    }

    @Override
    public void createRootDo() {
        if (CustomSortServiceHandler.getInstance().getByNodeId("1") != null) {
            return;
        }
        CustomSortDo customSortDo = CustomSortUtils.createNodeDo();
        customSortDo.setNodeId("1");
        customSortDo.setParentId("0");
        customSortDo.setName("root");
        CustomSortServiceHandler.getInstance().add(customSortDo);
    }

    @Override
    public boolean addLibData(LibBaseDo libBaseDo, String libType) {
        if (libBaseDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "libBaseDo is null.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)libBaseDo.getDocId())) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is blank.");
            return false;
        }
        if (this.checkSameLib(libBaseDo.getDocId())) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "the same HDX properties file,which is:{0}", new Object[]{libBaseDo.getDocId()});
            return false;
        }
        CustomSortDo customSortDo = new CustomSortDo();
        customSortDo.setParentId("1");
        customSortDo.setNodeId(CustomSortUtils.createNodeId());
        customSortDo.setType("2");
        customSortDo.setLibType(libType);
        customSortDo.setIsParent(false);
        CustomSortUtils.setContent(libBaseDo, customSortDo);
        return CustomSortServiceHandler.getInstance().add(customSortDo);
    }

    @Override
    public String del(String nodeId, String modifyTime) {
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return "0";
        }
        return this.delFolder(nodeId, modifyTime);
    }

    @Override
    public List<CustomSortDto> getNodeAndChilds(String nodeId, FilterParamDto filterParamDto) {
        LinkedList<CustomSortDto> customSortDtoList = new LinkedList<CustomSortDto>();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "nodeId is Empty.");
            return customSortDtoList;
        }
        CustomSortDto customSortDto = CustomSortConverter.INSTANCE.domainDto(CustomSortServiceHandler.getInstance().getByNodeId(nodeId));
        if (customSortDto != null) {
            customSortDtoList.add(customSortDto);
            customSortDtoList.addAll(this.getSortChildList(nodeId));
        }
        Map<String, List<CustomSortDto>> customSortDtoMap = customSortDtoList.stream().collect(Collectors.groupingBy(CustomSortDto::getType));
        List<CustomSortDto> docList = customSortDtoMap.get("2");
        if (filterParamDto == null || CollectionUtils.isEmpty(docList)) {
            return customSortDtoList;
        }
        return Stream.concat(customSortDtoMap.get("1").stream(), DocFilterUtils.filterLib(docList.stream(), filterParamDto)).collect(Collectors.toList());
    }

    private List<CustomSortDto> getSortChildList(String nodeId) {
        List childList = CustomSortServiceHandler.getInstance().getNodeTree(nodeId);
        List<CustomSortDo> folderList = this.getChilds(childList, "1");
        CustomSortUtils.sortByName(folderList);
        ArrayList<CustomSortDto> customSortDtoList = new ArrayList<CustomSortDto>(CustomSortConverter.INSTANCE.domainCustomDos(folderList));
        List<CustomSortDo> docList = this.getChilds(childList, "2");
        CustomSortUtils.sortByName(docList);
        customSortDtoList.addAll(CustomSortConverter.INSTANCE.domainCustomDos(docList));
        return customSortDtoList;
    }

    private List<CustomSortDo> getChilds(List<CustomSortDo> childList, String type) {
        ArrayList<CustomSortDo> customSortDtos = new ArrayList<CustomSortDo>();
        for (CustomSortDo customSortDto : childList) {
            List nodes;
            String currentType = customSortDto.getType();
            if (StringUtils.equals((CharSequence)currentType, (CharSequence)"2")) {
                this.updateFiledData(customSortDto);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)currentType)) {
                customSortDtos.add(customSortDto);
            }
            if (CollectionUtils.isEmpty((Collection)(nodes = customSortDto.getNodes()))) continue;
            customSortDtos.addAll(this.getChilds(nodes, type));
        }
        return customSortDtos;
    }

    private void updateFiledData(CustomSortDo customSortDto) {
        String docId = customSortDto.getDocId();
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            this.syncFiledData(customSortDto, (LibBaseDo)HdxContentPoolServiceHandler.getInstance().get(docId));
            return;
        }
        this.syncFiledData(customSortDto, (LibBaseDo)IcsContentPoolServiceHandler.getInstance().get(docId));
    }

    private void syncFiledData(CustomSortDo customSortDto, LibBaseDo libBaseDo) {
        if (libBaseDo == null) {
            customSortDto.setbUpdate(false);
            return;
        }
        customSortDto.setbUpdate(libBaseDo.isbUpdate());
        customSortDto.setIndexProgress(libBaseDo.getIndexProgress());
        customSortDto.setProductName(libBaseDo.getProductName());
        customSortDto.setLang(libBaseDo.getLang());
    }

    @Override
    public List<CustomSortDto> getFolder() {
        List customSortDoList = CustomSortServiceHandler.getInstance().getFolder();
        CustomSortUtils.sortByName(customSortDoList);
        return CustomSortConverter.INSTANCE.domainCustomDos(customSortDoList);
    }

    @Override
    public List<CustomSortDto> getFolderWithoutRoot() {
        List folders = CustomSortServiceHandler.getInstance().getFolder();
        folders.removeIf(val -> StringUtils.equals((CharSequence)val.getNodeId(), (CharSequence)"1"));
        CustomSortUtils.sortByName(folders);
        return CustomSortConverter.INSTANCE.domainCustomDos(folders);
    }

    private String delFolder(String nodeId, String modifyTime) {
        if (!this.checkModifyTime(modifyTime)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del Categories failed, nodeId{0}", new Object[]{nodeId});
            return "-1";
        }
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return "0";
        }
        this.delFolderData(nodeId);
        this.updateRoot(String.valueOf(System.currentTimeMillis()));
        return "0";
    }

    private void delFolderData(String nodeId) {
        CustomSortServiceHandler.getInstance().del(nodeId);
        CodeCCUtils.INSTANCE.infoLog(LOG, "del Categories Succeed, nodeId{0}", new Object[]{nodeId});
        List customSortDoList = CustomSortServiceHandler.getInstance().getNodeTree(nodeId);
        if (CollectionUtils.isNotEmpty((Collection)customSortDoList)) {
            this.delChilds(customSortDoList);
        }
    }

    private void delChilds(List<CustomSortDo> childList) {
        for (CustomSortDo customSortDo : childList) {
            List nodes;
            String currentType = customSortDo.getType();
            if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)currentType)) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "del Categories Succeed, nodeId{0}", new Object[]{customSortDo.getNodeId()});
                CustomSortServiceHandler.getInstance().del(customSortDo.getNodeId());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)currentType)) {
                CustomSortServiceHandler.getInstance().del(customSortDo.getNodeId());
                CustomSortDependency.getInstance().delLib(customSortDo.getDocId());
            }
            if (CollectionUtils.isEmpty((Collection)(nodes = customSortDo.getNodes()))) continue;
            this.delChilds(nodes);
        }
    }

    @Override
    public CustomSortDto addNode(String parentId, String modifyTime) {
        CustomSortDto ret = null;
        CustomSortDo rootDo = CustomSortServiceHandler.getInstance().getByNodeId("1");
        if (!StringUtils.equals((CharSequence)rootDo.getModifyTime(), (CharSequence)modifyTime)) {
            return ret;
        }
        String id = StringUtils.isBlank((CharSequence)parentId) ? "1" : parentId;
        CustomSortDo parentDo = CustomSortServiceHandler.getInstance().getByNodeId(id);
        if (parentDo == null) {
            return ret;
        }
        String folderName = CustomSortDependency.getInstance().getDocName();
        List nameList = CustomSortServiceHandler.getInstance().getFixedNameFolder(folderName, id);
        CustomSortDo customSortDo = CustomSortUtils.createNodeDo();
        customSortDo.setNodeId(CustomSortUtils.createNodeId());
        customSortDo.setParentId(id);
        customSortDo.setName(CustomSortUtils.createNodeName(nameList, folderName, id));
        boolean isSuccess = CustomSortServiceHandler.getInstance().add(customSortDo);
        String nodeId = customSortDo.getNodeId();
        if (isSuccess) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "New Categories Succeed, nodeId:{0}", new Object[]{nodeId});
            this.updateRoot(customSortDo.getModifyTime());
            ret = CustomSortConverter.INSTANCE.domainDto(customSortDo);
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOG, "New Categories failed. nodeId:{0}", new Object[]{nodeId});
        }
        return ret;
    }

    @Override
    public List<CustomSortDto> getDocList(String nodeId) {
        List childList = CustomSortServiceHandler.getInstance().getNodeTree(nodeId);
        List<CustomSortDo> docList = this.getChilds(childList, "2");
        CustomSortUtils.sortByName(docList);
        return CustomSortConverter.INSTANCE.domainCustomDos(docList);
    }

    @Override
    public int size(String nodeId, FilterParamDto filterParamDto) {
        return DocFilterUtils.filterLib(this.getDocList(nodeId).stream(), filterParamDto).mapToInt(customDto -> 1).sum();
    }

    @Override
    public String modifyName(String nodeId, String name, String modifyTime) {
        if (!this.checkModifyTime(modifyTime)) {
            return "-1";
        }
        CustomSortDo customSortDo = CustomSortServiceHandler.getInstance().getByNodeId(nodeId);
        List nameList = CustomSortServiceHandler.getInstance().getFixedNameFolder(name, customSortDo.getParentId());
        if (nameList.contains(name)) {
            return "2";
        }
        String currentTime = String.valueOf(System.currentTimeMillis());
        CustomSortServiceHandler.getInstance().modifyName(nodeId, name, currentTime);
        CodeCCUtils.INSTANCE.infoLog(LOG, "Categories modifyName Succeed, nodeId{0}", new Object[]{customSortDo.getNodeId()});
        this.updateRoot(currentTime);
        return "0";
    }

    private void updateRoot(String modifyTime) {
        CustomSortServiceHandler.getInstance().modifyName("1", "root", modifyTime);
    }

    @Override
    public String modifyParentNode(List<String> nodeIds, String parentId, String modifyTime) {
        if (!this.checkModifyTime(modifyTime)) {
            return "-1";
        }
        String currentTime = String.valueOf(System.currentTimeMillis());
        for (String nodeId : nodeIds) {
            CustomSortServiceHandler.getInstance().modifyParentNode(nodeId, parentId, currentTime);
        }
        this.updateRoot(currentTime);
        return "0";
    }

    @Override
    public String updateExpand(String nodeId, boolean isExpand) {
        return CustomSortServiceHandler.getInstance().updateExpand(nodeId, isExpand) ? "0" : "-1";
    }

    @Override
    public void setUpDateFlag(String docId, boolean isUpdate) {
        CustomSortDo customSortDo = CustomSortServiceHandler.getInstance().getByDocId(docId);
        if (customSortDo != null) {
            customSortDo = CustomSortServiceHandler.getInstance().getByNodeId(customSortDo.getNodeId());
            customSortDo.setbUpdate(isUpdate);
        }
        CustomSortServiceHandler.getInstance().updateFlag(docId, isUpdate);
    }

    @Override
    public String getRootModifyTime() {
        CustomSortDo rootDo = CustomSortServiceHandler.getInstance().getByNodeId("1");
        if (rootDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "customSortDo is null.");
            return "";
        }
        return rootDo.getModifyTime();
    }

    private boolean checkModifyTime(String modifyTime) {
        CustomSortDo rootDo = CustomSortServiceHandler.getInstance().getByNodeId("1");
        if (rootDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "customSortDo is null.");
            return false;
        }
        return StringUtils.equals((CharSequence)rootDo.getModifyTime(), (CharSequence)modifyTime);
    }

    private boolean checkSameLib(String docId) {
        CustomSortDo customSortDo = CustomSortServiceHandler.getInstance().getByDocId(docId);
        return customSortDo != null;
    }

    private static class CustomSortBusinessHandlerHolder {
        private static final CustomSortBusinessHandler INSTANCE = new CustomSortBusinessHandler();

        private CustomSortBusinessHandlerHolder() {
        }
    }
}

