/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.customsort.util;

import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import com.huawei.support.icslite.customsort.dto.CustomSortDo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomSortUtils {
    private static final Pattern NUM_PATTERN = Pattern.compile("-?\\d+(\\\\.\\d+)?");

    private CustomSortUtils() {
    }

    public static void setContent(LibBaseDo libBaseDo, CustomSortDo customSortDo) {
        customSortDo.setDocId(libBaseDo.getDocId());
        customSortDo.setbUpdate(libBaseDo.isbUpdate());
        customSortDo.setProductV(libBaseDo.getProductV());
        customSortDo.setLibName(libBaseDo.getLibName());
        customSortDo.setName(libBaseDo.getLibName());
        customSortDo.setLibV(libBaseDo.getLibV());
        customSortDo.setIssueDate(libBaseDo.getIssueDate());
        customSortDo.setProductName(libBaseDo.getProductName());
        customSortDo.setLang(libBaseDo.getLang());
    }

    public static String createNodeId() {
        return "NODE" + UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String createNodeName(List<String> nameList, String newDirName, String parentId) {
        if (StringUtils.equals((CharSequence)"1", (CharSequence)parentId) && !nameList.contains(newDirName)) {
            return newDirName;
        }
        ArrayList<Integer> nums = new ArrayList<Integer>();
        nums.add(0);
        nameList.remove(newDirName);
        for (String name : nameList) {
            String numIt;
            if (!StringUtils.containsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"(", ")"}) || !NUM_PATTERN.matcher(numIt = name.substring(name.lastIndexOf("(") + 1, name.lastIndexOf(")"))).matches()) continue;
            nums.add(Integer.parseInt(numIt));
        }
        int start = 0;
        int res = 0;
        Collections.sort(nums);
        for (Integer num : nums) {
            if (start != num) {
                res = start;
                break;
            }
            ++start;
        }
        if (res == 0) {
            res = start;
        }
        return newDirName + "(" + res + ")";
    }

    public static CustomSortDo createNodeDo() {
        CustomSortDo customSortDo = new CustomSortDo();
        customSortDo.setExpand(true);
        customSortDo.setType("1");
        customSortDo.setModifyTime(String.valueOf(System.currentTimeMillis()));
        customSortDo.setIsParent(true);
        return customSortDo;
    }

    public static void sortByName(List<CustomSortDo> customSortDos) {
        if (CollectionUtils.isEmpty(customSortDos)) {
            return;
        }
        Collator sortChina = Collator.getInstance(Locale.CHINA);
        customSortDos.sort((after, before) -> sortChina.compare(after.getName(), before.getName()));
    }
}

