/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.customsort.util;

import com.huawei.support.icslite.business.common.dto.LibCommonDto;
import com.huawei.support.icslite.business.libmanage.dto.FilterParamDto;
import com.huawei.support.icslite.business.libmanage.utils.CommonLibManageUtils;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DocFilterUtils<T extends LibCommonDto> {
    public static <T extends LibCommonDto> Stream<T> filterLib(Stream<T> stream, FilterParamDto filterParamDto) {
        if (stream == null || filterParamDto == null) {
            return stream;
        }
        return DocFilterUtils.filterLibName(stream, filterParamDto);
    }

    private static <T extends LibCommonDto> Stream<T> filterLibName(Stream<T> stream, FilterParamDto filterParamDto) {
        String libNameInput = filterParamDto.getLibNameInput();
        if (StringUtils.isNotBlank((CharSequence)libNameInput)) {
            return DocFilterUtils.filterProductV(stream.filter(libCommonDto -> CommonLibManageUtils.isSonStr(libCommonDto.getLibName(), libNameInput)), filterParamDto);
        }
        return DocFilterUtils.filterProductV(stream, filterParamDto);
    }

    private static <T extends LibCommonDto> Stream<T> filterProductV(Stream<T> stream, FilterParamDto filterParamDto) {
        List<String> productVs = filterParamDto.getProductVs();
        if (CollectionUtils.isNotEmpty(productVs)) {
            return DocFilterUtils.filterLibV(stream.filter(libCommonDto -> CommonLibManageUtils.isContain(productVs, libCommonDto.getProductV())), filterParamDto);
        }
        return DocFilterUtils.filterLibV(stream, filterParamDto);
    }

    private static <T extends LibCommonDto> Stream<T> filterLibV(Stream<T> stream, FilterParamDto filterParamDto) {
        List<String> libVs = filterParamDto.getLibVs();
        if (CollectionUtils.isNotEmpty(libVs)) {
            return DocFilterUtils.filterIssueDate(stream.filter(libCommonDto -> CommonLibManageUtils.isContain(libVs, libCommonDto.getLibV())), filterParamDto);
        }
        return DocFilterUtils.filterIssueDate(stream, filterParamDto);
    }

    private static <T extends LibCommonDto> Stream<T> filterIssueDate(Stream<T> stream, FilterParamDto filterParamDto) {
        String issueDateInput = filterParamDto.getIssueDateInput();
        if (StringUtils.isNotBlank((CharSequence)issueDateInput)) {
            return DocFilterUtils.filterIndexProgress(stream.filter(libCommonDto -> CommonLibManageUtils.isSonStr(libCommonDto.getIssueDate(), issueDateInput)), filterParamDto);
        }
        return DocFilterUtils.filterIndexProgress(stream, filterParamDto);
    }

    private static <T extends LibCommonDto> Stream<T> filterIndexProgress(Stream<T> stream, FilterParamDto filterParamDto) {
        List<String> indexProgressStatuses = filterParamDto.getIndexProgressStatuses();
        if (CollectionUtils.isNotEmpty(indexProgressStatuses)) {
            return stream.filter(libCommonDto -> CommonLibManageUtils.isContainIndexStatus(indexProgressStatuses, libCommonDto.getIndexProgress()));
        }
        return stream;
    }
}

