/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docexport.helper;

import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.dto.HtmlDocumentDto;
import com.huawei.support.icscbb.convert.helper.ConvertPathHelper;
import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import com.huawei.support.icslite.business.docexport.dto.ExportNodeDto;
import com.huawei.support.icslite.business.docexport.helper.ExportLibHelper;
import com.huawei.support.icslite.business.docexport.util.FontUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportConvertHelper {
    private static final String DOCUMENT_TOPIC_RELATIVE_PATH_PREFIX = "resources" + File.separator;
    private static final String ISSUE_DATE_ZH_NAME_PREFIX = "\u53d1\u5e03\u65e5\u671f     ";
    private static final String ISSUE_DATE_EN_NAME_PREFIX = "Issue Date     ";
    private static final String ZH_FONTS_NAME = "FZLTHJW";
    private static final String EN_FONTS_NAME = "HuaweiSans";

    private ExportConvertHelper() {
    }

    public static HtmlConvertDto exportParamsToConvertDto(String convertTempDir, String docId, String documentType, List<ExportNodeDto> nodeList, String saveFileName) {
        String fontName;
        LibBaseDo libBaseDo = ExportLibHelper.getLibBaseDo(documentType, docId);
        if (libBaseDo == null) {
            return null;
        }
        nodeList.removeIf(node -> !ExportConvertHelper.accordHtmlSuffix(node.getTopicUrl()));
        List<HtmlDocumentDto> htmlDocumentDtoList = ExportConvertHelper.nodeList2HtmlDocumentList(docId, nodeList, documentType);
        ConvertPathHelper.normalizeNumber(htmlDocumentDtoList);
        String lang = (String)StringUtils.defaultIfBlank((CharSequence)libBaseDo.getLang(), (CharSequence)"en");
        String issueDate = libBaseDo.getIssueDate();
        if (StringUtils.contains((CharSequence)issueDate, (CharSequence)" ")) {
            issueDate = issueDate.substring(0, issueDate.lastIndexOf(" "));
        }
        if (StringUtils.equals((CharSequence)lang, (CharSequence)"zh")) {
            issueDate = ISSUE_DATE_ZH_NAME_PREFIX + issueDate;
            fontName = ZH_FONTS_NAME;
        } else {
            issueDate = ISSUE_DATE_EN_NAME_PREFIX + issueDate;
            fontName = EN_FONTS_NAME;
        }
        return new HtmlConvertDto().setDocumentDtoList(htmlDocumentDtoList).setZipFilePath(libBaseDo.getPath()).setSaveFileName(saveFileName).setLang(lang).setTempDirectory(convertTempDir).setFileName(libBaseDo.getLibName()).setProductName(libBaseDo.getProductName()).setProductVersion(libBaseDo.getProductV()).setIssueDate(issueDate).setTaskType("pid").setFontsDirectory(FontUtils.getFontsPath(lang)).setHuaweiWebsite(ConfigServiceHandler.getInstance().get("export.website.link.url")).setHuaweiMail(ConfigServiceHandler.getInstance().get("export.mail.link.url")).setFontName(fontName);
    }

    private static boolean accordHtmlSuffix(String topicUrl) {
        return StringUtils.endsWithAny((CharSequence)topicUrl.toLowerCase(Locale.ROOT), (CharSequence[])new CharSequence[]{"html", "htm"});
    }

    private static List<HtmlDocumentDto> nodeList2HtmlDocumentList(String docId, List<ExportNodeDto> nodeList, String documentType) {
        if (CollectionUtils.isEmpty(nodeList)) {
            return new ArrayList<HtmlDocumentDto>();
        }
        LibBaseDo libBaseDo = ExportLibHelper.getLibBaseDo(documentType, docId);
        return nodeList.stream().map(nodeDto -> {
            LibBaseDo topicLibBaseDo = StringUtils.equals((CharSequence)nodeDto.getTopicDocId(), (CharSequence)docId) ? libBaseDo : ExportLibHelper.getLibBaseDo(documentType, nodeDto.getTopicDocId());
            String topicZipFilePath = topicLibBaseDo == null ? "" : topicLibBaseDo.getPath();
            return new HtmlDocumentDto(topicZipFilePath, nodeDto.getExportNodePosition(), nodeDto.getExportNodeName(), DOCUMENT_TOPIC_RELATIVE_PATH_PREFIX + nodeDto.getTopicUrl());
        }).collect(Collectors.toList());
    }
}

