/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docexport.helper;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class ExportLibHelper {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyMdd HHmmss");

    private ExportLibHelper() {
    }

    public static String geDefaultSaveName(String docId, String libType) {
        String fileName = "default";
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, libType})) {
            return fileName;
        }
        if (StringUtils.equals((CharSequence)libType, (CharSequence)"ICS")) {
            IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
            if (icsContentDo == null) {
                return fileName;
            }
            fileName = icsContentDo.getLibName();
        }
        if (StringUtils.equals((CharSequence)libType, (CharSequence)"HDX")) {
            HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
            if (hdxContentDo == null) {
                return fileName;
            }
            fileName = hdxContentDo.getLibName();
        }
        return fileName + "_" + ExportLibHelper.getNowDateStr();
    }

    public static LibBaseDo getLibBaseDo(String documentType, String docId) {
        IcsContentDo contentDo = null;
        if (StringUtils.equals((CharSequence)documentType, (CharSequence)"ICS")) {
            contentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        }
        if (StringUtils.equals((CharSequence)documentType, (CharSequence)"HDX")) {
            contentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        }
        return contentDo;
    }

    private static String getNowDateStr() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.format(DATE_TIME_FORMATTER);
    }
}

