/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docexport.helper;

import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class ExportProcessHelper {
    protected static final List<String> EXCLUDE_JAR_LIST = ExportProcessHelper.getExcludeJarList();
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ExportProcessHelper.class);

    private static List<String> getExcludeJarList() {
        return Collections.unmodifiableList(Arrays.asList("common-adapter-encryption", "icscbb-cms-verify", "bcpg-jdk15on", "bcpkix-jdk15on", "icslite-db", "hibernate-validator", "derby"));
    }

    public List<String> getExportProcessJvmOpts() {
        String jvmXmx;
        ArrayList<String> jvmOpts = new ArrayList<String>();
        String jvmXms = ConfigServiceHandler.getInstance().get("export.process.env.jvm.xms");
        if (StringUtils.isNotBlank((CharSequence)jvmXms)) {
            jvmOpts.add(jvmXms);
        }
        if (StringUtils.isNotBlank((CharSequence)(jvmXmx = ConfigServiceHandler.getInstance().get("export.process.env.jvm.xmx")))) {
            jvmOpts.add(jvmXmx);
        }
        return jvmOpts;
    }

    protected long getProcessTimeOut() {
        return Long.parseLong(ConfigServiceHandler.getInstance().getOrSetDefault("export.process.timeout", "120"));
    }
}

