/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docexport.serviceimpl;

import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.helper.ConvertPathHelper;
import com.huawei.support.icscbb.convert.util.ProgressPropertyUtils;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.service.impl.IcsPidPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.docexport.convert.IcsTopicDoConverter;
import com.huawei.support.icslite.business.docexport.convert.NaviContentDoConverter;
import com.huawei.support.icslite.business.docexport.dto.ExportBaseDto;
import com.huawei.support.icslite.business.docexport.dto.ExportDocDto;
import com.huawei.support.icslite.business.docexport.dto.ExportNodeDto;
import com.huawei.support.icslite.business.docexport.dto.ExportPortalDto;
import com.huawei.support.icslite.business.docexport.dto.ExportResultDto;
import com.huawei.support.icslite.business.docexport.helper.ExportConvertHelper;
import com.huawei.support.icslite.business.docexport.helper.ExportLibHelper;
import com.huawei.support.icslite.business.docexport.helper.ExportServiceHelper;
import com.huawei.support.icslite.business.docexport.helper.ExportTempHelper;
import com.huawei.support.icslite.business.docexport.service.ExportService;
import com.huawei.support.icslite.business.docexport.task.ExportTask;
import com.huawei.support.icslite.business.docexport.util.HdxNaviUtils;
import com.huawei.support.icslite.business.docexport.util.IcsNaviUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportServiceHandler
extends ExportServiceHelper
implements ExportService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ExportServiceHandler.class);
    private static final int CORE_POOL_SIZE = 1;
    private static final int KEEP_ALIVE_SECONDS = 600;
    private static final int MAX_POOL_SIZE = 30;
    private static final int QUEUE_CAPACITY = 60;
    private static final int TOPIC_FINISHED_MAX_PROGRESS = 90;
    private static final int DIVIDE_SCALE = 5;
    private static final String CANT_OPEN_DISK_CHARS = "[<>\"/|?*:%\\\\]";
    private static final List<String> SUPPORTED_SUFFIX_LIST = Collections.unmodifiableList(Arrays.asList("html", "doc", "docx", "pdf"));
    private volatile String completeSaveFileName;
    private volatile boolean isCompleted;
    private volatile boolean isCancel;

    private ExportServiceHandler() {
    }

    public static ExportServiceHandler getInstance() {
        return ExportServiceHandlerHolder.INSTANCE;
    }

    @Override
    public boolean hasSaveTask() {
        return this.isThreadsFull();
    }

    @Override
    public String openSavePath(String docId, String libType) {
        String defaultSaveFileName = ExportLibHelper.geDefaultSaveName(docId, libType);
        defaultSaveFileName = defaultSaveFileName.replaceAll(CANT_OPEN_DISK_CHARS, "");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "Startup.exe");
        commands.add(defaultSaveFileName);
        commands.add("OpenSavePath:");
        StringBuilder savePathBuilder = new StringBuilder();
        try {
            ProcessBuilder openDiskProcessBuilder = new ProcessBuilder(new String[0]);
            openDiskProcessBuilder.command(commands);
            Process openDiskProcess = openDiskProcessBuilder.start();
            ExportServiceHandler.getMessageOfSubProcess(openDiskProcess.getInputStream(), savePathBuilder);
            StringBuilder errStringBuilder = new StringBuilder();
            ExportServiceHandler.getMessageOfSubProcess(openDiskProcess.getErrorStream(), errStringBuilder);
            int retCode = openDiskProcess.waitFor();
            if (retCode != 0) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "The process of choose directory exception,error msg: {0}", new Object[]{errStringBuilder.toString()});
            }
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Export choose directory error.", (Throwable)e);
            return "";
        }
        return savePathBuilder.toString();
    }

    @Override
    public ExportResultDto savePage(ExportDocDto exportDocDto, String documentType) {
        Optional<ExportResultDto> validateResult = this.savePageValidate(exportDocDto, documentType);
        if (validateResult.isPresent()) {
            return validateResult.get();
        }
        List<ExportNodeDto> nodeList = this.getExportNodeDtoList(exportDocDto, documentType);
        return this.addExportTask(exportDocDto, nodeList, documentType, (String)StringUtils.defaultIfBlank((CharSequence)exportDocDto.getPidId(), (CharSequence)""));
    }

    @Override
    public ExportResultDto savePortal(ExportPortalDto exportPortalDto) {
        Optional<ExportResultDto> validateResult = this.savePageValidate(exportPortalDto, "ICS");
        if (validateResult.isPresent()) {
            return validateResult.get();
        }
        List<ExportNodeDto> nodeList = this.getPortalExportNodeList(exportPortalDto);
        return this.addExportTask(exportPortalDto, nodeList, "ICS", "");
    }

    private Optional<ExportResultDto> savePageValidate(ExportBaseDto baseDto, String documentType) {
        boolean existSaveTask = this.isThreadsFull();
        if (existSaveTask) {
            return Optional.ofNullable(new ExportResultDto().setHasTask(true));
        }
        this.completeSaveFileName = baseDto.getSaveFileName();
        this.isCompleted = false;
        this.isCancel = false;
        String fileSuffix = FilenameUtils.getExtension((String)baseDto.getSaveFileName());
        boolean isSupportedType = SUPPORTED_SUFFIX_LIST.stream().anyMatch(suffixName -> StringUtils.equals((CharSequence)fileSuffix, (CharSequence)suffixName));
        if (!StringUtils.equalsAny((CharSequence)documentType, (CharSequence[])new CharSequence[]{"ICS", "HDX"}) || !isSupportedType) {
            return Optional.ofNullable(new ExportResultDto().setNormalExport(false));
        }
        return Optional.empty();
    }

    private ExportResultDto addExportTask(ExportBaseDto baseDto, List<ExportNodeDto> nodeList, String documentType, String pidId) {
        if (CollectionUtils.isEmpty(nodeList)) {
            return new ExportResultDto().setNormalExport(false);
        }
        if (!this.getTotalTempDir(nodeList.size())) {
            return new ExportResultDto().setNormalExport(false);
        }
        return new ExportResultDto().setNormalExport(this.isAddExportTaskSuccess(baseDto.getDocId(), nodeList, baseDto.getSaveFileName(), documentType, pidId));
    }

    private List<ExportNodeDto> getExportNodeDtoList(ExportDocDto exportDocDto, String documentType) {
        List<ExportNodeDto> nodeList = StringUtils.equals((CharSequence)documentType, (CharSequence)"ICS") ? IcsTopicDoConverter.INSTANCE.topicDoListToExportList(IcsNaviUtils.getNaviListByPositions(exportDocDto.getDocId(), exportDocDto.getReDocId(), exportDocDto.getPidId(), exportDocDto.getNaviIds())) : NaviContentDoConverter.INSTANCE.naviDoListToExportList(HdxNaviUtils.getNaviListByPositions(exportDocDto.getDocId(), exportDocDto.getNaviIds()));
        return nodeList;
    }

    private List<ExportNodeDto> getPortalExportNodeList(ExportPortalDto exportPortalDto) {
        ArrayList<IcsTopicDo> icsTopicDoList = new ArrayList<IcsTopicDo>();
        String mainDocId = exportPortalDto.getDocId();
        exportPortalDto.getPidDtoList().forEach(pidSaveDto -> icsTopicDoList.addAll(IcsNaviUtils.getNaviListByPortalPid(mainDocId, pidSaveDto.getPidDocId(), pidSaveDto.getPidId())));
        return IcsTopicDoConverter.INSTANCE.topicDoListToExportList(icsTopicDoList);
    }

    private boolean getTotalTempDir(int docNum) {
        if (!ExportTempHelper.initConvertTempDir()) {
            return false;
        }
        String progressFileName = ConvertPathHelper.getProgressFileName((String)ExportTempHelper.getConvertTempDir());
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{progressFileName}));
        return ProgressPropertyUtils.initConvertProgressProperty((String)progressFileName, (String)(docNum + ""));
    }

    private boolean isAddExportTaskSuccess(String docId, List<ExportNodeDto> nodeList, String saveFileName, String documentType, String pidId) {
        IcsPidDo icsPidDo;
        ExportTask exportTask = new ExportTask();
        HtmlConvertDto htmlConvertDto = ExportConvertHelper.exportParamsToConvertDto(ExportTempHelper.getConvertTempDir(), docId, documentType, nodeList, saveFileName);
        if (htmlConvertDto == null) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)pidId) && (icsPidDo = IcsPidPoolServiceHandler.getInstance().getOne(docId, pidId)) != null) {
            htmlConvertDto.setFileName(icsPidDo.getPidName());
        }
        exportTask.setHtmlConvertDto(htmlConvertDto);
        exportTask.setEventBus(this.eventBus);
        this.eventBus.register((Object)exportTask);
        this.execute(exportTask);
        return true;
    }

    @Override
    public Map<String, Object> getProgress() {
        String finishNum;
        String progressFileName = ConvertPathHelper.getProgressFileName((String)ExportTempHelper.getConvertTempDir());
        File propertyFile = FileUtils.getFile((String[])new String[]{progressFileName});
        Map<String, Object> resultMap = this.validateProgressFile(propertyFile, progressFileName);
        if (MapUtils.isNotEmpty(resultMap)) {
            return resultMap;
        }
        String totalNum = ProgressPropertyUtils.getConvertProgressByProperty((String)progressFileName, (String)"totalNum");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{totalNum, finishNum = ProgressPropertyUtils.getConvertProgressByProperty((String)progressFileName, (String)"finishNum")}) || StringUtils.equals((CharSequence)totalNum, (CharSequence)"0")) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get progress but totalNum is {0},finishNum is {1}.", new Object[]{totalNum, finishNum});
            resultMap.put("processContinue", true);
            return resultMap;
        }
        String progress = this.computeProgress(Integer.parseInt(totalNum), Integer.parseInt(finishNum));
        resultMap.put("currentProgress", progress);
        return resultMap;
    }

    private synchronized Map<String, Object> validateProgressFile(File propertyFile, String progressFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.isCompleted) {
            resultMap.put("currentProgress", "100");
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Refresh progress and export completed.");
            FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{ExportTempHelper.getConvertTempDir()}));
            return resultMap;
        }
        if (this.isCancel) {
            resultMap.put("cancelSave", true);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Refresh progress and export canceled.");
            FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{ExportTempHelper.getConvertTempDir()}));
            return resultMap;
        }
        if (!propertyFile.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get progress but progress file not exists.");
            resultMap.put("successFlag", false);
            this.exitExportProcess();
            this.fullyDelConvert();
            return resultMap;
        }
        String resultFlag = ProgressPropertyUtils.getConvertProgressByProperty((String)progressFileName, (String)"successFlag");
        if (StringUtils.equals((CharSequence)resultFlag, (CharSequence)"1")) {
            resultMap.put("currentProgress", "100");
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Get export progress and task completed.");
            FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{ExportTempHelper.getConvertTempDir()}));
            this.isCompleted = true;
            return resultMap;
        }
        if (StringUtils.equals((CharSequence)resultFlag, (CharSequence)"0")) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get progress but process is fail.");
            resultMap.put("successFlag", false);
            this.exitExportProcess();
            this.fullyDelConvert();
        }
        if (StringUtils.equals((CharSequence)resultFlag, (CharSequence)"2")) {
            resultMap.put("partSave", true);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Get export progress and the document is part saved.");
        }
        return resultMap;
    }

    private void exitExportProcess() {
        SystemCommandUtils.exec((List)IcsCommonServiceHandler.getInstance().getExitCommand("icslite_export.exe"), new HashMap());
    }

    @Override
    public boolean openFile(String operateType) {
        if (!Desktop.isDesktopSupported()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Desktop is not support.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.completeSaveFileName)) {
            return false;
        }
        File savedFile = FileUtils.getFile((String[])new String[]{this.completeSaveFileName});
        if (!savedFile.exists()) {
            return false;
        }
        if (StringUtils.equals((CharSequence)operateType, (CharSequence)"1")) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("explorer.exe");
            commands.add("/select,");
            commands.add("\"" + this.completeSaveFileName + "\"");
            SystemCommandUtils.exec(commands, new HashMap());
            return true;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.open(savedFile);
            return true;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Desktop open special file or folder fail, the path is {0}.", (Throwable)e, new Object[]{this.completeSaveFileName});
            return false;
        }
    }

    @Override
    public void cancelSave() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Will cancel save page.");
        this.isCancel = true;
        this.eventBus.post((Object)"cancelSave");
        this.fullyDelConvert();
    }

    private void fullyDelConvert() {
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{this.completeSaveFileName}));
        this.completeSaveFileName = "";
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{ExportTempHelper.getConvertTempDir()}));
    }

    private String computeProgress(int totalNum, int finishNum) {
        if (finishNum >= totalNum) {
            return "90";
        }
        double progressDouble = new BigDecimal(finishNum).divide(new BigDecimal(totalNum), 5, RoundingMode.UP).multiply(new BigDecimal(90)).doubleValue();
        return String.format("%.2f", progressDouble);
    }

    private static void getMessageOfSubProcess(InputStream inputStream, StringBuilder stringBuilder) {
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.getThreadPool((String)"ProcessMessageRunnable", (int)1, (int)600, (int)30, (int)60);
        threadPoolExecutor.execute(() -> ExportServiceHandler.messageRunnable(inputStream, stringBuilder));
    }

    private static void messageRunnable(InputStream inputStream, StringBuilder stringBuilder) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, "GBK");
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Export open disk process stream read error.", (Throwable)e);
        }
    }

    private static class ExportServiceHandlerHolder {
        private static final ExportServiceHandler INSTANCE = new ExportServiceHandler();

        private ExportServiceHandlerHolder() {
        }
    }
}

