/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnav.dao;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavPathDto;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsDocnavPathDaoHandler
extends BasePool<Map<String, List<IcsDocnavPathDto>>> {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsDocnavPathDaoHandler.class);

    private IcsDocnavPathDaoHandler() {
    }

    public static IcsDocnavPathDaoHandler getInstance() {
        return IcsDocnavPathDaoHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    public void addPool(String docId, String docnavId, List<IcsDocnavPathDto> icsDocnavPathList) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "addPool");
        LinkedHashMap<String, List<IcsDocnavPathDto>> naviTreePoolMap = (LinkedHashMap<String, List<IcsDocnavPathDto>>)super.getPool(docId);
        if (naviTreePoolMap == null) {
            naviTreePoolMap = new LinkedHashMap<String, List<IcsDocnavPathDto>>();
            super.addPool(docId, naviTreePoolMap);
            super.checkPool(5);
        }
        naviTreePoolMap.put(docnavId, icsDocnavPathList);
    }

    public Map<String, List<IcsDocnavPathDto>> delPool(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delPool");
        return (Map)super.delPool(docId);
    }

    public List<IcsDocnavPathDto> getPool(String docId, String docnavId) {
        Map naviTreePoolMap = (Map)super.getPool(docId);
        if (naviTreePoolMap != null) {
            return (List)naviTreePoolMap.get(docnavId);
        }
        return new ArrayList<IcsDocnavPathDto>();
    }

    public List<IcsDocnavPathDto> getParentsNavi(String docId, String docnavId, String navitemPath) {
        ArrayList<IcsDocnavPathDto> naviItemParentsList = new ArrayList<IcsDocnavPathDto>();
        Map naviTreePoolMap = (Map)super.getPool(docId);
        if (naviTreePoolMap != null) {
            List icsDocnavPathList = Optional.ofNullable(naviTreePoolMap.get(docnavId)).orElse(new ArrayList());
            for (IcsDocnavPathDto icsDocnavPathDto : icsDocnavPathList) {
                if (!navitemPath.startsWith(icsDocnavPathDto.getNavItemPath())) continue;
                naviItemParentsList.add(icsDocnavPathDto);
            }
        }
        return naviItemParentsList;
    }

    public List<IcsDocnavPathDto> getBrotherNavi(String docId, String docnavId, String navitemPath) {
        String currentNaviItem = navitemPath.substring(0, navitemPath.length() - 1);
        int pos = currentNaviItem.lastIndexOf(".");
        String naviItemParent = "";
        if (pos != -1) {
            naviItemParent = navitemPath.substring(0, pos);
        }
        ArrayList<IcsDocnavPathDto> naviItemBrotherList = new ArrayList<IcsDocnavPathDto>();
        Map naviTreePoolMap = (Map)super.getPool(docId);
        if (MapUtils.isEmpty((Map)naviTreePoolMap)) {
            return naviItemBrotherList;
        }
        List icsDocnavPathList = Optional.ofNullable(naviTreePoolMap.get(docnavId)).orElse(new ArrayList());
        for (IcsDocnavPathDto icsDocnavPathDto : icsDocnavPathList) {
            String itemPath = icsDocnavPathDto.getNavItemPath();
            if (itemPath.length() != navitemPath.length() || !StringUtils.startsWith((CharSequence)itemPath, (CharSequence)naviItemParent)) continue;
            naviItemBrotherList.add(icsDocnavPathDto);
        }
        return naviItemBrotherList;
    }

    private static class IcsDocnavPathDaoHandlerHolder {
        private static final IcsDocnavPathDaoHandler INSTANCE = new IcsDocnavPathDaoHandler();

        private IcsDocnavPathDaoHandlerHolder() {
        }
    }
}

